/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.common;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.immutables.value.Value;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.common.StixSpecVersion;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;
import security.whisper.javastix.json.StixParsers;
import security.whisper.javastix.json.converters.dehydrated.DomainObjectOptionalConverter;
import security.whisper.javastix.json.converters.dehydrated.MarkingDefinitionSetConverter;
import security.whisper.javastix.redaction.Redactable;
import security.whisper.javastix.sdo.objects.IdentitySdo;
import security.whisper.javastix.sdo.types.ExternalReferenceType;
import security.whisper.javastix.validation.SdoDefaultValidator;
import security.whisper.javastix.validation.groups.ValidateIdOnly;

@Value.Style(validationMethod=Value.Style.ValidationMethod.NONE)
public interface StixCommonProperties
extends StixSpecVersion,
SdoDefaultValidator,
BundleableObject {
    @Override
    @NotNull
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Value.Default
    default public boolean getHydrated() {
        return true;
    }

    @Override
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$")
    @Size(min=3, max=250)
    @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Type is required")
    public @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$") @Size(min=3, max=250) @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Type is required") String getType();

    @Override
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @Pattern(regexp="^[a-z][a-z-]+[a-z]--[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
    @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Id is required")
    public @Pattern(regexp="^[a-z][a-z-]+[a-z]--[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$") @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Id is required") String getId();

    @JsonProperty(value="created_by_ref")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Represents identifiers across the CTI specifications. The format consists of the name of the top-level object being identified, followed by two dashes (--), followed by a UUIDv4.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=DomainObjectOptionalConverter.class)
    @Redactable(useMask=true, redactionMask="identity--__REDACTED__")
    public Optional<IdentitySdo> getCreatedByRef();

    @NotNull
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="The created property represents the time at which the first version of this object was created. The timstamp value MUST be precise to the nearest millisecond.")
    @Redactable(useMask=true)
    @Value.Default
    default public StixInstant getCreated() {
        return new StixInstant();
    }

    @NotNull
    @JsonProperty(value="lang")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Identifies the language of the text content in this object using ISO 639-2 language codes.")
    @Redactable
    public Optional<String> getLang();

    @JsonProperty(value="external_references")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="A list of external references which refers to non-STIX information.")
    @Redactable
    @Value.Default
    default public Set<ExternalReferenceType> getExternalReferences() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    @JsonProperty(value="object_marking_refs")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The list of marking-definition objects to be applied to this object.")
    @JsonIdentityInfo(generator=ObjectIdGenerators.PropertyGenerator.class, property="id")
    @JsonIdentityReference(alwaysAsId=true)
    @JsonDeserialize(converter=MarkingDefinitionSetConverter.class)
    @Redactable
    @Value.Default
    default public Set<MarkingDefinitionDm> getObjectMarkingRefs() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    @JsonProperty(value="granular_markings")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="The set of granular markings that apply to this object.")
    @Redactable
    @Value.Default
    default public Set<GranularMarkingDm> getGranularMarkings() {
        return Collections.emptySet();
    }

    @Override
    @JsonIgnore
    @Value.Lazy
    @Value.Auxiliary
    default public String toJsonString() {
        try {
            String jsonString = StixParsers.getJsonMapper().writeValueAsString((Object)this);
            return jsonString;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot process JSON", e);
        }
    }

    @Value.Check
    default public void checkHydrationValidation() throws ConstraintViolationException {
        if (this.getHydrated()) {
            this.validate();
        } else {
            this.validateOnlyId();
        }
    }
}

