/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import org.immutables.value.Value;
import security.whisper.javastix.validation.constraints.startswith.StartsWith;
import security.whisper.javastix.validation.groups.ValidateIdOnly;

@Value.Style(validationMethod=Value.Style.ValidationMethod.NONE)
public interface StixCustomObjectType {
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="The type property identifies the type of STIX Object (SDO, Relationship Object, etc). The value of the type field MUST be one of the types defined by a STIX Object (e.g., indicator).")
    @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$")
    @Size(min=3, max=250)
    @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Type is required1")
    public @Pattern(regexp="^\\-?[a-zA-Z0-9]+(-[a-zA-Z0-9]+)*\\-?$") @Size(min=3, max=250) @NotBlank(groups={Default.class, ValidateIdOnly.class}, message="Type is required1") @StartsWith(value="x-") String getType();
}

