/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.common;

import java.time.Instant;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import security.whisper.javastix.helpers.StixDataFormats;

public class StixInstant {
    public static final Pattern REGEX_SUBSECOND = Pattern.compile("(?<fullDate>\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(.(?<subSecond>[0-9]+))?Z)");
    private final Instant instant;
    private final int originalSubSecondPrecisionDigitCount;

    public StixInstant() {
        Instant now;
        this.instant = now = Instant.now();
        this.originalSubSecondPrecisionDigitCount = 3;
    }

    public static StixInstant now() {
        return new StixInstant();
    }

    public StixInstant(Instant instant, int subSecondPrecision) {
        Objects.requireNonNull(instant);
        if (subSecondPrecision < 0 || subSecondPrecision > 9) {
            throw new IllegalStateException("Subsecond precision must be between 0 and 9");
        }
        this.instant = instant;
        this.originalSubSecondPrecisionDigitCount = subSecondPrecision;
    }

    public StixInstant(Instant instant) {
        this(instant, String.valueOf(instant.getNano()).length());
    }

    public Instant getInstant() {
        return this.instant;
    }

    public int getOriginalSubSecondPrecisionDigitCount() {
        return this.originalSubSecondPrecisionDigitCount;
    }

    public String toString() {
        return StixDataFormats.getWriterStixDateTimeFormatter(this.originalSubSecondPrecisionDigitCount).format(this.instant);
    }

    public String toString(int subSecondPrecision) {
        return StixDataFormats.getWriterStixDateTimeFormatter(subSecondPrecision).format(this.instant);
    }

    public static StixInstant parse(String dateString) {
        Objects.requireNonNull(dateString);
        Instant instant = Instant.from(StixDataFormats.getReaderStixDateTimeFormatter().parse(dateString));
        int subSecondPrecision = StixInstant.getSubSecondDigitCount(dateString);
        return new StixInstant(instant, subSecondPrecision);
    }

    private static int getSubSecondDigitCount(String dateString) {
        Matcher matcher = REGEX_SUBSECOND.matcher(dateString);
        if (matcher.find()) {
            String subSeconds = matcher.group("subSecond");
            if (subSeconds == null) {
                return 0;
            }
            return subSeconds.length();
        }
        throw new IllegalStateException("Unable to parse date");
    }
}

