/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.validation.GenericValidation;

public interface CyberObservableObjectCommonProperties
extends GenericValidation {
    @NotBlank
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Indicates that this object is an Observable Object. The value of this property MUST be a valid Observable Object type name, but to allow for custom objects this has been removed from the schema.")
    @Pattern(regexp="^\\-?[a-z0-9]+(-[a-z0-9]+)*\\-?$")
    @Size(min=3, max=250)
    public @NotBlank @Pattern(regexp="^\\-?[a-z0-9]+(-[a-z0-9]+)*\\-?$") @Size(min=3, max=250) String getType();

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    @Value.Default
    default public Set<CyberObservableExtension> getExtensions() {
        return Collections.emptySet();
    }

    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    @Value.Default
    default public String getObservableObjectKey() {
        return UUID.randomUUID().toString();
    }

    public String getId();

    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged();
}

