/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.ArchiveFileExtensionExt;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="archive-ext")
@AllowedParents(value={FileCoo.class})
@Generated(from="ArchiveFileExtensionExt", generator="Immutables")
@Immutable
public final class ArchiveFileExtension
implements ArchiveFileExtensionExt,
Serializable {
    @Nullable
    private final String version;
    @Nullable
    private final String comment;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private ArchiveFileExtension(@Nullable String version, @Nullable String comment, String type, ImmutableMap<String, Object> customProperties) {
        this.version = version;
        this.comment = comment;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the version of the archive type used in the archive file.")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="comment")
    @JsonPropertyDescription(value="Specifies a comment included as part of the archive file.")
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final ArchiveFileExtension withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return ArchiveFileExtension.validate(new ArchiveFileExtension(newValue, this.comment, this.type, this.customProperties));
    }

    public final ArchiveFileExtension withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return ArchiveFileExtension.validate(new ArchiveFileExtension(value, this.comment, this.type, this.customProperties));
    }

    public final ArchiveFileExtension withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return ArchiveFileExtension.validate(new ArchiveFileExtension(this.version, newValue, this.type, this.customProperties));
    }

    public final ArchiveFileExtension withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return ArchiveFileExtension.validate(new ArchiveFileExtension(this.version, value, this.type, this.customProperties));
    }

    public final ArchiveFileExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return ArchiveFileExtension.validate(new ArchiveFileExtension(this.version, this.comment, value, this.customProperties));
    }

    public final ArchiveFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return ArchiveFileExtension.validate(new ArchiveFileExtension(this.version, this.comment, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ArchiveFileExtension && this.equalTo((ArchiveFileExtension)another);
    }

    private boolean equalTo(ArchiveFileExtension another) {
        return Objects.equals(this.version, another.version) && Objects.equals(this.comment, another.comment) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.comment);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ArchiveFileExtension").omitNullValues().add("version", (Object)this.version).add("comment", (Object)this.comment).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static ArchiveFileExtension validate(ArchiveFileExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static ArchiveFileExtension copyOf(ArchiveFileExtensionExt instance) {
        if (instance instanceof ArchiveFileExtension) {
            return (ArchiveFileExtension)instance;
        }
        return ArchiveFileExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ArchiveFileExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"contains_refs", "version", "comment"})
    @JsonTypeName(value="archive-ext")
    @Generated(from="ArchiveFileExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String version;
        @Nullable
        private String comment;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ArchiveFileExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof ArchiveFileExtensionExt) {
                Optional<String> commentOptional;
                instance = (ArchiveFileExtensionExt)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                if ((commentOptional = instance.getComment()).isPresent()) {
                    this.comment(commentOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @JsonPropertyDescription(value="Specifies the version of the archive type used in the archive file.")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        @JsonProperty(value="comment")
        @JsonPropertyDescription(value="Specifies a comment included as part of the archive file.")
        @CanIgnoreReturnValue
        public final Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public ArchiveFileExtension build() {
            return ArchiveFileExtension.validate(new ArchiveFileExtension(this.version, this.comment, this.type, this.customProperties.build()));
        }
    }
}

