/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.ArchiveFileExtension;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="archive-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=ArchiveFileExtension.class)
@JsonDeserialize(builder=ArchiveFileExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"contains_refs", "version", "comment"})
@JsonTypeName(value="archive-ext")
@AllowedParents(value={FileCoo.class})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface ArchiveFileExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="contains_refs")
    @JsonPropertyDescription(value="Specifies the files contained in the archive, as a reference to one or more other File Objects. The objects referenced in this list MUST be of type file-object.")
    @NotNull
    default public Set<String> getContainsRefs() {
        return null;
    }

    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the version of the archive type used in the archive file.")
    public Optional<String> getVersion();

    @JsonProperty(value="comment")
    @JsonPropertyDescription(value="Specifies a comment included as part of the archive file.")
    public Optional<String> getComment();
}

