/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.HttpRequestExtensionExt;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="http-request-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Generated(from="HttpRequestExtensionExt", generator="Immutables")
@Immutable
public final class HttpRequestExtension
implements HttpRequestExtensionExt,
Serializable {
    private final String requestMethod;
    private final String requestValue;
    @Nullable
    private final String requestVersion;
    private final ImmutableMap<String, String> requestHeader;
    @Nullable
    private final Long messageBodyLength;
    @Nullable
    private final String messageBodyDataRef;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private HttpRequestExtension(String requestMethod, String requestValue, @Nullable String requestVersion, ImmutableMap<String, String> requestHeader, @Nullable Long messageBodyLength, @Nullable String messageBodyDataRef, String type, ImmutableMap<String, Object> customProperties) {
        this.requestMethod = requestMethod;
        this.requestValue = requestValue;
        this.requestVersion = requestVersion;
        this.requestHeader = requestHeader;
        this.messageBodyLength = messageBodyLength;
        this.messageBodyDataRef = messageBodyDataRef;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="request_method")
    @JsonPropertyDescription(value="Specifies the HTTP method portion of the HTTP request line, as a lowercase string.")
    public String getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    @JsonProperty(value="request_value")
    @JsonPropertyDescription(value="Specifies the value (typically a resource path) portion of the HTTP request line.")
    public String getRequestValue() {
        return this.requestValue;
    }

    @Override
    @JsonProperty(value="request_version")
    @JsonPropertyDescription(value="Specifies the HTTP version portion of the HTTP request line, as a lowercase string.")
    public Optional<String> getRequestVersion() {
        return Optional.ofNullable(this.requestVersion);
    }

    @JsonProperty(value="request_header")
    @JsonPropertyDescription(value="Specifies all of the HTTP header fields that may be found in the HTTP client request, as a dictionary.")
    public ImmutableMap<String, String> getRequestHeader() {
        return this.requestHeader;
    }

    @Override
    @JsonProperty(value="message_body_length")
    @JsonPropertyDescription(value="Specifies the length of the HTTP message body, if included, in bytes.")
    public Optional<Long> getMessageBodyLength() {
        return Optional.ofNullable(this.messageBodyLength);
    }

    @Override
    @JsonProperty(value="message_body_data_ref")
    @JsonPropertyDescription(value="Specifies the data contained in the HTTP message body, if included.")
    public Optional<String> getMessageBodyDataRef() {
        return Optional.ofNullable(this.messageBodyDataRef);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final HttpRequestExtension withRequestMethod(String value) {
        if (Objects.equals(this.requestMethod, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(value, this.requestValue, this.requestVersion, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withRequestValue(String value) {
        if (Objects.equals(this.requestValue, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, value, this.requestVersion, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withRequestVersion(String value) {
        String newValue = Objects.requireNonNull(value, "requestVersion");
        if (Objects.equals(this.requestVersion, newValue)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, newValue, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withRequestVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.requestVersion, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, value, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withRequestHeader(Map<String, ? extends String> entries) {
        if (this.requestHeader == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, (ImmutableMap<String, String>)newValue, this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withMessageBodyLength(long value) {
        Long newValue = value;
        if (Objects.equals(this.messageBodyLength, newValue)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, newValue, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withMessageBodyLength(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.messageBodyLength, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, value, this.messageBodyDataRef, this.type, this.customProperties));
    }

    public final HttpRequestExtension withMessageBodyDataRef(String value) {
        String newValue = Objects.requireNonNull(value, "messageBodyDataRef");
        if (Objects.equals(this.messageBodyDataRef, newValue)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, this.messageBodyLength, newValue, this.type, this.customProperties));
    }

    public final HttpRequestExtension withMessageBodyDataRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.messageBodyDataRef, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, this.messageBodyLength, value, this.type, this.customProperties));
    }

    public final HttpRequestExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, value, this.customProperties));
    }

    public final HttpRequestExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader, this.messageBodyLength, this.messageBodyDataRef, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpRequestExtension && this.equalTo((HttpRequestExtension)another);
    }

    private boolean equalTo(HttpRequestExtension another) {
        return Objects.equals(this.requestMethod, another.requestMethod) && Objects.equals(this.requestValue, another.requestValue) && Objects.equals(this.requestVersion, another.requestVersion) && this.requestHeader.equals(another.requestHeader) && Objects.equals(this.messageBodyLength, another.messageBodyLength) && Objects.equals(this.messageBodyDataRef, another.messageBodyDataRef) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.requestMethod);
        h += (h << 5) + Objects.hashCode(this.requestValue);
        h += (h << 5) + Objects.hashCode(this.requestVersion);
        h += (h << 5) + this.requestHeader.hashCode();
        h += (h << 5) + Objects.hashCode(this.messageBodyLength);
        h += (h << 5) + Objects.hashCode(this.messageBodyDataRef);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"HttpRequestExtension").omitNullValues().add("requestMethod", (Object)this.requestMethod).add("requestValue", (Object)this.requestValue).add("requestVersion", (Object)this.requestVersion).add("requestHeader", this.requestHeader).add("messageBodyLength", (Object)this.messageBodyLength).add("messageBodyDataRef", (Object)this.messageBodyDataRef).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static HttpRequestExtension validate(HttpRequestExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static HttpRequestExtension copyOf(HttpRequestExtensionExt instance) {
        if (instance instanceof HttpRequestExtension) {
            return (HttpRequestExtension)instance;
        }
        return HttpRequestExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return HttpRequestExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"request_method", "request_value", "request_version", "request_header", "message_body_length", "message_body_data_ref"})
    @JsonTypeName(value="http-request-ext")
    @Generated(from="HttpRequestExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String requestMethod;
        @Nullable
        private String requestValue;
        @Nullable
        private String requestVersion;
        private ImmutableMap.Builder<String, String> requestHeader = ImmutableMap.builder();
        @Nullable
        private Long messageBodyLength;
        @Nullable
        private String messageBodyDataRef;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HttpRequestExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof HttpRequestExtensionExt) {
                String requestMethodValue;
                Optional<Long> messageBodyLengthOptional;
                Optional<String> messageBodyDataRefOptional;
                String requestValueValue;
                instance = (HttpRequestExtensionExt)object;
                this.putAllRequestHeader(instance.getRequestHeader());
                Optional<String> requestVersionOptional = instance.getRequestVersion();
                if (requestVersionOptional.isPresent()) {
                    this.requestVersion(requestVersionOptional);
                }
                if ((requestValueValue = instance.getRequestValue()) != null) {
                    this.requestValue(requestValueValue);
                }
                if ((messageBodyDataRefOptional = instance.getMessageBodyDataRef()).isPresent()) {
                    this.messageBodyDataRef(messageBodyDataRefOptional);
                }
                if ((messageBodyLengthOptional = instance.getMessageBodyLength()).isPresent()) {
                    this.messageBodyLength(messageBodyLengthOptional);
                }
                if ((requestMethodValue = instance.getRequestMethod()) != null) {
                    this.requestMethod(requestMethodValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @JsonProperty(value="request_method")
        @JsonPropertyDescription(value="Specifies the HTTP method portion of the HTTP request line, as a lowercase string.")
        @CanIgnoreReturnValue
        public final Builder requestMethod(String requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        @JsonProperty(value="request_value")
        @JsonPropertyDescription(value="Specifies the value (typically a resource path) portion of the HTTP request line.")
        @CanIgnoreReturnValue
        public final Builder requestValue(String requestValue) {
            this.requestValue = requestValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestVersion(String requestVersion) {
            this.requestVersion = Objects.requireNonNull(requestVersion, "requestVersion");
            return this;
        }

        @JsonProperty(value="request_version")
        @JsonPropertyDescription(value="Specifies the HTTP version portion of the HTTP request line, as a lowercase string.")
        @CanIgnoreReturnValue
        public final Builder requestVersion(Optional<String> requestVersion) {
            this.requestVersion = requestVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRequestHeader(String key, String value) {
            this.requestHeader.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRequestHeader(Map.Entry<String, ? extends String> entry) {
            this.requestHeader.put(entry);
            return this;
        }

        @JsonProperty(value="request_header")
        @JsonPropertyDescription(value="Specifies all of the HTTP header fields that may be found in the HTTP client request, as a dictionary.")
        @CanIgnoreReturnValue
        public final Builder requestHeader(Map<String, ? extends String> entries) {
            this.requestHeader = ImmutableMap.builder();
            return this.putAllRequestHeader(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRequestHeader(Map<String, ? extends String> entries) {
            this.requestHeader.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageBodyLength(long messageBodyLength) {
            this.messageBodyLength = messageBodyLength;
            return this;
        }

        @JsonProperty(value="message_body_length")
        @JsonPropertyDescription(value="Specifies the length of the HTTP message body, if included, in bytes.")
        @CanIgnoreReturnValue
        public final Builder messageBodyLength(Optional<Long> messageBodyLength) {
            this.messageBodyLength = messageBodyLength.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageBodyDataRef(String messageBodyDataRef) {
            this.messageBodyDataRef = Objects.requireNonNull(messageBodyDataRef, "messageBodyDataRef");
            return this;
        }

        @JsonProperty(value="message_body_data_ref")
        @JsonPropertyDescription(value="Specifies the data contained in the HTTP message body, if included.")
        @CanIgnoreReturnValue
        public final Builder messageBodyDataRef(Optional<String> messageBodyDataRef) {
            this.messageBodyDataRef = messageBodyDataRef.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public HttpRequestExtension build() {
            return HttpRequestExtension.validate(new HttpRequestExtension(this.requestMethod, this.requestValue, this.requestVersion, this.requestHeader.build(), this.messageBodyLength, this.messageBodyDataRef, this.type, this.customProperties.build()));
        }
    }
}

