/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.HttpRequestExtension;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="http-request-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=HttpRequestExtension.class)
@JsonDeserialize(builder=HttpRequestExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"request_method", "request_value", "request_version", "request_header", "message_body_length", "message_body_data_ref"})
@JsonTypeName(value="http-request-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface HttpRequestExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="request_method")
    @JsonPropertyDescription(value="Specifies the HTTP method portion of the HTTP request line, as a lowercase string.")
    @NotNull
    public String getRequestMethod();

    @JsonProperty(value="request_value")
    @JsonPropertyDescription(value="Specifies the value (typically a resource path) portion of the HTTP request line.")
    @NotNull
    public String getRequestValue();

    @JsonProperty(value="request_version")
    @JsonPropertyDescription(value="Specifies the HTTP version portion of the HTTP request line, as a lowercase string.")
    public Optional<String> getRequestVersion();

    @JsonProperty(value="request_header")
    @JsonPropertyDescription(value="Specifies all of the HTTP header fields that may be found in the HTTP client request, as a dictionary.")
    public Map<String, String> getRequestHeader();

    @JsonProperty(value="message_body_length")
    @JsonPropertyDescription(value="Specifies the length of the HTTP message body, if included, in bytes.")
    public Optional<Long> getMessageBodyLength();

    @JsonProperty(value="message_body_data_ref")
    @JsonPropertyDescription(value="Specifies the data contained in the HTTP message body, if included.")
    public Optional<String> getMessageBodyDataRef();
}

