/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.IcmpExtensionExt;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="icmp-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Generated(from="IcmpExtensionExt", generator="Immutables")
@Immutable
public final class IcmpExtension
implements IcmpExtensionExt,
Serializable {
    private final String ocmpTypeHex;
    private final String icmpCodeHex;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private IcmpExtension(String ocmpTypeHex, String icmpCodeHex, String type, ImmutableMap<String, Object> customProperties) {
        this.ocmpTypeHex = ocmpTypeHex;
        this.icmpCodeHex = icmpCodeHex;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="icmp_type_hex")
    @JsonPropertyDescription(value="Specifies the ICMP type byte.")
    public String getOcmpTypeHex() {
        return this.ocmpTypeHex;
    }

    @Override
    @JsonProperty(value="icmp_code_hex")
    @JsonPropertyDescription(value="Specifies the ICMP code byte.")
    public String getIcmpCodeHex() {
        return this.icmpCodeHex;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final IcmpExtension withOcmpTypeHex(String value) {
        if (Objects.equals(this.ocmpTypeHex, value)) {
            return this;
        }
        return IcmpExtension.validate(new IcmpExtension(value, this.icmpCodeHex, this.type, this.customProperties));
    }

    public final IcmpExtension withIcmpCodeHex(String value) {
        if (Objects.equals(this.icmpCodeHex, value)) {
            return this;
        }
        return IcmpExtension.validate(new IcmpExtension(this.ocmpTypeHex, value, this.type, this.customProperties));
    }

    public final IcmpExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return IcmpExtension.validate(new IcmpExtension(this.ocmpTypeHex, this.icmpCodeHex, value, this.customProperties));
    }

    public final IcmpExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return IcmpExtension.validate(new IcmpExtension(this.ocmpTypeHex, this.icmpCodeHex, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IcmpExtension && this.equalTo((IcmpExtension)another);
    }

    private boolean equalTo(IcmpExtension another) {
        return Objects.equals(this.ocmpTypeHex, another.ocmpTypeHex) && Objects.equals(this.icmpCodeHex, another.icmpCodeHex) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ocmpTypeHex);
        h += (h << 5) + Objects.hashCode(this.icmpCodeHex);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IcmpExtension").omitNullValues().add("ocmpTypeHex", (Object)this.ocmpTypeHex).add("icmpCodeHex", (Object)this.icmpCodeHex).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static IcmpExtension validate(IcmpExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static IcmpExtension copyOf(IcmpExtensionExt instance) {
        if (instance instanceof IcmpExtension) {
            return (IcmpExtension)instance;
        }
        return IcmpExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return IcmpExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"icmp_type_hex", "icmp_code_hex"})
    @JsonTypeName(value="icmp-ext")
    @Generated(from="IcmpExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String ocmpTypeHex;
        @Nullable
        private String icmpCodeHex;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IcmpExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof IcmpExtensionExt) {
                String icmpCodeHexValue;
                instance = (IcmpExtensionExt)object;
                String ocmpTypeHexValue = instance.getOcmpTypeHex();
                if (ocmpTypeHexValue != null) {
                    this.ocmpTypeHex(ocmpTypeHexValue);
                }
                if ((icmpCodeHexValue = instance.getIcmpCodeHex()) != null) {
                    this.icmpCodeHex(icmpCodeHexValue);
                }
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @JsonProperty(value="icmp_type_hex")
        @JsonPropertyDescription(value="Specifies the ICMP type byte.")
        @CanIgnoreReturnValue
        public final Builder ocmpTypeHex(String ocmpTypeHex) {
            this.ocmpTypeHex = ocmpTypeHex;
            return this;
        }

        @JsonProperty(value="icmp_code_hex")
        @JsonPropertyDescription(value="Specifies the ICMP code byte.")
        @CanIgnoreReturnValue
        public final Builder icmpCodeHex(String icmpCodeHex) {
            this.icmpCodeHex = icmpCodeHex;
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public IcmpExtension build() {
            return IcmpExtension.validate(new IcmpExtension(this.ocmpTypeHex, this.icmpCodeHex, this.type, this.customProperties.build()));
        }
    }
}

