/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.NetworkSocketExtensionExt;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="socket-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Generated(from="NetworkSocketExtensionExt", generator="Immutables")
@Immutable
public final class NetworkSocketExtension
implements NetworkSocketExtensionExt,
Serializable {
    private final String addressFamily;
    @Nullable
    private final Boolean blocking;
    @Nullable
    private final Boolean listening;
    @Nullable
    private final String protocolFamily;
    private final ImmutableMap<String, String> options;
    @Nullable
    private final String socketType;
    @Nullable
    private final Long socketDescriptor;
    @Nullable
    private final Long socketHandle;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private NetworkSocketExtension(String addressFamily, @Nullable Boolean blocking, @Nullable Boolean listening, @Nullable String protocolFamily, ImmutableMap<String, String> options, @Nullable String socketType, @Nullable Long socketDescriptor, @Nullable Long socketHandle, String type, ImmutableMap<String, Object> customProperties) {
        this.addressFamily = addressFamily;
        this.blocking = blocking;
        this.listening = listening;
        this.protocolFamily = protocolFamily;
        this.options = options;
        this.socketType = socketType;
        this.socketDescriptor = socketDescriptor;
        this.socketHandle = socketHandle;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="address_family")
    @JsonPropertyDescription(value="Specifies the address family (AF_*) that the socket is configured for.")
    public String getAddressFamily() {
        return this.addressFamily;
    }

    @Override
    @JsonProperty(value="is_blocking")
    @JsonPropertyDescription(value="Specifies whether the socket is in blocking mode.")
    public Optional<Boolean> getBlocking() {
        return Optional.ofNullable(this.blocking);
    }

    @Override
    @JsonProperty(value="is_listening")
    @JsonPropertyDescription(value="Specifies whether the socket is in listening mode.")
    public Optional<Boolean> getListening() {
        return Optional.ofNullable(this.listening);
    }

    @Override
    @JsonProperty(value="protocol_family")
    @JsonPropertyDescription(value="Specifies the protocol family (PF_*) that the socket is configured for.")
    public Optional<String> getProtocolFamily() {
        return Optional.ofNullable(this.protocolFamily);
    }

    @JsonProperty(value="options")
    @JsonPropertyDescription(value="Specifies any options (SO_*) that may be used by the socket, as a dictionary.")
    public ImmutableMap<String, String> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty(value="socket_type")
    @JsonPropertyDescription(value="Specifies the type of the socket.")
    public Optional<String> getSocketType() {
        return Optional.ofNullable(this.socketType);
    }

    @Override
    @JsonProperty(value="socket_descriptor")
    @JsonPropertyDescription(value="Specifies the socket file descriptor value associated with the socket, as a non-negative integer.")
    public Optional<Long> getSocketDescriptor() {
        return Optional.ofNullable(this.socketDescriptor);
    }

    @Override
    @JsonProperty(value="socket_handle")
    @JsonPropertyDescription(value="Specifies the handle or inode value associated with the socket.")
    public Optional<Long> getSocketHandle() {
        return Optional.ofNullable(this.socketHandle);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final NetworkSocketExtension withAddressFamily(String value) {
        if (Objects.equals(this.addressFamily, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(value, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withBlocking(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.blocking, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, newValue, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withBlocking(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.blocking, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, value, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withListening(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.listening, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, newValue, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withListening(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.listening, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, value, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withProtocolFamily(String value) {
        String newValue = Objects.requireNonNull(value, "protocolFamily");
        if (Objects.equals(this.protocolFamily, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, newValue, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withProtocolFamily(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.protocolFamily, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, value, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, (ImmutableMap<String, String>)newValue, this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketType(String value) {
        String newValue = Objects.requireNonNull(value, "socketType");
        if (Objects.equals(this.socketType, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, newValue, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.socketType, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, value, this.socketDescriptor, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketDescriptor(long value) {
        Long newValue = value;
        if (Objects.equals(this.socketDescriptor, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, newValue, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketDescriptor(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.socketDescriptor, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, value, this.socketHandle, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketHandle(long value) {
        Long newValue = value;
        if (Objects.equals(this.socketHandle, newValue)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, newValue, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withSocketHandle(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.socketHandle, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, value, this.type, this.customProperties));
    }

    public final NetworkSocketExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, value, this.customProperties));
    }

    public final NetworkSocketExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options, this.socketType, this.socketDescriptor, this.socketHandle, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NetworkSocketExtension && this.equalTo((NetworkSocketExtension)another);
    }

    private boolean equalTo(NetworkSocketExtension another) {
        return Objects.equals(this.addressFamily, another.addressFamily) && Objects.equals(this.blocking, another.blocking) && Objects.equals(this.listening, another.listening) && Objects.equals(this.protocolFamily, another.protocolFamily) && this.options.equals(another.options) && Objects.equals(this.socketType, another.socketType) && Objects.equals(this.socketDescriptor, another.socketDescriptor) && Objects.equals(this.socketHandle, another.socketHandle) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.addressFamily);
        h += (h << 5) + Objects.hashCode(this.blocking);
        h += (h << 5) + Objects.hashCode(this.listening);
        h += (h << 5) + Objects.hashCode(this.protocolFamily);
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + Objects.hashCode(this.socketType);
        h += (h << 5) + Objects.hashCode(this.socketDescriptor);
        h += (h << 5) + Objects.hashCode(this.socketHandle);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NetworkSocketExtension").omitNullValues().add("addressFamily", (Object)this.addressFamily).add("blocking", (Object)this.blocking).add("listening", (Object)this.listening).add("protocolFamily", (Object)this.protocolFamily).add("options", this.options).add("socketType", (Object)this.socketType).add("socketDescriptor", (Object)this.socketDescriptor).add("socketHandle", (Object)this.socketHandle).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static NetworkSocketExtension validate(NetworkSocketExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static NetworkSocketExtension copyOf(NetworkSocketExtensionExt instance) {
        if (instance instanceof NetworkSocketExtension) {
            return (NetworkSocketExtension)instance;
        }
        return NetworkSocketExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return NetworkSocketExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"address_family", "is_blocking", "is_listening", "protocol_family", "options", "socket_type", "socket_descriptor", "socket_handle"})
    @JsonTypeName(value="socket-ext")
    @Generated(from="NetworkSocketExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String addressFamily;
        @Nullable
        private Boolean blocking;
        @Nullable
        private Boolean listening;
        @Nullable
        private String protocolFamily;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        @Nullable
        private String socketType;
        @Nullable
        private Long socketDescriptor;
        @Nullable
        private Long socketHandle;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NetworkSocketExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof NetworkSocketExtensionExt) {
                Optional<Boolean> blockingOptional;
                Optional<String> protocolFamilyOptional;
                Optional<Long> socketHandleOptional;
                Optional<Long> socketDescriptorOptional;
                Optional<String> socketTypeOptional;
                instance = (NetworkSocketExtensionExt)object;
                Optional<Boolean> listeningOptional = instance.getListening();
                if (listeningOptional.isPresent()) {
                    this.listening(listeningOptional);
                }
                if ((socketTypeOptional = instance.getSocketType()).isPresent()) {
                    this.socketType(socketTypeOptional);
                }
                if ((socketDescriptorOptional = instance.getSocketDescriptor()).isPresent()) {
                    this.socketDescriptor(socketDescriptorOptional);
                }
                if ((socketHandleOptional = instance.getSocketHandle()).isPresent()) {
                    this.socketHandle(socketHandleOptional);
                }
                if ((protocolFamilyOptional = instance.getProtocolFamily()).isPresent()) {
                    this.protocolFamily(protocolFamilyOptional);
                }
                if ((blockingOptional = instance.getBlocking()).isPresent()) {
                    this.blocking(blockingOptional);
                }
                this.putAllOptions(instance.getOptions());
                String addressFamilyValue = instance.getAddressFamily();
                if (addressFamilyValue != null) {
                    this.addressFamily(addressFamilyValue);
                }
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @JsonProperty(value="address_family")
        @JsonPropertyDescription(value="Specifies the address family (AF_*) that the socket is configured for.")
        @CanIgnoreReturnValue
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        @JsonProperty(value="is_blocking")
        @JsonPropertyDescription(value="Specifies whether the socket is in blocking mode.")
        @CanIgnoreReturnValue
        public final Builder blocking(Optional<Boolean> blocking) {
            this.blocking = blocking.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder listening(boolean listening) {
            this.listening = listening;
            return this;
        }

        @JsonProperty(value="is_listening")
        @JsonPropertyDescription(value="Specifies whether the socket is in listening mode.")
        @CanIgnoreReturnValue
        public final Builder listening(Optional<Boolean> listening) {
            this.listening = listening.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder protocolFamily(String protocolFamily) {
            this.protocolFamily = Objects.requireNonNull(protocolFamily, "protocolFamily");
            return this;
        }

        @JsonProperty(value="protocol_family")
        @JsonPropertyDescription(value="Specifies the protocol family (PF_*) that the socket is configured for.")
        @CanIgnoreReturnValue
        public final Builder protocolFamily(Optional<String> protocolFamily) {
            this.protocolFamily = protocolFamily.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOption(String key, String value) {
            this.options.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOption(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            return this;
        }

        @JsonProperty(value="options")
        @JsonPropertyDescription(value="Specifies any options (SO_*) that may be used by the socket, as a dictionary.")
        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder socketType(String socketType) {
            this.socketType = Objects.requireNonNull(socketType, "socketType");
            return this;
        }

        @JsonProperty(value="socket_type")
        @JsonPropertyDescription(value="Specifies the type of the socket.")
        @CanIgnoreReturnValue
        public final Builder socketType(Optional<String> socketType) {
            this.socketType = socketType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder socketDescriptor(long socketDescriptor) {
            this.socketDescriptor = socketDescriptor;
            return this;
        }

        @JsonProperty(value="socket_descriptor")
        @JsonPropertyDescription(value="Specifies the socket file descriptor value associated with the socket, as a non-negative integer.")
        @CanIgnoreReturnValue
        public final Builder socketDescriptor(Optional<Long> socketDescriptor) {
            this.socketDescriptor = socketDescriptor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder socketHandle(long socketHandle) {
            this.socketHandle = socketHandle;
            return this;
        }

        @JsonProperty(value="socket_handle")
        @JsonPropertyDescription(value="Specifies the handle or inode value associated with the socket.")
        @CanIgnoreReturnValue
        public final Builder socketHandle(Optional<Long> socketHandle) {
            this.socketHandle = socketHandle.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public NetworkSocketExtension build() {
            return NetworkSocketExtension.validate(new NetworkSocketExtension(this.addressFamily, this.blocking, this.listening, this.protocolFamily, this.options.build(), this.socketType, this.socketDescriptor, this.socketHandle, this.type, this.customProperties.build()));
        }
    }
}

