/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.NetworkSocketExtension;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.NetworkSocketAddressFamilies;
import security.whisper.javastix.vocabulary.vocabularies.NetworkSocketProtocolFamilies;
import security.whisper.javastix.vocabulary.vocabularies.NetworkSocketTypes;

@DefaultTypeValue(value="socket-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=NetworkSocketExtension.class)
@JsonDeserialize(builder=NetworkSocketExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"address_family", "is_blocking", "is_listening", "protocol_family", "options", "socket_type", "socket_descriptor", "socket_handle"})
@JsonTypeName(value="socket-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface NetworkSocketExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="address_family")
    @JsonPropertyDescription(value="Specifies the address family (AF_*) that the socket is configured for.")
    @NotNull
    @Vocab(value=NetworkSocketAddressFamilies.class)
    public String getAddressFamily();

    @JsonProperty(value="is_blocking")
    @JsonPropertyDescription(value="Specifies whether the socket is in blocking mode.")
    @NotNull
    public Optional<Boolean> getBlocking();

    @JsonProperty(value="is_listening")
    @JsonPropertyDescription(value="Specifies whether the socket is in listening mode.")
    @NotNull
    public Optional<Boolean> getListening();

    @JsonProperty(value="protocol_family")
    @JsonPropertyDescription(value="Specifies the protocol family (PF_*) that the socket is configured for.")
    public Optional<@Vocab(value=NetworkSocketProtocolFamilies.class) String> getProtocolFamily();

    @JsonProperty(value="options")
    @JsonPropertyDescription(value="Specifies any options (SO_*) that may be used by the socket, as a dictionary.")
    public Map<String, String> getOptions();

    @JsonProperty(value="socket_type")
    @JsonPropertyDescription(value="Specifies the type of the socket.")
    public Optional<@Vocab(value=NetworkSocketTypes.class) String> getSocketType();

    @JsonProperty(value="socket_descriptor")
    @JsonPropertyDescription(value="Specifies the socket file descriptor value associated with the socket, as a non-negative integer.")
    public Optional<@PositiveOrZero Long> getSocketDescriptor();

    @JsonProperty(value="socket_handle")
    @JsonPropertyDescription(value="Specifies the handle or inode value associated with the socket.")
    public Optional<Long> getSocketHandle();
}

