/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.NtfsFileExtenstionExt;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="ntfs-ext")
@AllowedParents(value={FileCoo.class})
@Generated(from="NtfsFileExtenstionExt", generator="Immutables")
@Immutable
public final class NtfsFileExtenstion
implements NtfsFileExtenstionExt,
Serializable {
    @Nullable
    private final String sid;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private NtfsFileExtenstion(@Nullable String sid, String type, ImmutableMap<String, Object> customProperties) {
        this.sid = sid;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="sid")
    @JsonPropertyDescription(value="Specifies the security ID (SID) value assigned to the file.")
    public Optional<String> getSid() {
        return Optional.ofNullable(this.sid);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final NtfsFileExtenstion withSid(String value) {
        String newValue = Objects.requireNonNull(value, "sid");
        if (Objects.equals(this.sid, newValue)) {
            return this;
        }
        return NtfsFileExtenstion.validate(new NtfsFileExtenstion(newValue, this.type, this.customProperties));
    }

    public final NtfsFileExtenstion withSid(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.sid, value)) {
            return this;
        }
        return NtfsFileExtenstion.validate(new NtfsFileExtenstion(value, this.type, this.customProperties));
    }

    public final NtfsFileExtenstion withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return NtfsFileExtenstion.validate(new NtfsFileExtenstion(this.sid, value, this.customProperties));
    }

    public final NtfsFileExtenstion withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NtfsFileExtenstion.validate(new NtfsFileExtenstion(this.sid, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NtfsFileExtenstion && this.equalTo((NtfsFileExtenstion)another);
    }

    private boolean equalTo(NtfsFileExtenstion another) {
        return Objects.equals(this.sid, another.sid) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sid);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NtfsFileExtenstion").omitNullValues().add("sid", (Object)this.sid).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static NtfsFileExtenstion validate(NtfsFileExtenstion instance) {
        instance.validateEntity();
        return instance;
    }

    public static NtfsFileExtenstion copyOf(NtfsFileExtenstionExt instance) {
        if (instance instanceof NtfsFileExtenstion) {
            return (NtfsFileExtenstion)instance;
        }
        return NtfsFileExtenstion.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return NtfsFileExtenstion.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"sid", "alternate_data_streams"})
    @JsonTypeName(value="ntfs-ext")
    @Generated(from="NtfsFileExtenstionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String sid;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NtfsFileExtenstionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            Optional<String> sidOptional;
            if (object instanceof NtfsFileExtenstionExt && (sidOptional = (instance = (NtfsFileExtenstionExt)object).getSid()).isPresent()) {
                this.sid(sidOptional);
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder sid(String sid) {
            this.sid = Objects.requireNonNull(sid, "sid");
            return this;
        }

        @JsonProperty(value="sid")
        @JsonPropertyDescription(value="Specifies the security ID (SID) value assigned to the file.")
        @CanIgnoreReturnValue
        public final Builder sid(Optional<String> sid) {
            this.sid = sid.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public NtfsFileExtenstion build() {
            return NtfsFileExtenstion.validate(new NtfsFileExtenstion(this.sid, this.type, this.customProperties.build()));
        }
    }
}

