/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.NtfsFileExtenstion;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.coo.types.NtfsAlternateDataStreamObj;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="ntfs-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=NtfsFileExtenstion.class)
@JsonDeserialize(builder=NtfsFileExtenstion.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"sid", "alternate_data_streams"})
@JsonTypeName(value="ntfs-ext")
@AllowedParents(value={FileCoo.class})
@BusinessRule(ifExp="true", thenExp="getSid().isPresent() == true || getAlternateDataStreams().isEmpty() == false", errorMessage="NTFS File Extension MUST contain at least one property from this extension")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface NtfsFileExtenstionExt
extends CyberObservableExtension {
    @JsonProperty(value="sid")
    @JsonPropertyDescription(value="Specifies the security ID (SID) value assigned to the file.")
    public Optional<String> getSid();

    @JsonProperty(value="alternate_data_streams")
    @JsonPropertyDescription(value="Specifies a list of NTFS alternate data streams that exist for the file.")
    default public Set<NtfsAlternateDataStreamObj> getAlternateDataStreams() {
        return null;
    }
}

