/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.PdfFileExtensionExt;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="pdf-ext")
@AllowedParents(value={FileCoo.class})
@Generated(from="PdfFileExtensionExt", generator="Immutables")
@Immutable
public final class PdfFileExtension
implements PdfFileExtensionExt,
Serializable {
    @Nullable
    private final String version;
    @Nullable
    private final Boolean isOptimized;
    private final ImmutableMap<String, String> documentInfoDict;
    @Nullable
    private final String pdfId0;
    @Nullable
    private final String pdfId1;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private PdfFileExtension(@Nullable String version, @Nullable Boolean isOptimized, ImmutableMap<String, String> documentInfoDict, @Nullable String pdfId0, @Nullable String pdfId1, String type, ImmutableMap<String, Object> customProperties) {
        this.version = version;
        this.isOptimized = isOptimized;
        this.documentInfoDict = documentInfoDict;
        this.pdfId0 = pdfId0;
        this.pdfId1 = pdfId1;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the decimal version number of the Optional<String> from the PDF header that specifies the version of the PDF specification to which the PDF file conforms. E.g., '1.4'.")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="is_optimized")
    @JsonPropertyDescription(value="Specifies whether the PDF file has been optimized.")
    public Optional<Boolean> isOptimized() {
        return Optional.ofNullable(this.isOptimized);
    }

    @JsonProperty(value="document_info_dict")
    @JsonPropertyDescription(value="Specifies details of the PDF document information dictionary (DID), which includes properties like the document creation data and producer, as a dictionary.")
    public ImmutableMap<String, String> getDocumentInfoDict() {
        return this.documentInfoDict;
    }

    @Override
    @JsonProperty(value="pdfid0")
    @JsonPropertyDescription(value="Specifies the first file identifier found for the PDF file.")
    public Optional<String> getPdfId0() {
        return Optional.ofNullable(this.pdfId0);
    }

    @Override
    @JsonProperty(value="pdfid1")
    @JsonPropertyDescription(value="Specifies the second file identifier found for the PDF file.")
    public Optional<String> getPdfId1() {
        return Optional.ofNullable(this.pdfId1);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final PdfFileExtension withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(newValue, this.isOptimized, this.documentInfoDict, this.pdfId0, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(value, this.isOptimized, this.documentInfoDict, this.pdfId0, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withIsOptimized(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isOptimized, newValue)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, newValue, this.documentInfoDict, this.pdfId0, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withIsOptimized(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isOptimized, value)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, value, this.documentInfoDict, this.pdfId0, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withDocumentInfoDict(Map<String, ? extends String> entries) {
        if (this.documentInfoDict == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, (ImmutableMap<String, String>)newValue, this.pdfId0, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withPdfId0(String value) {
        String newValue = Objects.requireNonNull(value, "pdfId0");
        if (Objects.equals(this.pdfId0, newValue)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, newValue, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withPdfId0(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pdfId0, value)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, value, this.pdfId1, this.type, this.customProperties));
    }

    public final PdfFileExtension withPdfId1(String value) {
        String newValue = Objects.requireNonNull(value, "pdfId1");
        if (Objects.equals(this.pdfId1, newValue)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, this.pdfId0, newValue, this.type, this.customProperties));
    }

    public final PdfFileExtension withPdfId1(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pdfId1, value)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, this.pdfId0, value, this.type, this.customProperties));
    }

    public final PdfFileExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, this.pdfId0, this.pdfId1, value, this.customProperties));
    }

    public final PdfFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict, this.pdfId0, this.pdfId1, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PdfFileExtension && this.equalTo((PdfFileExtension)another);
    }

    private boolean equalTo(PdfFileExtension another) {
        return Objects.equals(this.version, another.version) && Objects.equals(this.isOptimized, another.isOptimized) && this.documentInfoDict.equals(another.documentInfoDict) && Objects.equals(this.pdfId0, another.pdfId0) && Objects.equals(this.pdfId1, another.pdfId1) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.isOptimized);
        h += (h << 5) + this.documentInfoDict.hashCode();
        h += (h << 5) + Objects.hashCode(this.pdfId0);
        h += (h << 5) + Objects.hashCode(this.pdfId1);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PdfFileExtension").omitNullValues().add("version", (Object)this.version).add("isOptimized", (Object)this.isOptimized).add("documentInfoDict", this.documentInfoDict).add("pdfId0", (Object)this.pdfId0).add("pdfId1", (Object)this.pdfId1).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static PdfFileExtension validate(PdfFileExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static PdfFileExtension copyOf(PdfFileExtensionExt instance) {
        if (instance instanceof PdfFileExtension) {
            return (PdfFileExtension)instance;
        }
        return PdfFileExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return PdfFileExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"version", "is_optimized", "document_info_dict", "pdfid0", "pdfid1"})
    @JsonTypeName(value="pdf-ext")
    @Generated(from="PdfFileExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String version;
        @Nullable
        private Boolean isOptimized;
        private ImmutableMap.Builder<String, String> documentInfoDict = ImmutableMap.builder();
        @Nullable
        private String pdfId0;
        @Nullable
        private String pdfId1;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PdfFileExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof PdfFileExtensionExt) {
                Optional<String> versionOptional;
                Optional<String> pdfId0Optional;
                Optional<String> pdfId1Optional;
                instance = (PdfFileExtensionExt)object;
                Optional<Boolean> isOptimizedOptional = instance.isOptimized();
                if (isOptimizedOptional.isPresent()) {
                    this.isOptimized(isOptimizedOptional);
                }
                if ((pdfId1Optional = instance.getPdfId1()).isPresent()) {
                    this.pdfId1(pdfId1Optional);
                }
                if ((pdfId0Optional = instance.getPdfId0()).isPresent()) {
                    this.pdfId0(pdfId0Optional);
                }
                if ((versionOptional = instance.getVersion()).isPresent()) {
                    this.version(versionOptional);
                }
                this.putAllDocumentInfoDict(instance.getDocumentInfoDict());
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @JsonPropertyDescription(value="Specifies the decimal version number of the Optional<String> from the PDF header that specifies the version of the PDF specification to which the PDF file conforms. E.g., '1.4'.")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isOptimized(boolean isOptimized) {
            this.isOptimized = isOptimized;
            return this;
        }

        @JsonProperty(value="is_optimized")
        @JsonPropertyDescription(value="Specifies whether the PDF file has been optimized.")
        @CanIgnoreReturnValue
        public final Builder isOptimized(Optional<Boolean> isOptimized) {
            this.isOptimized = isOptimized.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDocumentInfoDict(String key, String value) {
            this.documentInfoDict.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDocumentInfoDict(Map.Entry<String, ? extends String> entry) {
            this.documentInfoDict.put(entry);
            return this;
        }

        @JsonProperty(value="document_info_dict")
        @JsonPropertyDescription(value="Specifies details of the PDF document information dictionary (DID), which includes properties like the document creation data and producer, as a dictionary.")
        @CanIgnoreReturnValue
        public final Builder documentInfoDict(Map<String, ? extends String> entries) {
            this.documentInfoDict = ImmutableMap.builder();
            return this.putAllDocumentInfoDict(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllDocumentInfoDict(Map<String, ? extends String> entries) {
            this.documentInfoDict.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pdfId0(String pdfId0) {
            this.pdfId0 = Objects.requireNonNull(pdfId0, "pdfId0");
            return this;
        }

        @JsonProperty(value="pdfid0")
        @JsonPropertyDescription(value="Specifies the first file identifier found for the PDF file.")
        @CanIgnoreReturnValue
        public final Builder pdfId0(Optional<String> pdfId0) {
            this.pdfId0 = pdfId0.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pdfId1(String pdfId1) {
            this.pdfId1 = Objects.requireNonNull(pdfId1, "pdfId1");
            return this;
        }

        @JsonProperty(value="pdfid1")
        @JsonPropertyDescription(value="Specifies the second file identifier found for the PDF file.")
        @CanIgnoreReturnValue
        public final Builder pdfId1(Optional<String> pdfId1) {
            this.pdfId1 = pdfId1.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public PdfFileExtension build() {
            return PdfFileExtension.validate(new PdfFileExtension(this.version, this.isOptimized, this.documentInfoDict.build(), this.pdfId0, this.pdfId1, this.type, this.customProperties.build()));
        }
    }
}

