/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.PdfFileExtension;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="pdf-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=PdfFileExtension.class)
@JsonDeserialize(builder=PdfFileExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"version", "is_optimized", "document_info_dict", "pdfid0", "pdfid1"})
@JsonTypeName(value="pdf-ext")
@AllowedParents(value={FileCoo.class})
@BusinessRule(ifExp="true", thenExp="getVersion().isPresent() == true || isOptimized().isPresent() == true || getDocumentInfoDict().isEmpty() == false || getPdfId0().isPresent() == true || getPdfId1().isPresent() == true", errorMessage="At least 1 field must be used in PDF Extension.")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface PdfFileExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the decimal version number of the Optional<String> from the PDF header that specifies the version of the PDF specification to which the PDF file conforms. E.g., '1.4'.")
    public Optional<String> getVersion();

    @JsonProperty(value="is_optimized")
    @JsonPropertyDescription(value="Specifies whether the PDF file has been optimized.")
    @NotNull
    public Optional<Boolean> isOptimized();

    @JsonProperty(value="document_info_dict")
    @JsonPropertyDescription(value="Specifies details of the PDF document information dictionary (DID), which includes properties like the document creation data and producer, as a dictionary.")
    public Map<String, String> getDocumentInfoDict();

    @JsonProperty(value="pdfid0")
    @JsonPropertyDescription(value="Specifies the first file identifier found for the PDF file.")
    public Optional<String> getPdfId0();

    @JsonProperty(value="pdfid1")
    @JsonPropertyDescription(value="Specifies the second file identifier found for the PDF file.")
    public Optional<String> getPdfId1();
}

