/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.RasterImageFileExtensionExt;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="raster-image-ext")
@AllowedParents(value={FileCoo.class})
@Generated(from="RasterImageFileExtensionExt", generator="Immutables")
@Immutable
public final class RasterImageFileExtension
implements RasterImageFileExtensionExt,
Serializable {
    @Nullable
    private final Long imageHeight;
    @Nullable
    private final Long imageWidth;
    @Nullable
    private final Long bitsPerPixel;
    @Nullable
    private final String imageCompressionAlgorithm;
    private final ImmutableMap<String, Object> exifTags;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private RasterImageFileExtension(@Nullable Long imageHeight, @Nullable Long imageWidth, @Nullable Long bitsPerPixel, @Nullable String imageCompressionAlgorithm, ImmutableMap<String, Object> exifTags, String type, ImmutableMap<String, Object> customProperties) {
        this.imageHeight = imageHeight;
        this.imageWidth = imageWidth;
        this.bitsPerPixel = bitsPerPixel;
        this.imageCompressionAlgorithm = imageCompressionAlgorithm;
        this.exifTags = exifTags;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="image_height")
    @JsonPropertyDescription(value="Specifies the height of the image in the image file, in pixels.")
    public Optional<Long> getImageHeight() {
        return Optional.ofNullable(this.imageHeight);
    }

    @Override
    @JsonProperty(value="image_width")
    @JsonPropertyDescription(value="Specifies the width of the image in the image file, in pixels.")
    public Optional<Long> getImageWidth() {
        return Optional.ofNullable(this.imageWidth);
    }

    @Override
    @JsonProperty(value="bits_per_pixel")
    @JsonPropertyDescription(value="Specifies the sum of bits used for each color channel in the image in the image file, and thus the total number of pixels used for expressing the color depth of the image.")
    public Optional<Long> getBitsPerPixel() {
        return Optional.ofNullable(this.bitsPerPixel);
    }

    @Override
    @JsonProperty(value="image_compression_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the compression algorithm used to compress the image in the image file, if applicable.")
    public Optional<String> getImageCompressionAlgorithm() {
        return Optional.ofNullable(this.imageCompressionAlgorithm);
    }

    @JsonProperty(value="exif_tags")
    @JsonPropertyDescription(value="Specifies the set of EXIF tags found in the image file, as a dictionary. Each key/value pair in the dictionary represents the name/value of a single EXIF tag.")
    public ImmutableMap<String, Object> getExifTags() {
        return this.exifTags;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final RasterImageFileExtension withImageHeight(long value) {
        Long newValue = value;
        if (Objects.equals(this.imageHeight, newValue)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(newValue, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withImageHeight(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.imageHeight, value)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(value, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withImageWidth(long value) {
        Long newValue = value;
        if (Objects.equals(this.imageWidth, newValue)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, newValue, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withImageWidth(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.imageWidth, value)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, value, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withBitsPerPixel(long value) {
        Long newValue = value;
        if (Objects.equals(this.bitsPerPixel, newValue)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, newValue, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withBitsPerPixel(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.bitsPerPixel, value)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, value, this.imageCompressionAlgorithm, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withImageCompressionAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "imageCompressionAlgorithm");
        if (Objects.equals(this.imageCompressionAlgorithm, newValue)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, newValue, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withImageCompressionAlgorithm(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.imageCompressionAlgorithm, value)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, value, this.exifTags, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withExifTags(Map<String, ? extends Object> entries) {
        if (this.exifTags == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, (ImmutableMap<String, Object>)newValue, this.type, this.customProperties));
    }

    public final RasterImageFileExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, value, this.customProperties));
    }

    public final RasterImageFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RasterImageFileExtension && this.equalTo((RasterImageFileExtension)another);
    }

    private boolean equalTo(RasterImageFileExtension another) {
        return Objects.equals(this.imageHeight, another.imageHeight) && Objects.equals(this.imageWidth, another.imageWidth) && Objects.equals(this.bitsPerPixel, another.bitsPerPixel) && Objects.equals(this.imageCompressionAlgorithm, another.imageCompressionAlgorithm) && this.exifTags.equals(another.exifTags) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.imageHeight);
        h += (h << 5) + Objects.hashCode(this.imageWidth);
        h += (h << 5) + Objects.hashCode(this.bitsPerPixel);
        h += (h << 5) + Objects.hashCode(this.imageCompressionAlgorithm);
        h += (h << 5) + this.exifTags.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RasterImageFileExtension").omitNullValues().add("imageHeight", (Object)this.imageHeight).add("imageWidth", (Object)this.imageWidth).add("bitsPerPixel", (Object)this.bitsPerPixel).add("imageCompressionAlgorithm", (Object)this.imageCompressionAlgorithm).add("exifTags", this.exifTags).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static RasterImageFileExtension validate(RasterImageFileExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static RasterImageFileExtension copyOf(RasterImageFileExtensionExt instance) {
        if (instance instanceof RasterImageFileExtension) {
            return (RasterImageFileExtension)instance;
        }
        return RasterImageFileExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return RasterImageFileExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"image_height", "image_width", "bits_per_pixel", "image_compression_algorithm", "exif_tags"})
    @JsonTypeName(value="raster-image-ext")
    @Generated(from="RasterImageFileExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long imageHeight;
        @Nullable
        private Long imageWidth;
        @Nullable
        private Long bitsPerPixel;
        @Nullable
        private String imageCompressionAlgorithm;
        private ImmutableMap.Builder<String, Object> exifTags = ImmutableMap.builder();
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RasterImageFileExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
            if (object instanceof RasterImageFileExtensionExt) {
                Optional<Long> bitsPerPixelOptional;
                Optional<String> imageCompressionAlgorithmOptional;
                instance = (RasterImageFileExtensionExt)object;
                Optional<Long> imageWidthOptional = instance.getImageWidth();
                if (imageWidthOptional.isPresent()) {
                    this.imageWidth(imageWidthOptional);
                }
                if ((imageCompressionAlgorithmOptional = instance.getImageCompressionAlgorithm()).isPresent()) {
                    this.imageCompressionAlgorithm(imageCompressionAlgorithmOptional);
                }
                this.putAllExifTags(instance.getExifTags());
                Optional<Long> imageHeightOptional = instance.getImageHeight();
                if (imageHeightOptional.isPresent()) {
                    this.imageHeight(imageHeightOptional);
                }
                if ((bitsPerPixelOptional = instance.getBitsPerPixel()).isPresent()) {
                    this.bitsPerPixel(bitsPerPixelOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder imageHeight(long imageHeight) {
            this.imageHeight = imageHeight;
            return this;
        }

        @JsonProperty(value="image_height")
        @JsonPropertyDescription(value="Specifies the height of the image in the image file, in pixels.")
        @CanIgnoreReturnValue
        public final Builder imageHeight(Optional<Long> imageHeight) {
            this.imageHeight = imageHeight.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder imageWidth(long imageWidth) {
            this.imageWidth = imageWidth;
            return this;
        }

        @JsonProperty(value="image_width")
        @JsonPropertyDescription(value="Specifies the width of the image in the image file, in pixels.")
        @CanIgnoreReturnValue
        public final Builder imageWidth(Optional<Long> imageWidth) {
            this.imageWidth = imageWidth.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bitsPerPixel(long bitsPerPixel) {
            this.bitsPerPixel = bitsPerPixel;
            return this;
        }

        @JsonProperty(value="bits_per_pixel")
        @JsonPropertyDescription(value="Specifies the sum of bits used for each color channel in the image in the image file, and thus the total number of pixels used for expressing the color depth of the image.")
        @CanIgnoreReturnValue
        public final Builder bitsPerPixel(Optional<Long> bitsPerPixel) {
            this.bitsPerPixel = bitsPerPixel.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder imageCompressionAlgorithm(String imageCompressionAlgorithm) {
            this.imageCompressionAlgorithm = Objects.requireNonNull(imageCompressionAlgorithm, "imageCompressionAlgorithm");
            return this;
        }

        @JsonProperty(value="image_compression_algorithm")
        @JsonPropertyDescription(value="Specifies the name of the compression algorithm used to compress the image in the image file, if applicable.")
        @CanIgnoreReturnValue
        public final Builder imageCompressionAlgorithm(Optional<String> imageCompressionAlgorithm) {
            this.imageCompressionAlgorithm = imageCompressionAlgorithm.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExifTag(String key, Object value) {
            this.exifTags.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExifTag(Map.Entry<String, ? extends Object> entry) {
            this.exifTags.put(entry);
            return this;
        }

        @JsonProperty(value="exif_tags")
        @JsonPropertyDescription(value="Specifies the set of EXIF tags found in the image file, as a dictionary. Each key/value pair in the dictionary represents the name/value of a single EXIF tag.")
        @CanIgnoreReturnValue
        public final Builder exifTags(Map<String, ? extends Object> entries) {
            this.exifTags = ImmutableMap.builder();
            return this.putAllExifTags(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExifTags(Map<String, ? extends Object> entries) {
            this.exifTags.putAll(entries);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public RasterImageFileExtension build() {
            return RasterImageFileExtension.validate(new RasterImageFileExtension(this.imageHeight, this.imageWidth, this.bitsPerPixel, this.imageCompressionAlgorithm, this.exifTags.build(), this.type, this.customProperties.build()));
        }
    }
}

