/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.RasterImageFileExtension;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="raster-image-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=RasterImageFileExtension.class)
@JsonDeserialize(builder=RasterImageFileExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"image_height", "image_width", "bits_per_pixel", "image_compression_algorithm", "exif_tags"})
@JsonTypeName(value="raster-image-ext")
@AllowedParents(value={FileCoo.class})
@BusinessRule(ifExp="true", thenExp="getImageHeight().isPresent() == true || getImageWidth().isPresent() == true || getBitsPerPixel().isPresent() == false || getImageCompressionAlgorithm().isPresent() == true || getExifTags().isEmpty() == true", errorMessage="At least 1 field must be used in Raster Image File Extension.")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface RasterImageFileExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="image_height")
    @JsonPropertyDescription(value="Specifies the height of the image in the image file, in pixels.")
    public Optional<Long> getImageHeight();

    @JsonProperty(value="image_width")
    @JsonPropertyDescription(value="Specifies the width of the image in the image file, in pixels.")
    public Optional<Long> getImageWidth();

    @JsonProperty(value="bits_per_pixel")
    @JsonPropertyDescription(value="Specifies the sum of bits used for each color channel in the image in the image file, and thus the total number of pixels used for expressing the color depth of the image.")
    public Optional<Long> getBitsPerPixel();

    @JsonProperty(value="image_compression_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the compression algorithm used to compress the image in the image file, if applicable.")
    public Optional<String> getImageCompressionAlgorithm();

    @JsonProperty(value="exif_tags")
    @JsonPropertyDescription(value="Specifies the set of EXIF tags found in the image file, as a dictionary. Each key/value pair in the dictionary represents the name/value of a single EXIF tag.")
    public Map<String, Object> getExifTags();
}

