/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.TcpExtensionExt;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="tcp-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@Generated(from="TcpExtensionExt", generator="Immutables")
@Immutable
public final class TcpExtension
implements TcpExtensionExt,
Serializable {
    @Nullable
    private final String srcFlagsHex;
    @Nullable
    private final String dstFlagsHex;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private TcpExtension(@Nullable String srcFlagsHex, @Nullable String dstFlagsHex, String type, ImmutableMap<String, Object> customProperties) {
        this.srcFlagsHex = srcFlagsHex;
        this.dstFlagsHex = dstFlagsHex;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="src_flags_hex")
    @JsonPropertyDescription(value="Specifies the source TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property). ")
    public Optional<String> getSrcFlagsHex() {
        return Optional.ofNullable(this.srcFlagsHex);
    }

    @Override
    @JsonProperty(value="dst_flags_hex")
    @JsonPropertyDescription(value="Specifies the destination TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property).")
    public Optional<String> getDstFlagsHex() {
        return Optional.ofNullable(this.dstFlagsHex);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final TcpExtension withSrcFlagsHex(String value) {
        String newValue = Objects.requireNonNull(value, "srcFlagsHex");
        if (Objects.equals(this.srcFlagsHex, newValue)) {
            return this;
        }
        return TcpExtension.validate(new TcpExtension(newValue, this.dstFlagsHex, this.type, this.customProperties));
    }

    public final TcpExtension withSrcFlagsHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.srcFlagsHex, value)) {
            return this;
        }
        return TcpExtension.validate(new TcpExtension(value, this.dstFlagsHex, this.type, this.customProperties));
    }

    public final TcpExtension withDstFlagsHex(String value) {
        String newValue = Objects.requireNonNull(value, "dstFlagsHex");
        if (Objects.equals(this.dstFlagsHex, newValue)) {
            return this;
        }
        return TcpExtension.validate(new TcpExtension(this.srcFlagsHex, newValue, this.type, this.customProperties));
    }

    public final TcpExtension withDstFlagsHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dstFlagsHex, value)) {
            return this;
        }
        return TcpExtension.validate(new TcpExtension(this.srcFlagsHex, value, this.type, this.customProperties));
    }

    public final TcpExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return TcpExtension.validate(new TcpExtension(this.srcFlagsHex, this.dstFlagsHex, value, this.customProperties));
    }

    public final TcpExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return TcpExtension.validate(new TcpExtension(this.srcFlagsHex, this.dstFlagsHex, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TcpExtension && this.equalTo((TcpExtension)another);
    }

    private boolean equalTo(TcpExtension another) {
        return Objects.equals(this.srcFlagsHex, another.srcFlagsHex) && Objects.equals(this.dstFlagsHex, another.dstFlagsHex) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.srcFlagsHex);
        h += (h << 5) + Objects.hashCode(this.dstFlagsHex);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TcpExtension").omitNullValues().add("srcFlagsHex", (Object)this.srcFlagsHex).add("dstFlagsHex", (Object)this.dstFlagsHex).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static TcpExtension validate(TcpExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static TcpExtension copyOf(TcpExtensionExt instance) {
        if (instance instanceof TcpExtension) {
            return (TcpExtension)instance;
        }
        return TcpExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return TcpExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"src_flags_hex", "dst_flags_hex"})
    @JsonTypeName(value="tcp-ext")
    @Generated(from="TcpExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String srcFlagsHex;
        @Nullable
        private String dstFlagsHex;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TcpExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof TcpExtensionExt) {
                Optional<String> dstFlagsHexOptional;
                instance = (TcpExtensionExt)object;
                Optional<String> srcFlagsHexOptional = instance.getSrcFlagsHex();
                if (srcFlagsHexOptional.isPresent()) {
                    this.srcFlagsHex(srcFlagsHexOptional);
                }
                if ((dstFlagsHexOptional = instance.getDstFlagsHex()).isPresent()) {
                    this.dstFlagsHex(dstFlagsHexOptional);
                }
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder srcFlagsHex(String srcFlagsHex) {
            this.srcFlagsHex = Objects.requireNonNull(srcFlagsHex, "srcFlagsHex");
            return this;
        }

        @JsonProperty(value="src_flags_hex")
        @JsonPropertyDescription(value="Specifies the source TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property). ")
        @CanIgnoreReturnValue
        public final Builder srcFlagsHex(Optional<String> srcFlagsHex) {
            this.srcFlagsHex = srcFlagsHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstFlagsHex(String dstFlagsHex) {
            this.dstFlagsHex = Objects.requireNonNull(dstFlagsHex, "dstFlagsHex");
            return this;
        }

        @JsonProperty(value="dst_flags_hex")
        @JsonPropertyDescription(value="Specifies the destination TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property).")
        @CanIgnoreReturnValue
        public final Builder dstFlagsHex(Optional<String> dstFlagsHex) {
            this.dstFlagsHex = dstFlagsHex.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public TcpExtension build() {
            return TcpExtension.validate(new TcpExtension(this.srcFlagsHex, this.dstFlagsHex, this.type, this.customProperties.build()));
        }
    }
}

