/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.TcpExtension;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="tcp-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=TcpExtension.class)
@JsonDeserialize(builder=TcpExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"src_flags_hex", "dst_flags_hex"})
@JsonTypeName(value="tcp-ext")
@AllowedParents(value={NetworkTrafficCoo.class})
@BusinessRule(ifExp="true", thenExp="getSrcFlagsHex().isPresent() == true || getDstFlagsHex().isPresent() == true", errorMessage="TCP Extension MUST contain at least one property from this extension")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface TcpExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="src_flags_hex")
    @JsonPropertyDescription(value="Specifies the source TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property). ")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getSrcFlagsHex();

    @JsonProperty(value="dst_flags_hex")
    @JsonPropertyDescription(value="Specifies the destination TCP flags, as the union of all TCP flags observed between the start of the traffic (as defined by the start property) and the end of the traffic (as defined by the end property).")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getDstFlagsHex();
}

