/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.UnixAccountExtensionExt;
import security.whisper.javastix.coo.objects.UserAccountCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="unix-account-ext")
@AllowedParents(value={UserAccountCoo.class})
@Generated(from="UnixAccountExtensionExt", generator="Immutables")
@Immutable
public final class UnixAccountExtension
implements UnixAccountExtensionExt,
Serializable {
    @Nullable
    private final Long gid;
    @Nullable
    private final String homeDir;
    @Nullable
    private final String shell;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private UnixAccountExtension(@Nullable Long gid, @Nullable String homeDir, @Nullable String shell, String type, ImmutableMap<String, Object> customProperties) {
        this.gid = gid;
        this.homeDir = homeDir;
        this.shell = shell;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="gid")
    @JsonPropertyDescription(value="Specifies the primary group ID of the account.")
    public Optional<Long> getGid() {
        return Optional.ofNullable(this.gid);
    }

    @Override
    @JsonProperty(value="home_dir")
    @JsonPropertyDescription(value="Specifies the home directory of the account.")
    public Optional<String> getHomeDir() {
        return Optional.ofNullable(this.homeDir);
    }

    @Override
    @JsonProperty(value="shell")
    @JsonPropertyDescription(value="Specifies the account\u2019s command shell.")
    public Optional<String> getShell() {
        return Optional.ofNullable(this.shell);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final UnixAccountExtension withGid(long value) {
        Long newValue = value;
        if (Objects.equals(this.gid, newValue)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(newValue, this.homeDir, this.shell, this.type, this.customProperties));
    }

    public final UnixAccountExtension withGid(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.gid, value)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(value, this.homeDir, this.shell, this.type, this.customProperties));
    }

    public final UnixAccountExtension withHomeDir(String value) {
        String newValue = Objects.requireNonNull(value, "homeDir");
        if (Objects.equals(this.homeDir, newValue)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, newValue, this.shell, this.type, this.customProperties));
    }

    public final UnixAccountExtension withHomeDir(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.homeDir, value)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, value, this.shell, this.type, this.customProperties));
    }

    public final UnixAccountExtension withShell(String value) {
        String newValue = Objects.requireNonNull(value, "shell");
        if (Objects.equals(this.shell, newValue)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, this.homeDir, newValue, this.type, this.customProperties));
    }

    public final UnixAccountExtension withShell(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.shell, value)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, this.homeDir, value, this.type, this.customProperties));
    }

    public final UnixAccountExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, this.homeDir, this.shell, value, this.customProperties));
    }

    public final UnixAccountExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, this.homeDir, this.shell, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UnixAccountExtension && this.equalTo((UnixAccountExtension)another);
    }

    private boolean equalTo(UnixAccountExtension another) {
        return Objects.equals(this.gid, another.gid) && Objects.equals(this.homeDir, another.homeDir) && Objects.equals(this.shell, another.shell) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.gid);
        h += (h << 5) + Objects.hashCode(this.homeDir);
        h += (h << 5) + Objects.hashCode(this.shell);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UnixAccountExtension").omitNullValues().add("gid", (Object)this.gid).add("homeDir", (Object)this.homeDir).add("shell", (Object)this.shell).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static UnixAccountExtension validate(UnixAccountExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static UnixAccountExtension copyOf(UnixAccountExtensionExt instance) {
        if (instance instanceof UnixAccountExtension) {
            return (UnixAccountExtension)instance;
        }
        return UnixAccountExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return UnixAccountExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"gid", "groups", "home_dir", "shell"})
    @JsonTypeName(value="unix-account-ext")
    @Generated(from="UnixAccountExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long gid;
        @Nullable
        private String homeDir;
        @Nullable
        private String shell;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnixAccountExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof UnixAccountExtensionExt) {
                Optional<Long> gidOptional;
                Optional<String> homeDirOptional;
                instance = (UnixAccountExtensionExt)object;
                Optional<String> shellOptional = instance.getShell();
                if (shellOptional.isPresent()) {
                    this.shell(shellOptional);
                }
                if ((homeDirOptional = instance.getHomeDir()).isPresent()) {
                    this.homeDir(homeDirOptional);
                }
                if ((gidOptional = instance.getGid()).isPresent()) {
                    this.gid(gidOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder gid(long gid) {
            this.gid = gid;
            return this;
        }

        @JsonProperty(value="gid")
        @JsonPropertyDescription(value="Specifies the primary group ID of the account.")
        @CanIgnoreReturnValue
        public final Builder gid(Optional<Long> gid) {
            this.gid = gid.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder homeDir(String homeDir) {
            this.homeDir = Objects.requireNonNull(homeDir, "homeDir");
            return this;
        }

        @JsonProperty(value="home_dir")
        @JsonPropertyDescription(value="Specifies the home directory of the account.")
        @CanIgnoreReturnValue
        public final Builder homeDir(Optional<String> homeDir) {
            this.homeDir = homeDir.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder shell(String shell) {
            this.shell = Objects.requireNonNull(shell, "shell");
            return this;
        }

        @JsonProperty(value="shell")
        @JsonPropertyDescription(value="Specifies the account\u2019s command shell.")
        @CanIgnoreReturnValue
        public final Builder shell(Optional<String> shell) {
            this.shell = shell.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public UnixAccountExtension build() {
            return UnixAccountExtension.validate(new UnixAccountExtension(this.gid, this.homeDir, this.shell, this.type, this.customProperties.build()));
        }
    }
}

