/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.UnixAccountExtension;
import security.whisper.javastix.coo.objects.UserAccountCoo;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="unix-account-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=UnixAccountExtension.class)
@JsonDeserialize(builder=UnixAccountExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"gid", "groups", "home_dir", "shell"})
@JsonTypeName(value="unix-account-ext")
@AllowedParents(value={UserAccountCoo.class})
@BusinessRule(ifExp="true", thenExp="getGid().isPresent() == true || getGroups().isEmpty() == false || getHomeDir().isPresent() == true || getShell().isPresent() == true", errorMessage="At least one field must be provided for Unix Account Extension")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface UnixAccountExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="gid")
    @JsonPropertyDescription(value="Specifies the primary group ID of the account.")
    public Optional<Long> getGid();

    @JsonProperty(value="groups")
    @JsonPropertyDescription(value="Specifies a list of names of groups that the account is a member of.")
    default public Set<String> getGroups() {
        return null;
    }

    @JsonProperty(value="home_dir")
    @JsonPropertyDescription(value="Specifies the home directory of the account.")
    public Optional<String> getHomeDir();

    @JsonProperty(value="shell")
    @JsonPropertyDescription(value="Specifies the account\u2019s command shell.")
    public Optional<String> getShell();
}

