/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.WindowsPeBinaryFileExtensionExt;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.coo.types.WindowsPeOptionalHeaderObj;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="windows-pebinary-ext")
@AllowedParents(value={FileCoo.class})
@Generated(from="WindowsPeBinaryFileExtensionExt", generator="Immutables")
@Immutable
public final class WindowsPeBinaryFileExtension
implements WindowsPeBinaryFileExtensionExt,
Serializable {
    private final String peType;
    @Nullable
    private final String imphash;
    @Nullable
    private final String machineHex;
    @Nullable
    private final Long numberOfSections;
    @Nullable
    private final StixInstant timeDateStamp;
    @Nullable
    private final String pointerToSymbolTableHex;
    @Nullable
    private final Long numberOfSymbols;
    @Nullable
    private final Long sizeOfOptionalHeader;
    @Nullable
    private final String characteristicsHex;
    private final ImmutableMap<String, String> fileHeaderHashes;
    @Nullable
    private final WindowsPeOptionalHeaderObj optionalHeader;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsPeBinaryFileExtension(String peType, @Nullable String imphash, @Nullable String machineHex, @Nullable Long numberOfSections, @Nullable StixInstant timeDateStamp, @Nullable String pointerToSymbolTableHex, @Nullable Long numberOfSymbols, @Nullable Long sizeOfOptionalHeader, @Nullable String characteristicsHex, ImmutableMap<String, String> fileHeaderHashes, @Nullable WindowsPeOptionalHeaderObj optionalHeader, String type, ImmutableMap<String, Object> customProperties) {
        this.peType = peType;
        this.imphash = imphash;
        this.machineHex = machineHex;
        this.numberOfSections = numberOfSections;
        this.timeDateStamp = timeDateStamp;
        this.pointerToSymbolTableHex = pointerToSymbolTableHex;
        this.numberOfSymbols = numberOfSymbols;
        this.sizeOfOptionalHeader = sizeOfOptionalHeader;
        this.characteristicsHex = characteristicsHex;
        this.fileHeaderHashes = fileHeaderHashes;
        this.optionalHeader = optionalHeader;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="pe_type")
    @JsonPropertyDescription(value="Specifies the type of the PE binary. Open Vocabulary - windows-pebinary-type-ov")
    public String getPeType() {
        return this.peType;
    }

    @Override
    @JsonProperty(value="imphash")
    @JsonPropertyDescription(value="Specifies the special import hash, or 'imphash', calculated for the PE Binary based on its imported libraries and functions.")
    public Optional<String> getImphash() {
        return Optional.ofNullable(this.imphash);
    }

    @Override
    @JsonProperty(value="machine_hex")
    @JsonPropertyDescription(value="Specifies the type of target machine.")
    public Optional<String> getMachineHex() {
        return Optional.ofNullable(this.machineHex);
    }

    @Override
    @JsonProperty(value="number_of_sections")
    @JsonPropertyDescription(value="Specifies the number of sections in the PE binary, as a non-negative integer.")
    public Optional<Long> getNumberOfSections() {
        return Optional.ofNullable(this.numberOfSections);
    }

    @Override
    @JsonProperty(value="time_date_stamp")
    @JsonPropertyDescription(value="Specifies the time when the PE binary was created. The timestamp value MUST BE precise to the second.")
    public Optional<StixInstant> getTimeDateStamp() {
        return Optional.ofNullable(this.timeDateStamp);
    }

    @Override
    @JsonProperty(value="pointer_to_symbol_table_hex")
    @JsonPropertyDescription(value="Specifies the file offset of the COFF symbol table.")
    public Optional<String> getPointerToSymbolTableHex() {
        return Optional.ofNullable(this.pointerToSymbolTableHex);
    }

    @Override
    @JsonProperty(value="number_of_symbols")
    @JsonPropertyDescription(value="Specifies the number of entries in the symbol table of the PE binary, as a non-negative integer.")
    public Optional<Long> getNumberOfSymbols() {
        return Optional.ofNullable(this.numberOfSymbols);
    }

    @Override
    @JsonProperty(value="size_of_optional_header")
    @JsonPropertyDescription(value="Specifies the size of the optional header of the PE binary.")
    public Optional<Long> getSizeOfOptionalHeader() {
        return Optional.ofNullable(this.sizeOfOptionalHeader);
    }

    @Override
    @JsonProperty(value="characteristics_hex")
    @JsonPropertyDescription(value="Specifies the flags that indicate the file\u2019s characteristics.")
    public Optional<String> getCharacteristicsHex() {
        return Optional.ofNullable(this.characteristicsHex);
    }

    @JsonProperty(value="file_header_hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were computed for the file header.")
    public ImmutableMap<String, String> getFileHeaderHashes() {
        return this.fileHeaderHashes;
    }

    @Override
    @JsonProperty(value="optional_header")
    @JsonPropertyDescription(value="Specifies the PE optional header of the PE binary.")
    public Optional<WindowsPeOptionalHeaderObj> getOptionalHeader() {
        return Optional.ofNullable(this.optionalHeader);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsPeBinaryFileExtension withPeType(String value) {
        if (Objects.equals(this.peType, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(value, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withImphash(String value) {
        String newValue = Objects.requireNonNull(value, "imphash");
        if (Objects.equals(this.imphash, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, newValue, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withImphash(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.imphash, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, value, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withMachineHex(String value) {
        String newValue = Objects.requireNonNull(value, "machineHex");
        if (Objects.equals(this.machineHex, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, newValue, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withMachineHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.machineHex, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, value, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withNumberOfSections(long value) {
        Long newValue = value;
        if (Objects.equals(this.numberOfSections, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, newValue, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withNumberOfSections(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.numberOfSections, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, value, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withTimeDateStamp(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "timeDateStamp");
        if (this.timeDateStamp == newValue) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, newValue, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withTimeDateStamp(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.timeDateStamp == value) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, value, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withPointerToSymbolTableHex(String value) {
        String newValue = Objects.requireNonNull(value, "pointerToSymbolTableHex");
        if (Objects.equals(this.pointerToSymbolTableHex, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, newValue, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withPointerToSymbolTableHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pointerToSymbolTableHex, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, value, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withNumberOfSymbols(long value) {
        Long newValue = value;
        if (Objects.equals(this.numberOfSymbols, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, newValue, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withNumberOfSymbols(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.numberOfSymbols, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, value, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withSizeOfOptionalHeader(long value) {
        Long newValue = value;
        if (Objects.equals(this.sizeOfOptionalHeader, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, newValue, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withSizeOfOptionalHeader(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.sizeOfOptionalHeader, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, value, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withCharacteristicsHex(String value) {
        String newValue = Objects.requireNonNull(value, "characteristicsHex");
        if (Objects.equals(this.characteristicsHex, newValue)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, newValue, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withCharacteristicsHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.characteristicsHex, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, value, this.fileHeaderHashes, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withFileHeaderHashes(Map<String, ? extends String> entries) {
        if (this.fileHeaderHashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, (ImmutableMap<String, String>)newValue, this.optionalHeader, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withOptionalHeader(WindowsPeOptionalHeaderObj value) {
        WindowsPeOptionalHeaderObj newValue = Objects.requireNonNull(value, "optionalHeader");
        if (this.optionalHeader == newValue) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, newValue, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withOptionalHeader(Optional<? extends WindowsPeOptionalHeaderObj> optional) {
        WindowsPeOptionalHeaderObj value = optional.orElse(null);
        if (this.optionalHeader == value) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, value, this.type, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, value, this.customProperties));
    }

    public final WindowsPeBinaryFileExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes, this.optionalHeader, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsPeBinaryFileExtension && this.equalTo((WindowsPeBinaryFileExtension)another);
    }

    private boolean equalTo(WindowsPeBinaryFileExtension another) {
        return Objects.equals(this.peType, another.peType) && Objects.equals(this.imphash, another.imphash) && Objects.equals(this.machineHex, another.machineHex) && Objects.equals(this.numberOfSections, another.numberOfSections) && Objects.equals(this.timeDateStamp, another.timeDateStamp) && Objects.equals(this.pointerToSymbolTableHex, another.pointerToSymbolTableHex) && Objects.equals(this.numberOfSymbols, another.numberOfSymbols) && Objects.equals(this.sizeOfOptionalHeader, another.sizeOfOptionalHeader) && Objects.equals(this.characteristicsHex, another.characteristicsHex) && this.fileHeaderHashes.equals(another.fileHeaderHashes) && Objects.equals(this.optionalHeader, another.optionalHeader) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.peType);
        h += (h << 5) + Objects.hashCode(this.imphash);
        h += (h << 5) + Objects.hashCode(this.machineHex);
        h += (h << 5) + Objects.hashCode(this.numberOfSections);
        h += (h << 5) + Objects.hashCode(this.timeDateStamp);
        h += (h << 5) + Objects.hashCode(this.pointerToSymbolTableHex);
        h += (h << 5) + Objects.hashCode(this.numberOfSymbols);
        h += (h << 5) + Objects.hashCode(this.sizeOfOptionalHeader);
        h += (h << 5) + Objects.hashCode(this.characteristicsHex);
        h += (h << 5) + this.fileHeaderHashes.hashCode();
        h += (h << 5) + Objects.hashCode(this.optionalHeader);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsPeBinaryFileExtension").omitNullValues().add("peType", (Object)this.peType).add("imphash", (Object)this.imphash).add("machineHex", (Object)this.machineHex).add("numberOfSections", (Object)this.numberOfSections).add("timeDateStamp", (Object)this.timeDateStamp).add("pointerToSymbolTableHex", (Object)this.pointerToSymbolTableHex).add("numberOfSymbols", (Object)this.numberOfSymbols).add("sizeOfOptionalHeader", (Object)this.sizeOfOptionalHeader).add("characteristicsHex", (Object)this.characteristicsHex).add("fileHeaderHashes", this.fileHeaderHashes).add("optionalHeader", (Object)this.optionalHeader).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static WindowsPeBinaryFileExtension validate(WindowsPeBinaryFileExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsPeBinaryFileExtension copyOf(WindowsPeBinaryFileExtensionExt instance) {
        if (instance instanceof WindowsPeBinaryFileExtension) {
            return (WindowsPeBinaryFileExtension)instance;
        }
        return WindowsPeBinaryFileExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsPeBinaryFileExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"pe_type", "imphash", "machine_hex", "number_of_sections", "time_date_stamp", "pointer_to_symbol_table_hex", "number_of_symbols", "size_of_optional_header", "characteristics_hex", "file_header_hashes", "optional_header", "sections", "required"})
    @JsonTypeName(value="windows-pebinary-ext")
    @Generated(from="WindowsPeBinaryFileExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String peType;
        @Nullable
        private String imphash;
        @Nullable
        private String machineHex;
        @Nullable
        private Long numberOfSections;
        @Nullable
        private StixInstant timeDateStamp;
        @Nullable
        private String pointerToSymbolTableHex;
        @Nullable
        private Long numberOfSymbols;
        @Nullable
        private Long sizeOfOptionalHeader;
        @Nullable
        private String characteristicsHex;
        private ImmutableMap.Builder<String, String> fileHeaderHashes = ImmutableMap.builder();
        @Nullable
        private WindowsPeOptionalHeaderObj optionalHeader;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsPeBinaryFileExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
            if (object instanceof WindowsPeBinaryFileExtensionExt) {
                Optional<String> machineHexOptional;
                Optional<Long> numberOfSectionsOptional;
                Optional<WindowsPeOptionalHeaderObj> optionalHeaderOptional;
                Optional<Long> numberOfSymbolsOptional;
                String peTypeValue;
                Optional<String> characteristicsHexOptional;
                Optional<Long> sizeOfOptionalHeaderOptional;
                Optional<String> pointerToSymbolTableHexOptional;
                instance = (WindowsPeBinaryFileExtensionExt)object;
                Optional<StixInstant> timeDateStampOptional = instance.getTimeDateStamp();
                if (timeDateStampOptional.isPresent()) {
                    this.timeDateStamp(timeDateStampOptional);
                }
                this.putAllFileHeaderHashes(instance.getFileHeaderHashes());
                Optional<String> imphashOptional = instance.getImphash();
                if (imphashOptional.isPresent()) {
                    this.imphash(imphashOptional);
                }
                if ((pointerToSymbolTableHexOptional = instance.getPointerToSymbolTableHex()).isPresent()) {
                    this.pointerToSymbolTableHex(pointerToSymbolTableHexOptional);
                }
                if ((sizeOfOptionalHeaderOptional = instance.getSizeOfOptionalHeader()).isPresent()) {
                    this.sizeOfOptionalHeader(sizeOfOptionalHeaderOptional);
                }
                if ((characteristicsHexOptional = instance.getCharacteristicsHex()).isPresent()) {
                    this.characteristicsHex(characteristicsHexOptional);
                }
                if ((peTypeValue = instance.getPeType()) != null) {
                    this.peType(peTypeValue);
                }
                if ((numberOfSymbolsOptional = instance.getNumberOfSymbols()).isPresent()) {
                    this.numberOfSymbols(numberOfSymbolsOptional);
                }
                if ((optionalHeaderOptional = instance.getOptionalHeader()).isPresent()) {
                    this.optionalHeader(optionalHeaderOptional);
                }
                if ((numberOfSectionsOptional = instance.getNumberOfSections()).isPresent()) {
                    this.numberOfSections(numberOfSectionsOptional);
                }
                if ((machineHexOptional = instance.getMachineHex()).isPresent()) {
                    this.machineHex(machineHexOptional);
                }
            }
        }

        @JsonProperty(value="pe_type")
        @JsonPropertyDescription(value="Specifies the type of the PE binary. Open Vocabulary - windows-pebinary-type-ov")
        @CanIgnoreReturnValue
        public final Builder peType(String peType) {
            this.peType = peType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder imphash(String imphash) {
            this.imphash = Objects.requireNonNull(imphash, "imphash");
            return this;
        }

        @JsonProperty(value="imphash")
        @JsonPropertyDescription(value="Specifies the special import hash, or 'imphash', calculated for the PE Binary based on its imported libraries and functions.")
        @CanIgnoreReturnValue
        public final Builder imphash(Optional<String> imphash) {
            this.imphash = imphash.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder machineHex(String machineHex) {
            this.machineHex = Objects.requireNonNull(machineHex, "machineHex");
            return this;
        }

        @JsonProperty(value="machine_hex")
        @JsonPropertyDescription(value="Specifies the type of target machine.")
        @CanIgnoreReturnValue
        public final Builder machineHex(Optional<String> machineHex) {
            this.machineHex = machineHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numberOfSections(long numberOfSections) {
            this.numberOfSections = numberOfSections;
            return this;
        }

        @JsonProperty(value="number_of_sections")
        @JsonPropertyDescription(value="Specifies the number of sections in the PE binary, as a non-negative integer.")
        @CanIgnoreReturnValue
        public final Builder numberOfSections(Optional<Long> numberOfSections) {
            this.numberOfSections = numberOfSections.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeDateStamp(StixInstant timeDateStamp) {
            this.timeDateStamp = Objects.requireNonNull(timeDateStamp, "timeDateStamp");
            return this;
        }

        @JsonProperty(value="time_date_stamp")
        @JsonPropertyDescription(value="Specifies the time when the PE binary was created. The timestamp value MUST BE precise to the second.")
        @CanIgnoreReturnValue
        public final Builder timeDateStamp(Optional<? extends StixInstant> timeDateStamp) {
            this.timeDateStamp = timeDateStamp.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointerToSymbolTableHex(String pointerToSymbolTableHex) {
            this.pointerToSymbolTableHex = Objects.requireNonNull(pointerToSymbolTableHex, "pointerToSymbolTableHex");
            return this;
        }

        @JsonProperty(value="pointer_to_symbol_table_hex")
        @JsonPropertyDescription(value="Specifies the file offset of the COFF symbol table.")
        @CanIgnoreReturnValue
        public final Builder pointerToSymbolTableHex(Optional<String> pointerToSymbolTableHex) {
            this.pointerToSymbolTableHex = pointerToSymbolTableHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder numberOfSymbols(long numberOfSymbols) {
            this.numberOfSymbols = numberOfSymbols;
            return this;
        }

        @JsonProperty(value="number_of_symbols")
        @JsonPropertyDescription(value="Specifies the number of entries in the symbol table of the PE binary, as a non-negative integer.")
        @CanIgnoreReturnValue
        public final Builder numberOfSymbols(Optional<Long> numberOfSymbols) {
            this.numberOfSymbols = numberOfSymbols.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sizeOfOptionalHeader(long sizeOfOptionalHeader) {
            this.sizeOfOptionalHeader = sizeOfOptionalHeader;
            return this;
        }

        @JsonProperty(value="size_of_optional_header")
        @JsonPropertyDescription(value="Specifies the size of the optional header of the PE binary.")
        @CanIgnoreReturnValue
        public final Builder sizeOfOptionalHeader(Optional<Long> sizeOfOptionalHeader) {
            this.sizeOfOptionalHeader = sizeOfOptionalHeader.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder characteristicsHex(String characteristicsHex) {
            this.characteristicsHex = Objects.requireNonNull(characteristicsHex, "characteristicsHex");
            return this;
        }

        @JsonProperty(value="characteristics_hex")
        @JsonPropertyDescription(value="Specifies the flags that indicate the file\u2019s characteristics.")
        @CanIgnoreReturnValue
        public final Builder characteristicsHex(Optional<String> characteristicsHex) {
            this.characteristicsHex = characteristicsHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFileHeaderHash(String key, String value) {
            this.fileHeaderHashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFileHeaderHash(Map.Entry<String, ? extends String> entry) {
            this.fileHeaderHashes.put(entry);
            return this;
        }

        @JsonProperty(value="file_header_hashes")
        @JsonPropertyDescription(value="Specifies any hashes that were computed for the file header.")
        @CanIgnoreReturnValue
        public final Builder fileHeaderHashes(Map<String, ? extends String> entries) {
            this.fileHeaderHashes = ImmutableMap.builder();
            return this.putAllFileHeaderHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFileHeaderHashes(Map<String, ? extends String> entries) {
            this.fileHeaderHashes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optionalHeader(WindowsPeOptionalHeaderObj optionalHeader) {
            this.optionalHeader = Objects.requireNonNull(optionalHeader, "optionalHeader");
            return this;
        }

        @JsonProperty(value="optional_header")
        @JsonPropertyDescription(value="Specifies the PE optional header of the PE binary.")
        @CanIgnoreReturnValue
        public final Builder optionalHeader(Optional<? extends WindowsPeOptionalHeaderObj> optionalHeader) {
            this.optionalHeader = optionalHeader.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsPeBinaryFileExtension build() {
            return WindowsPeBinaryFileExtension.validate(new WindowsPeBinaryFileExtension(this.peType, this.imphash, this.machineHex, this.numberOfSections, this.timeDateStamp, this.pointerToSymbolTableHex, this.numberOfSymbols, this.sizeOfOptionalHeader, this.characteristicsHex, this.fileHeaderHashes.build(), this.optionalHeader, this.type, this.customProperties.build()));
        }
    }
}

