/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.PositiveOrZero;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.WindowsPeBinaryFileExtension;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.coo.types.WindowsPeOptionalHeaderObj;
import security.whisper.javastix.coo.types.WindowsPeSectionObj;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;
import security.whisper.javastix.vocabulary.vocabularies.WindowsPeBinaryTypes;

@DefaultTypeValue(value="windows-pebinary-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=WindowsPeBinaryFileExtension.class)
@JsonDeserialize(builder=WindowsPeBinaryFileExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"pe_type", "imphash", "machine_hex", "number_of_sections", "time_date_stamp", "pointer_to_symbol_table_hex", "number_of_symbols", "size_of_optional_header", "characteristics_hex", "file_header_hashes", "optional_header", "sections", "required"})
@JsonTypeName(value="windows-pebinary-ext")
@AllowedParents(value={FileCoo.class})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface WindowsPeBinaryFileExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="pe_type")
    @JsonPropertyDescription(value="Specifies the type of the PE binary. Open Vocabulary - windows-pebinary-type-ov")
    @NotNull
    @Vocab(value=WindowsPeBinaryTypes.class)
    public String getPeType();

    @JsonProperty(value="imphash")
    @JsonPropertyDescription(value="Specifies the special import hash, or 'imphash', calculated for the PE Binary based on its imported libraries and functions.")
    public Optional<String> getImphash();

    @JsonProperty(value="machine_hex")
    @JsonPropertyDescription(value="Specifies the type of target machine.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getMachineHex();

    @JsonProperty(value="number_of_sections")
    @JsonPropertyDescription(value="Specifies the number of sections in the PE binary, as a non-negative integer.")
    public Optional<Long> getNumberOfSections();

    @JsonProperty(value="time_date_stamp")
    @JsonPropertyDescription(value="Specifies the time when the PE binary was created. The timestamp value MUST BE precise to the second.")
    public Optional<StixInstant> getTimeDateStamp();

    @JsonProperty(value="pointer_to_symbol_table_hex")
    @JsonPropertyDescription(value="Specifies the file offset of the COFF symbol table.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getPointerToSymbolTableHex();

    @JsonProperty(value="number_of_symbols")
    @JsonPropertyDescription(value="Specifies the number of entries in the symbol table of the PE binary, as a non-negative integer.")
    public Optional<Long> getNumberOfSymbols();

    @JsonProperty(value="size_of_optional_header")
    @JsonPropertyDescription(value="Specifies the size of the optional header of the PE binary.")
    public Optional<@PositiveOrZero Long> getSizeOfOptionalHeader();

    @JsonProperty(value="characteristics_hex")
    @JsonPropertyDescription(value="Specifies the flags that indicate the file\u2019s characteristics.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getCharacteristicsHex();

    @JsonProperty(value="file_header_hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were computed for the file header.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getFileHeaderHashes();

    @JsonProperty(value="optional_header")
    @JsonPropertyDescription(value="Specifies the PE optional header of the PE binary.")
    public Optional<WindowsPeOptionalHeaderObj> getOptionalHeader();

    @JsonProperty(value="sections")
    @JsonPropertyDescription(value="Specifies metadata about the sections in the PE file.")
    default public Set<WindowsPeSectionObj> getSections() {
        return null;
    }
}

