/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.WindowsProcessExtensionExt;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="windows-process-ext")
@AllowedParents(value={ProcessCoo.class})
@Generated(from="WindowsProcessExtensionExt", generator="Immutables")
@Immutable
public final class WindowsProcessExtension
implements WindowsProcessExtensionExt,
Serializable {
    @Nullable
    private final Boolean isAslrEnabled;
    @Nullable
    private final Boolean isDepEnabled;
    @Nullable
    private final String priority;
    @Nullable
    private final String ownerSid;
    @Nullable
    private final String windowTitle;
    private final ImmutableMap<String, String> startupInfo;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsProcessExtension(@Nullable Boolean isAslrEnabled, @Nullable Boolean isDepEnabled, @Nullable String priority, @Nullable String ownerSid, @Nullable String windowTitle, ImmutableMap<String, String> startupInfo, String type, ImmutableMap<String, Object> customProperties) {
        this.isAslrEnabled = isAslrEnabled;
        this.isDepEnabled = isDepEnabled;
        this.priority = priority;
        this.ownerSid = ownerSid;
        this.windowTitle = windowTitle;
        this.startupInfo = startupInfo;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="aslr_enabled")
    @JsonPropertyDescription(value="Specifies whether Address Space Layout Randomization (ASLR) is enabled for the process.")
    public Optional<Boolean> isAslrEnabled() {
        return Optional.ofNullable(this.isAslrEnabled);
    }

    @Override
    @JsonProperty(value="dep_enabled")
    @JsonPropertyDescription(value="Specifies whether Data Execution Prevention (DEP) is enabled for the process.")
    public Optional<Boolean> isDepEnabled() {
        return Optional.ofNullable(this.isDepEnabled);
    }

    @Override
    @JsonProperty(value="priority")
    @JsonPropertyDescription(value="Specifies the current priority class of the process in Windows.")
    public Optional<String> getPriority() {
        return Optional.ofNullable(this.priority);
    }

    @Override
    @JsonProperty(value="owner_sid")
    @JsonPropertyDescription(value="Specifies the Security ID (SID) value of the owner of the process.")
    public Optional<String> getOwnerSid() {
        return Optional.ofNullable(this.ownerSid);
    }

    @Override
    @JsonProperty(value="window_title")
    @JsonPropertyDescription(value="Specifies the title of the main window of the process.")
    public Optional<String> getWindowTitle() {
        return Optional.ofNullable(this.windowTitle);
    }

    @JsonProperty(value="startup_info")
    @JsonPropertyDescription(value="Specifies the STARTUP_INFO struct used by the process, as a dictionary.")
    public ImmutableMap<String, String> getStartupInfo() {
        return this.startupInfo;
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsProcessExtension withIsAslrEnabled(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isAslrEnabled, newValue)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(newValue, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withIsAslrEnabled(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isAslrEnabled, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(value, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withIsDepEnabled(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isDepEnabled, newValue)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, newValue, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withIsDepEnabled(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isDepEnabled, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, value, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withPriority(String value) {
        String newValue = Objects.requireNonNull(value, "priority");
        if (Objects.equals(this.priority, newValue)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, newValue, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withPriority(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.priority, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, value, this.ownerSid, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withOwnerSid(String value) {
        String newValue = Objects.requireNonNull(value, "ownerSid");
        if (Objects.equals(this.ownerSid, newValue)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, newValue, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withOwnerSid(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ownerSid, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, value, this.windowTitle, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withWindowTitle(String value) {
        String newValue = Objects.requireNonNull(value, "windowTitle");
        if (Objects.equals(this.windowTitle, newValue)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, newValue, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withWindowTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.windowTitle, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, value, this.startupInfo, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withStartupInfo(Map<String, ? extends String> entries) {
        if (this.startupInfo == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, (ImmutableMap<String, String>)newValue, this.type, this.customProperties));
    }

    public final WindowsProcessExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, value, this.customProperties));
    }

    public final WindowsProcessExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, this.startupInfo, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsProcessExtension && this.equalTo((WindowsProcessExtension)another);
    }

    private boolean equalTo(WindowsProcessExtension another) {
        return Objects.equals(this.isAslrEnabled, another.isAslrEnabled) && Objects.equals(this.isDepEnabled, another.isDepEnabled) && Objects.equals(this.priority, another.priority) && Objects.equals(this.ownerSid, another.ownerSid) && Objects.equals(this.windowTitle, another.windowTitle) && this.startupInfo.equals(another.startupInfo) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.isAslrEnabled);
        h += (h << 5) + Objects.hashCode(this.isDepEnabled);
        h += (h << 5) + Objects.hashCode(this.priority);
        h += (h << 5) + Objects.hashCode(this.ownerSid);
        h += (h << 5) + Objects.hashCode(this.windowTitle);
        h += (h << 5) + this.startupInfo.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsProcessExtension").omitNullValues().add("isAslrEnabled", (Object)this.isAslrEnabled).add("isDepEnabled", (Object)this.isDepEnabled).add("priority", (Object)this.priority).add("ownerSid", (Object)this.ownerSid).add("windowTitle", (Object)this.windowTitle).add("startupInfo", this.startupInfo).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static WindowsProcessExtension validate(WindowsProcessExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsProcessExtension copyOf(WindowsProcessExtensionExt instance) {
        if (instance instanceof WindowsProcessExtension) {
            return (WindowsProcessExtension)instance;
        }
        return WindowsProcessExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsProcessExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"aslr_enabled", "dep_enabled", "priority", "owner_sid", "window_title", "startup_info"})
    @JsonTypeName(value="windows-process-ext")
    @Generated(from="WindowsProcessExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean isAslrEnabled;
        @Nullable
        private Boolean isDepEnabled;
        @Nullable
        private String priority;
        @Nullable
        private String ownerSid;
        @Nullable
        private String windowTitle;
        private ImmutableMap.Builder<String, String> startupInfo = ImmutableMap.builder();
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsProcessExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof WindowsProcessExtensionExt) {
                Optional<String> priorityOptional;
                Optional<String> ownerSidOptional;
                Optional<Boolean> isDepEnabledOptional;
                Optional<String> windowTitleOptional;
                instance = (WindowsProcessExtensionExt)object;
                Optional<Boolean> isAslrEnabledOptional = instance.isAslrEnabled();
                if (isAslrEnabledOptional.isPresent()) {
                    this.isAslrEnabled(isAslrEnabledOptional);
                }
                if ((windowTitleOptional = instance.getWindowTitle()).isPresent()) {
                    this.windowTitle(windowTitleOptional);
                }
                if ((isDepEnabledOptional = instance.isDepEnabled()).isPresent()) {
                    this.isDepEnabled(isDepEnabledOptional);
                }
                if ((ownerSidOptional = instance.getOwnerSid()).isPresent()) {
                    this.ownerSid(ownerSidOptional);
                }
                if ((priorityOptional = instance.getPriority()).isPresent()) {
                    this.priority(priorityOptional);
                }
                this.putAllStartupInfo(instance.getStartupInfo());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @CanIgnoreReturnValue
        public final Builder isAslrEnabled(boolean isAslrEnabled) {
            this.isAslrEnabled = isAslrEnabled;
            return this;
        }

        @JsonProperty(value="aslr_enabled")
        @JsonPropertyDescription(value="Specifies whether Address Space Layout Randomization (ASLR) is enabled for the process.")
        @CanIgnoreReturnValue
        public final Builder isAslrEnabled(Optional<Boolean> isAslrEnabled) {
            this.isAslrEnabled = isAslrEnabled.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDepEnabled(boolean isDepEnabled) {
            this.isDepEnabled = isDepEnabled;
            return this;
        }

        @JsonProperty(value="dep_enabled")
        @JsonPropertyDescription(value="Specifies whether Data Execution Prevention (DEP) is enabled for the process.")
        @CanIgnoreReturnValue
        public final Builder isDepEnabled(Optional<Boolean> isDepEnabled) {
            this.isDepEnabled = isDepEnabled.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder priority(String priority) {
            this.priority = Objects.requireNonNull(priority, "priority");
            return this;
        }

        @JsonProperty(value="priority")
        @JsonPropertyDescription(value="Specifies the current priority class of the process in Windows.")
        @CanIgnoreReturnValue
        public final Builder priority(Optional<String> priority) {
            this.priority = priority.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ownerSid(String ownerSid) {
            this.ownerSid = Objects.requireNonNull(ownerSid, "ownerSid");
            return this;
        }

        @JsonProperty(value="owner_sid")
        @JsonPropertyDescription(value="Specifies the Security ID (SID) value of the owner of the process.")
        @CanIgnoreReturnValue
        public final Builder ownerSid(Optional<String> ownerSid) {
            this.ownerSid = ownerSid.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder windowTitle(String windowTitle) {
            this.windowTitle = Objects.requireNonNull(windowTitle, "windowTitle");
            return this;
        }

        @JsonProperty(value="window_title")
        @JsonPropertyDescription(value="Specifies the title of the main window of the process.")
        @CanIgnoreReturnValue
        public final Builder windowTitle(Optional<String> windowTitle) {
            this.windowTitle = windowTitle.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStartupInfo(String key, String value) {
            this.startupInfo.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putStartupInfo(Map.Entry<String, ? extends String> entry) {
            this.startupInfo.put(entry);
            return this;
        }

        @JsonProperty(value="startup_info")
        @JsonPropertyDescription(value="Specifies the STARTUP_INFO struct used by the process, as a dictionary.")
        @CanIgnoreReturnValue
        public final Builder startupInfo(Map<String, ? extends String> entries) {
            this.startupInfo = ImmutableMap.builder();
            return this.putAllStartupInfo(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllStartupInfo(Map<String, ? extends String> entries) {
            this.startupInfo.putAll(entries);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsProcessExtension build() {
            return WindowsProcessExtension.validate(new WindowsProcessExtension(this.isAslrEnabled, this.isDepEnabled, this.priority, this.ownerSid, this.windowTitle, this.startupInfo.build(), this.type, this.customProperties.build()));
        }
    }
}

