/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.WindowsProcessExtension;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="windows-process-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=WindowsProcessExtension.class)
@JsonDeserialize(builder=WindowsProcessExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"aslr_enabled", "dep_enabled", "priority", "owner_sid", "window_title", "startup_info"})
@JsonTypeName(value="windows-process-ext")
@AllowedParents(value={ProcessCoo.class})
@BusinessRule(ifExp="isAslrEnabled().orElse(false) == true || isDepEnabled().orElse(false) == true", thenExp="isDepEnabled().orElse(false) == false || isAslrEnabled().orElse(false) == false", errorMessage="Dep and ASLR cannot both be enabled")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface WindowsProcessExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="aslr_enabled")
    @JsonPropertyDescription(value="Specifies whether Address Space Layout Randomization (ASLR) is enabled for the process.")
    @NotNull
    public Optional<Boolean> isAslrEnabled();

    @JsonProperty(value="dep_enabled")
    @JsonPropertyDescription(value="Specifies whether Data Execution Prevention (DEP) is enabled for the process.")
    @NotNull
    public Optional<Boolean> isDepEnabled();

    @JsonProperty(value="priority")
    @JsonPropertyDescription(value="Specifies the current priority class of the process in Windows.")
    public Optional<String> getPriority();

    @JsonProperty(value="owner_sid")
    @JsonPropertyDescription(value="Specifies the Security ID (SID) value of the owner of the process.")
    public Optional<String> getOwnerSid();

    @JsonProperty(value="window_title")
    @JsonPropertyDescription(value="Specifies the title of the main window of the process.")
    public Optional<String> getWindowTitle();

    @JsonProperty(value="startup_info")
    @JsonPropertyDescription(value="Specifies the STARTUP_INFO struct used by the process, as a dictionary.")
    public Map<String, String> getStartupInfo();
}

