/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtensionCommonProperties;
import security.whisper.javastix.coo.extension.types.WindowsServiceExtensionExt;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="windows-service-ext")
@AllowedParents(value={ProcessCoo.class})
@Generated(from="WindowsServiceExtensionExt", generator="Immutables")
@Immutable
public final class WindowsServiceExtension
implements WindowsServiceExtensionExt,
Serializable {
    private final String serviceName;
    @Nullable
    private final String displayName;
    @Nullable
    private final String groupName;
    @Nullable
    private final String serviceStartType;
    @Nullable
    private final String serviceType;
    @Nullable
    private final String serviceStatus;
    private final String type;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private WindowsServiceExtension(String serviceName, @Nullable String displayName, @Nullable String groupName, @Nullable String serviceStartType, @Nullable String serviceType, @Nullable String serviceStatus, String type, ImmutableMap<String, Object> customProperties) {
        this.serviceName = serviceName;
        this.displayName = displayName;
        this.groupName = groupName;
        this.serviceStartType = serviceStartType;
        this.serviceType = serviceType;
        this.serviceStatus = serviceStatus;
        this.type = type;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="service_name")
    @JsonPropertyDescription(value="Specifies the name of the service.")
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @JsonProperty(value="display_name")
    @JsonPropertyDescription(value="Specifies the displayed name of the service in Windows GUI controls.")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    @JsonProperty(value="group_name")
    @JsonPropertyDescription(value="Specifies the name of the load ordering group of which the service is a member.")
    public Optional<String> getGroupName() {
        return Optional.ofNullable(this.groupName);
    }

    @Override
    @JsonProperty(value="start_type")
    @JsonPropertyDescription(value="Specifies the start options defined for the service. windows-service-start-enum")
    public Optional<String> getServiceStartType() {
        return Optional.ofNullable(this.serviceStartType);
    }

    @Override
    @JsonProperty(value="service_type")
    @JsonPropertyDescription(value="Specifies the type of the service. windows-service-enum")
    public Optional<String> getServiceType() {
        return Optional.ofNullable(this.serviceType);
    }

    @Override
    @JsonProperty(value="service_status")
    @JsonPropertyDescription(value="Specifies the current status of the service. windows-service-status-enum")
    public Optional<String> getServiceStatus() {
        return Optional.ofNullable(this.serviceStatus);
    }

    @Override
    @JsonIgnore
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final WindowsServiceExtension withServiceName(String value) {
        if (Objects.equals(this.serviceName, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(value, this.displayName, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (Objects.equals(this.displayName, newValue)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, newValue, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withDisplayName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, value, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withGroupName(String value) {
        String newValue = Objects.requireNonNull(value, "groupName");
        if (Objects.equals(this.groupName, newValue)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, newValue, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withGroupName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.groupName, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, value, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceStartType(String value) {
        String newValue = Objects.requireNonNull(value, "serviceStartType");
        if (Objects.equals(this.serviceStartType, newValue)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, newValue, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceStartType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceStartType, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, value, this.serviceType, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceType(String value) {
        String newValue = Objects.requireNonNull(value, "serviceType");
        if (Objects.equals(this.serviceType, newValue)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, newValue, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceType, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, value, this.serviceStatus, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceStatus(String value) {
        String newValue = Objects.requireNonNull(value, "serviceStatus");
        if (Objects.equals(this.serviceStatus, newValue)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, this.serviceType, newValue, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withServiceStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceStatus, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, this.serviceType, value, this.type, this.customProperties));
    }

    public final WindowsServiceExtension withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, value, this.customProperties));
    }

    public final WindowsServiceExtension withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WindowsServiceExtension && this.equalTo((WindowsServiceExtension)another);
    }

    private boolean equalTo(WindowsServiceExtension another) {
        return Objects.equals(this.serviceName, another.serviceName) && Objects.equals(this.displayName, another.displayName) && Objects.equals(this.groupName, another.groupName) && Objects.equals(this.serviceStartType, another.serviceStartType) && Objects.equals(this.serviceType, another.serviceType) && Objects.equals(this.serviceStatus, another.serviceStatus) && Objects.equals(this.type, another.type) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.serviceName);
        h += (h << 5) + Objects.hashCode(this.displayName);
        h += (h << 5) + Objects.hashCode(this.groupName);
        h += (h << 5) + Objects.hashCode(this.serviceStartType);
        h += (h << 5) + Objects.hashCode(this.serviceType);
        h += (h << 5) + Objects.hashCode(this.serviceStatus);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WindowsServiceExtension").omitNullValues().add("serviceName", (Object)this.serviceName).add("displayName", (Object)this.displayName).add("groupName", (Object)this.groupName).add("serviceStartType", (Object)this.serviceStartType).add("serviceType", (Object)this.serviceType).add("serviceStatus", (Object)this.serviceStatus).add("type", (Object)this.type).add("customProperties", this.customProperties).toString();
    }

    private static WindowsServiceExtension validate(WindowsServiceExtension instance) {
        instance.validateEntity();
        return instance;
    }

    public static WindowsServiceExtension copyOf(WindowsServiceExtensionExt instance) {
        if (instance instanceof WindowsServiceExtension) {
            return (WindowsServiceExtension)instance;
        }
        return WindowsServiceExtension.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return WindowsServiceExtension.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"service_name", "descriptions", "display_name", "group_name", "start_type", "service_dll_refs", "service_type", "service_status"})
    @JsonTypeName(value="windows-service-ext")
    @Generated(from="WindowsServiceExtensionExt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String serviceName;
        @Nullable
        private String displayName;
        @Nullable
        private String groupName;
        @Nullable
        private String serviceStartType;
        @Nullable
        private String serviceType;
        @Nullable
        private String serviceStatus;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WindowsServiceExtensionExt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableExtensionCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            if (object instanceof WindowsServiceExtensionExt) {
                Optional<String> serviceStatusOptional;
                Optional<String> displayNameOptional;
                String serviceNameValue;
                Optional<String> groupNameOptional;
                Optional<String> serviceStartTypeOptional;
                instance = (WindowsServiceExtensionExt)object;
                Optional<String> serviceTypeOptional = instance.getServiceType();
                if (serviceTypeOptional.isPresent()) {
                    this.serviceType(serviceTypeOptional);
                }
                if ((serviceStartTypeOptional = instance.getServiceStartType()).isPresent()) {
                    this.serviceStartType(serviceStartTypeOptional);
                }
                if ((groupNameOptional = instance.getGroupName()).isPresent()) {
                    this.groupName(groupNameOptional);
                }
                if ((serviceNameValue = instance.getServiceName()) != null) {
                    this.serviceName(serviceNameValue);
                }
                if ((displayNameOptional = instance.getDisplayName()).isPresent()) {
                    this.displayName(displayNameOptional);
                }
                if ((serviceStatusOptional = instance.getServiceStatus()).isPresent()) {
                    this.serviceStatus(serviceStatusOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableExtensionCommonProperties && (typeValue = (instance = (CyberObservableExtensionCommonProperties)object).getType()) != null) {
                this.type(typeValue);
            }
        }

        @JsonProperty(value="service_name")
        @JsonPropertyDescription(value="Specifies the name of the service.")
        @CanIgnoreReturnValue
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            return this;
        }

        @JsonProperty(value="display_name")
        @JsonPropertyDescription(value="Specifies the displayed name of the service in Windows GUI controls.")
        @CanIgnoreReturnValue
        public final Builder displayName(Optional<String> displayName) {
            this.displayName = displayName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder groupName(String groupName) {
            this.groupName = Objects.requireNonNull(groupName, "groupName");
            return this;
        }

        @JsonProperty(value="group_name")
        @JsonPropertyDescription(value="Specifies the name of the load ordering group of which the service is a member.")
        @CanIgnoreReturnValue
        public final Builder groupName(Optional<String> groupName) {
            this.groupName = groupName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceStartType(String serviceStartType) {
            this.serviceStartType = Objects.requireNonNull(serviceStartType, "serviceStartType");
            return this;
        }

        @JsonProperty(value="start_type")
        @JsonPropertyDescription(value="Specifies the start options defined for the service. windows-service-start-enum")
        @CanIgnoreReturnValue
        public final Builder serviceStartType(Optional<String> serviceStartType) {
            this.serviceStartType = serviceStartType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceType(String serviceType) {
            this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
            return this;
        }

        @JsonProperty(value="service_type")
        @JsonPropertyDescription(value="Specifies the type of the service. windows-service-enum")
        @CanIgnoreReturnValue
        public final Builder serviceType(Optional<String> serviceType) {
            this.serviceType = serviceType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceStatus(String serviceStatus) {
            this.serviceStatus = Objects.requireNonNull(serviceStatus, "serviceStatus");
            return this;
        }

        @JsonProperty(value="service_status")
        @JsonPropertyDescription(value="Specifies the current status of the service. windows-service-status-enum")
        @CanIgnoreReturnValue
        public final Builder serviceStatus(Optional<String> serviceStatus) {
            this.serviceStatus = serviceStatus.orElse(null);
            return this;
        }

        @JsonIgnore
        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public WindowsServiceExtension build() {
            return WindowsServiceExtension.validate(new WindowsServiceExtension(this.serviceName, this.displayName, this.groupName, this.serviceStartType, this.serviceType, this.serviceStatus, this.type, this.customProperties.build()));
        }
    }
}

