/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.extension.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.extension.types.WindowsServiceExtension;
import security.whisper.javastix.coo.objects.ProcessCoo;
import security.whisper.javastix.validation.constraints.coo.allowedparents.AllowedParents;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.WindowsServiceStartTypes;
import security.whisper.javastix.vocabulary.vocabularies.WindowsServiceStatuses;
import security.whisper.javastix.vocabulary.vocabularies.WindowsServiceTypes;

@DefaultTypeValue(value="windows-service-ext", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=WindowsServiceExtension.class)
@JsonDeserialize(builder=WindowsServiceExtension.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"service_name", "descriptions", "display_name", "group_name", "start_type", "service_dll_refs", "service_type", "service_status"})
@JsonTypeName(value="windows-service-ext")
@AllowedParents(value={ProcessCoo.class})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Ext"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, passAnnotations={AllowedParents.class}, depluralize=true)
public interface WindowsServiceExtensionExt
extends CyberObservableExtension {
    @JsonProperty(value="service_name")
    @JsonPropertyDescription(value="Specifies the name of the service.")
    @NotBlank
    public String getServiceName();

    @JsonProperty(value="descriptions")
    @JsonPropertyDescription(value="Specifies the descriptions defined for the service.")
    default public Set<String> getDescriptions() {
        return null;
    }

    @JsonProperty(value="display_name")
    @JsonPropertyDescription(value="Specifies the displayed name of the service in Windows GUI controls.")
    public Optional<String> getDisplayName();

    @JsonProperty(value="group_name")
    @JsonPropertyDescription(value="Specifies the name of the load ordering group of which the service is a member.")
    public Optional<String> getGroupName();

    @JsonProperty(value="start_type")
    @JsonPropertyDescription(value="Specifies the start options defined for the service. windows-service-start-enum")
    public Optional<@Vocab(value=WindowsServiceStartTypes.class) String> getServiceStartType();

    @JsonProperty(value="service_dll_refs")
    @JsonPropertyDescription(value="Specifies the DLLs loaded by the service, as a reference to one or more File Objects.")
    default public Set<String> getServiceDllRefs() {
        return null;
    }

    @JsonProperty(value="service_type")
    @JsonPropertyDescription(value="Specifies the type of the service. windows-service-enum")
    public Optional<@Vocab(value=WindowsServiceTypes.class) String> getServiceType();

    @JsonProperty(value="service_status")
    @JsonPropertyDescription(value="Specifies the current status of the service. windows-service-status-enum")
    public Optional<@Vocab(value=WindowsServiceStatuses.class) String> getServiceStatus();
}

