/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Artifact;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@DefaultTypeValue(value="artifact", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="artifact")
@JsonSerialize(as=Artifact.class)
@JsonDeserialize(builder=Artifact.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "mime_type", "payload_bin", "url", "hashes"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@BusinessRule.List(value={@BusinessRule(ifExp="getUrl().isPresent() == true", thenExp="getHashes().isEmpty() == false && getPayloadBin().isPresent() == false", errorMessage="When Url is used, Hashes have at least 1 value, and payload_bin cannot be used."), @BusinessRule(ifExp="getPayloadBin().isPresent() == true", thenExp="getUrl().isPresent() == false && getHashes().isEmpty() == true", errorMessage="When payload_bin is used, Url and hashes cannot be used.")})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface ArtifactCoo
extends CyberObservableObject {
    @JsonProperty(value="mime_type")
    @JsonPropertyDescription(value="The value of this property MUST be a valid MIME type as specified in the IANA Media Types registry.")
    public Optional<@Pattern(regexp="^(application|audio|font|image|message|model|multipart|text|video)/[a-zA-Z0-9.+_-]+") String> getMimeType();

    @JsonProperty(value="payload_bin")
    @JsonPropertyDescription(value="Specifies the binary data contained in the artifact as a base64-encoded string.")
    public Optional<String> getPayloadBin();

    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The value of this property MUST be a valid URL that resolves to the unencoded content.")
    public Optional<@Pattern(regexp="^(?:(?:https?|ftp)://)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)(?:\\.(?:[a-z\u00a1-\uffff0-9]-*)*[a-z\u00a1-\uffff0-9]+)*(?:\\.(?:[a-z\u00a1-\uffff]{2,}))\\.?)(?::\\d{2,5})?(?:[/?#]\\S*)?$") String> getUrl();

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the contents of the url or the payload_bin.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getPayloadBin().isPresent()) {
            identifier.append(this.getPayloadBin().get());
        } else if (this.getUrl().isPresent()) {
            identifier.append(this.getUrl().get());
        } else if (this.getHashes() != null && !this.getHashes().isEmpty()) {
            identifier.append(this.getHashes().entrySet().stream().sorted(Map.Entry.comparingByKey()).findFirst().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).orElse(""));
        }
        if (identifier.length() == 0) {
            identifier.append("artifact:unknown");
        }
        return "artifact--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

