/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.AutonomousSystem;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="autonomous-system", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="autonomous-system")
@JsonSerialize(as=AutonomousSystem.class)
@JsonDeserialize(builder=AutonomousSystem.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "number", "name", "rir"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface AutonomousSystemCoo
extends CyberObservableObject {
    @JsonProperty(value="number")
    @JsonPropertyDescription(value="Specifies the number assigned to the AS. Such assignments are typically performed by a Regional Internet Registries (RIR)")
    public Long getNumber();

    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the AS.")
    public Optional<String> getName();

    @JsonProperty(value="rir")
    @JsonPropertyDescription(value="Specifies the name of the Regional Internet Registry (RIR) that assigned the number to the AS.")
    public Optional<String> getRir();

    @Override
    @Value.Derived
    default public String getId() {
        return "autonomous-system--" + UUID.nameUUIDFromBytes(String.valueOf(this.getNumber()).getBytes(StandardCharsets.UTF_8));
    }
}

