/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Directory;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="directory", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="directory")
@JsonSerialize(as=Directory.class)
@JsonDeserialize(builder=Directory.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "path", "path_enc", "created", "modified", "accessed", "contains_refs"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface DirectoryCoo
extends CyberObservableObject {
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="Specifies the path, as originally observed, to the directory on the file system.")
    public String getPath();

    @JsonProperty(value="path_enc")
    @JsonPropertyDescription(value="Specifies the observed encoding for the path.")
    public Optional<@Pattern(regexp="^[a-zA-Z0-9/\\.+_:-]{2,250}$") String> getPathEnc();

    @JsonProperty(value="created")
    @JsonPropertyDescription(value="Specifies the date/time the directory was created.")
    public Optional<StixInstant> getCreated();

    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="Specifies the date/time the directory was last written to/modified.")
    public Optional<StixInstant> getModified();

    @JsonProperty(value="accessed")
    @JsonPropertyDescription(value="Specifies the date/time the directory was last accessed.")
    public Optional<StixInstant> getAccessed();

    @JsonProperty(value="contains_refs")
    @JsonPropertyDescription(value="Specifies a list of references to other File and/or Directory Objects contained within the directory.")
    default public Set<String> getContainsRefs() {
        return null;
    }

    @Override
    @Value.Derived
    default public String getId() {
        return "directory--" + UUID.nameUUIDFromBytes(this.getPath().getBytes(StandardCharsets.UTF_8));
    }
}

