/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.DomainName;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="domain-name", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="domain-name")
@JsonSerialize(as=DomainName.class)
@JsonDeserialize(builder=DomainName.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "value", "resolves_to_refs"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface DomainNameCoo
extends CyberObservableObject {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Specifies the value of the domain name.")
    @NotNull
    public String getValue();

    @JsonProperty(value="resolves_to_refs")
    @JsonPropertyDescription(value="Specifies a list of references to one or more IP addresses or domain names that the domain name resolves to.")
    @Value.Default
    default public Set<String> getResolvesToRefs() {
        return Collections.emptySet();
    }

    @Override
    @Value.Derived
    default public String getId() {
        return "domain-name--" + UUID.nameUUIDFromBytes(this.getValue().getBytes(StandardCharsets.UTF_8));
    }
}

