/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.EmailAddress;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="email-addr", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="email-addr")
@JsonSerialize(as=EmailAddress.class)
@JsonDeserialize(builder=EmailAddress.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "value", "display_name", "belongs_to_ref"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface EmailAddressCoo
extends CyberObservableObject {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Specifies a single email address. This MUST not include the display name.")
    @Pattern(regexp="(^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$)")
    @NotNull
    public @Pattern(regexp="(^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\\.[a-zA-Z0-9-.]+$)") @NotNull String getValue();

    @JsonProperty(value="display_name")
    @JsonPropertyDescription(value="Specifies a single email display name, i.e., the name that is displayed to the human user of a mail application.")
    public Optional<String> getDisplayName();

    @JsonProperty(value="belongs_to_ref")
    @JsonPropertyDescription(value="Specifies the user account that the email address belongs to, as a reference to a User Account Object.")
    public Optional<String> getBelongsToRef();

    @Override
    @Value.Derived
    default public String getId() {
        return "email-addr--" + UUID.nameUUIDFromBytes(this.getValue().getBytes(StandardCharsets.UTF_8));
    }
}

