/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.objects.EmailMessageCoo;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="email-message")
@Generated(from="EmailMessageCoo", generator="Immutables")
@Immutable
public final class EmailMessage
implements EmailMessageCoo {
    private final Boolean isMultipart;
    @Nullable
    private final StixInstant date;
    @Nullable
    private final String contentType;
    @Nullable
    private final String fromRef;
    @Nullable
    private final String senderRef;
    private final String id;
    private final String type;
    private final ImmutableSet<CyberObservableExtension> extensions;
    private final String observableObjectKey;
    @Nullable
    private final Boolean defanged;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final boolean hydrated;
    private final String toJsonString;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 1L;

    private EmailMessage(Builder builder) {
        this.isMultipart = builder.isMultipart;
        this.date = builder.date;
        this.contentType = builder.contentType;
        this.fromRef = builder.fromRef;
        this.senderRef = builder.senderRef;
        this.type = builder.type;
        this.defanged = builder.defanged;
        this.customProperties = builder.customProperties.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        if (builder.extensionsIsSet()) {
            this.initShim.extensions((ImmutableSet<CyberObservableExtension>)builder.extensions.build());
        }
        if (builder.observableObjectKey != null) {
            this.initShim.observableObjectKey(builder.observableObjectKey);
        }
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private EmailMessage(Boolean isMultipart, @Nullable StixInstant date, @Nullable String contentType, @Nullable String fromRef, @Nullable String senderRef, String type, ImmutableSet<CyberObservableExtension> extensions, String observableObjectKey, @Nullable Boolean defanged, ImmutableMap<String, Object> customProperties, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, boolean hydrated, String toJsonString) {
        this.isMultipart = isMultipart;
        this.date = date;
        this.contentType = contentType;
        this.fromRef = fromRef;
        this.senderRef = senderRef;
        this.type = type;
        this.initShim.extensions(extensions);
        this.initShim.observableObjectKey(observableObjectKey);
        this.defanged = defanged;
        this.customProperties = customProperties;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private String getIdInitialize() {
        return EmailMessageCoo.super.getId();
    }

    private Set<CyberObservableExtension> getExtensionsInitialize() {
        return EmailMessageCoo.super.getExtensions();
    }

    private String getObservableObjectKeyInitialize() {
        return EmailMessageCoo.super.getObservableObjectKey();
    }

    @Override
    @JsonProperty(value="is_multipart")
    @JsonPropertyDescription(value="Indicates whether the email body contains multiple MIME parts.")
    public Boolean isMultipart() {
        return this.isMultipart;
    }

    @Override
    @JsonProperty(value="date")
    @JsonPropertyDescription(value="Specifies the date/time that the email message was sent.")
    public Optional<StixInstant> getDate() {
        return Optional.ofNullable(this.date);
    }

    @Override
    @JsonProperty(value="content_type")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header of the email message.")
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @Override
    @JsonProperty(value="from_ref")
    @JsonPropertyDescription(value="Specifies the value of the 'From:' header of the email message.")
    public Optional<String> getFromRef() {
        return Optional.ofNullable(this.fromRef);
    }

    @Override
    @JsonProperty(value="sender_ref")
    @JsonPropertyDescription(value="Specifies the value of the 'From' field of the email message")
    public Optional<String> getSenderRef() {
        return Optional.ofNullable(this.senderRef);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    public ImmutableSet<CyberObservableExtension> getExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExtensions() : this.extensions;
    }

    @Override
    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    public String getObservableObjectKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObservableObjectKey() : this.observableObjectKey;
    }

    @Override
    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged() {
        return Optional.ofNullable(this.defanged);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="objectMarkingRefs")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granularMarkings")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="hydrated")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    public String toJsonString() {
        return this.toJsonString;
    }

    public final EmailMessage withIsMultipart(Boolean value) {
        if (Objects.equals(this.isMultipart, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(value, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withDate(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "date");
        if (this.date == newValue) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, newValue, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withDate(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.date == value) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, value, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (Objects.equals(this.contentType, newValue)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, newValue, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withContentType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contentType, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, value, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withFromRef(String value) {
        String newValue = Objects.requireNonNull(value, "fromRef");
        if (Objects.equals(this.fromRef, newValue)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, newValue, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withFromRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.fromRef, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, value, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withSenderRef(String value) {
        String newValue = Objects.requireNonNull(value, "senderRef");
        if (Objects.equals(this.senderRef, newValue)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, newValue, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withSenderRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.senderRef, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, value, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, value, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withExtensions(CyberObservableExtension ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withExtensions(Iterable<? extends CyberObservableExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withObservableObjectKey(String value) {
        String newValue = Objects.requireNonNull(value, "observableObjectKey");
        if (this.observableObjectKey.equals(newValue)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, newValue, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withDefanged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defanged, newValue)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, newValue, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withDefanged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defanged, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, value, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, (ImmutableMap<String, Object>)newValue, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final EmailMessage withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, value, this.toJsonString));
    }

    public final EmailMessage withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return EmailMessage.validate(new EmailMessage(this.isMultipart, this.date, this.contentType, this.fromRef, this.senderRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmailMessage && this.equalTo((EmailMessage)another);
    }

    private boolean equalTo(EmailMessage another) {
        return Objects.equals(this.isMultipart, another.isMultipart) && Objects.equals(this.date, another.date) && Objects.equals(this.contentType, another.contentType) && Objects.equals(this.fromRef, another.fromRef) && Objects.equals(this.senderRef, another.senderRef) && this.id.equals(another.id) && Objects.equals(this.type, another.type) && this.extensions.equals(another.extensions) && this.observableObjectKey.equals(another.observableObjectKey) && Objects.equals(this.defanged, another.defanged) && this.customProperties.equals(another.customProperties) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.isMultipart);
        h += (h << 5) + Objects.hashCode(this.date);
        h += (h << 5) + Objects.hashCode(this.contentType);
        h += (h << 5) + Objects.hashCode(this.fromRef);
        h += (h << 5) + Objects.hashCode(this.senderRef);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.observableObjectKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defanged);
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EmailMessage").omitNullValues().add("isMultipart", (Object)this.isMultipart).add("date", (Object)this.date).add("contentType", (Object)this.contentType).add("fromRef", (Object)this.fromRef).add("senderRef", (Object)this.senderRef).add("id", (Object)this.id).add("type", (Object)this.type).add("extensions", this.extensions).add("observableObjectKey", (Object)this.observableObjectKey).add("defanged", (Object)this.defanged).add("customProperties", this.customProperties).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).toString();
    }

    private static EmailMessage validate(EmailMessage instance) {
        instance.validateEntity();
        return instance;
    }

    public static EmailMessage copyOf(EmailMessageCoo instance) {
        if (instance instanceof EmailMessage) {
            return (EmailMessage)instance;
        }
        return EmailMessage.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return EmailMessage.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="email-message")
    @JsonPropertyOrder(value={"type", "extensions", "is_multipart", "date", "content_type", "from_ref", "sender_ref", "to_refs", "cc_refs", "bcc_refs", "subject", "received_lines", "additional_header_fields", "body", "body_multipart", "raw_email_ref"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @Generated(from="EmailMessageCoo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXTENSIONS = 1L;
        private long optBits;
        @Nullable
        private Boolean isMultipart;
        @Nullable
        private StixInstant date;
        @Nullable
        private String contentType;
        @Nullable
        private String fromRef;
        @Nullable
        private String senderRef;
        @Nullable
        private String type;
        private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
        @Nullable
        private String observableObjectKey;
        @Nullable
        private Boolean defanged;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EmailMessageCoo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableObjectCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof EmailMessageCoo) {
                Optional<String> contentTypeOptional;
                Optional<String> senderRefOptional;
                Boolean isMultipartValue;
                Optional<String> fromRefOptional;
                instance = (EmailMessageCoo)object;
                Optional<StixInstant> dateOptional = instance.getDate();
                if (dateOptional.isPresent()) {
                    this.date(dateOptional);
                }
                if ((fromRefOptional = instance.getFromRef()).isPresent()) {
                    this.fromRef(fromRefOptional);
                }
                if ((isMultipartValue = instance.isMultipart()) != null) {
                    this.isMultipart(isMultipartValue);
                }
                if ((senderRefOptional = instance.getSenderRef()).isPresent()) {
                    this.senderRef(senderRefOptional);
                }
                if ((contentTypeOptional = instance.getContentType()).isPresent()) {
                    this.contentType(contentTypeOptional);
                }
            }
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.hydrated(instance.getHydrated());
                this.addAllGranularMarkings(instance.getGranularMarkings());
                String toJsonStringValue = instance.toJsonString();
                if (toJsonStringValue != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableObjectCommonProperties) {
                instance = (CyberObservableObjectCommonProperties)object;
                this.addAllExtensions(instance.getExtensions());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.observableObjectKey(instance.getObservableObjectKey());
                Optional<Boolean> defangedOptional = instance.getDefanged();
                if (defangedOptional.isPresent()) {
                    this.defanged(defangedOptional);
                }
            }
        }

        @JsonProperty(value="is_multipart")
        @JsonPropertyDescription(value="Indicates whether the email body contains multiple MIME parts.")
        @CanIgnoreReturnValue
        public final Builder isMultipart(Boolean isMultipart) {
            this.isMultipart = isMultipart;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder date(StixInstant date) {
            this.date = Objects.requireNonNull(date, "date");
            return this;
        }

        @JsonProperty(value="date")
        @JsonPropertyDescription(value="Specifies the date/time that the email message was sent.")
        @CanIgnoreReturnValue
        public final Builder date(Optional<? extends StixInstant> date) {
            this.date = date.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            return this;
        }

        @JsonProperty(value="content_type")
        @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header of the email message.")
        @CanIgnoreReturnValue
        public final Builder contentType(Optional<String> contentType) {
            this.contentType = contentType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromRef(String fromRef) {
            this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
            return this;
        }

        @JsonProperty(value="from_ref")
        @JsonPropertyDescription(value="Specifies the value of the 'From:' header of the email message.")
        @CanIgnoreReturnValue
        public final Builder fromRef(Optional<String> fromRef) {
            this.fromRef = fromRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder senderRef(String senderRef) {
            this.senderRef = Objects.requireNonNull(senderRef, "senderRef");
            return this;
        }

        @JsonProperty(value="sender_ref")
        @JsonPropertyDescription(value="Specifies the value of the 'From' field of the email message")
        @CanIgnoreReturnValue
        public final Builder senderRef(Optional<String> senderRef) {
            this.senderRef = senderRef.orElse(null);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtension(@Nullable CyberObservableExtension element) {
            this.extensions.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(CyberObservableExtension ... elements) {
            this.extensions.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="extensions")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
        @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
        @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions = ImmutableSet.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defanged(boolean defanged) {
            this.defanged = defanged;
            return this;
        }

        @JsonProperty(value="defanged")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
        @CanIgnoreReturnValue
        public final Builder defanged(Optional<Boolean> defanged) {
            this.defanged = defanged.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objectMarkingRefs")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granularMarkings")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        public EmailMessage build() {
            return EmailMessage.validate(new EmailMessage(this));
        }

        private boolean extensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="EmailMessageCoo", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte extensionsBuildStage = 0;
        private ImmutableSet<CyberObservableExtension> extensions;
        private byte observableObjectKeyBuildStage = 0;
        private String observableObjectKey;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(EmailMessage.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableSet<CyberObservableExtension> getExtensions() {
            if (this.extensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extensionsBuildStage == 0) {
                this.extensionsBuildStage = (byte)-1;
                this.extensions = ImmutableSet.copyOf((Collection)EmailMessage.this.getExtensionsInitialize());
                this.extensionsBuildStage = 1;
            }
            return this.extensions;
        }

        void extensions(ImmutableSet<CyberObservableExtension> extensions) {
            this.extensions = extensions;
            this.extensionsBuildStage = 1;
        }

        String getObservableObjectKey() {
            if (this.observableObjectKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.observableObjectKeyBuildStage == 0) {
                this.observableObjectKeyBuildStage = (byte)-1;
                this.observableObjectKey = Objects.requireNonNull(EmailMessage.this.getObservableObjectKeyInitialize(), "observableObjectKey");
                this.observableObjectKeyBuildStage = 1;
            }
            return this.observableObjectKey;
        }

        void observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = observableObjectKey;
            this.observableObjectKeyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.extensionsBuildStage == -1) {
                attributes.add("extensions");
            }
            if (this.observableObjectKeyBuildStage == -1) {
                attributes.add("observableObjectKey");
            }
            return "Cannot build EmailMessage, attribute initializers form cycle " + attributes;
        }
    }
}

