/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.EmailMessage;
import security.whisper.javastix.coo.types.MimePartTypeObj;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="email-message", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="email-message")
@JsonSerialize(as=EmailMessage.class)
@JsonDeserialize(builder=EmailMessage.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "is_multipart", "date", "content_type", "from_ref", "sender_ref", "to_refs", "cc_refs", "bcc_refs", "subject", "received_lines", "additional_header_fields", "body", "body_multipart", "raw_email_ref"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@BusinessRule.List(value={@BusinessRule(ifExp="isMultipart() == true", thenExp="getBody().isPresent() == false", errorMessage="Body cannot be used if isMultipart equals true"), @BusinessRule(ifExp="isMultipart() == false", thenExp="getBodyMultipart().isEmpty() == true", errorMessage="Body_Multipart cannot be used if isMultipart equals false")})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface EmailMessageCoo
extends CyberObservableObject {
    @JsonProperty(value="is_multipart")
    @JsonPropertyDescription(value="Indicates whether the email body contains multiple MIME parts.")
    @NotNull
    public Boolean isMultipart();

    @JsonProperty(value="date")
    @JsonPropertyDescription(value="Specifies the date/time that the email message was sent.")
    public Optional<StixInstant> getDate();

    @JsonProperty(value="content_type")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header of the email message.")
    public Optional<String> getContentType();

    @JsonProperty(value="from_ref")
    @JsonPropertyDescription(value="Specifies the value of the 'From:' header of the email message.")
    public Optional<String> getFromRef();

    @JsonProperty(value="sender_ref")
    @JsonPropertyDescription(value="Specifies the value of the 'From' field of the email message")
    public Optional<String> getSenderRef();

    @JsonProperty(value="to_refs")
    @JsonPropertyDescription(value="Specifies the mailboxes that are 'To:' recipients of the email message")
    default public Set<String> getToRefs() {
        return null;
    }

    @JsonProperty(value="cc_refs")
    @JsonPropertyDescription(value="Specifies the mailboxes that are 'CC:' recipients of the email message")
    default public Set<String> getCcRefs() {
        return null;
    }

    @JsonProperty(value="bcc_refs")
    @JsonPropertyDescription(value="Specifies the mailboxes that are 'BCC:' recipients of the email message.")
    default public Set<String> getBccRefs() {
        return null;
    }

    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="Specifies the subject of the email message.")
    default public Optional<String> getSubject() {
        return Optional.empty();
    }

    @JsonProperty(value="received_lines")
    @JsonPropertyDescription(value="Specifies one or more Received header fields that may be included in the email headers.")
    default public Set<String> getReceivedLines() {
        return null;
    }

    @JsonProperty(value="additional_header_fields")
    @JsonPropertyDescription(value="Specifies any other header fields (except for date, received_lines, content_type, from_ref, sender_ref, to_refs, cc_refs, bcc_refs, and subject) found in the email message, as a dictionary.")
    default public Map<String, String> getAdditionalHeaderFields() {
        return null;
    }

    @JsonProperty(value="body")
    @JsonPropertyDescription(value="Specifies a string containing the email body.")
    default public Optional<String> getBody() {
        return Optional.empty();
    }

    @JsonProperty(value="body_multipart")
    @JsonPropertyDescription(value="Specifies a list of the MIME parts that make up the email body.")
    default public Set<MimePartTypeObj> getBodyMultipart() {
        return null;
    }

    @JsonProperty(value="raw_email_ref")
    @JsonPropertyDescription(value="Specifies the raw binary contents of the email message, including both the headers and body, as a reference to an Artifact Object.")
    default public Optional<String> getRawEmailRef() {
        return Optional.empty();
    }

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getSubject().isPresent()) {
            identifier.append(this.getSubject().get());
        }
        if (this.getFromRef().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append(this.getFromRef().get());
        }
        if (this.getDate().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append(this.getDate().get().toString());
        }
        if (identifier.length() == 0) {
            if (this.getBody().isPresent()) {
                identifier.append(this.getBody().get().substring(0, Math.min(100, this.getBody().get().length())));
            } else {
                identifier.append("email:").append(this.isMultipart());
            }
        }
        return "email-message--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

