/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.objects.FileCoo;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="file")
@Generated(from="FileCoo", generator="Immutables")
@Immutable
public final class File
implements FileCoo {
    private final ImmutableMap<String, String> hashes;
    @Nullable
    private final Long size;
    @Nullable
    private final String name;
    @Nullable
    private final String nameEnc;
    @Nullable
    private final String magicNumberHex;
    @Nullable
    private final String mimeType;
    @Nullable
    private final StixInstant created;
    @Nullable
    private final StixInstant modified;
    @Nullable
    private final StixInstant accessed;
    @Nullable
    private final String parentDirectoryRef;
    @Nullable
    private final Boolean isEncrypted;
    @Nullable
    private final String encryptionAlgorithm;
    @Nullable
    private final String decryptionKey;
    @Nullable
    private final String contentRef;
    private final String id;
    private final String type;
    private final ImmutableSet<CyberObservableExtension> extensions;
    private final String observableObjectKey;
    @Nullable
    private final Boolean defanged;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final boolean hydrated;
    private final String toJsonString;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 1L;

    private File(Builder builder) {
        this.hashes = builder.hashes.build();
        this.size = builder.size;
        this.name = builder.name;
        this.nameEnc = builder.nameEnc;
        this.magicNumberHex = builder.magicNumberHex;
        this.mimeType = builder.mimeType;
        this.created = builder.created;
        this.modified = builder.modified;
        this.accessed = builder.accessed;
        this.parentDirectoryRef = builder.parentDirectoryRef;
        this.isEncrypted = builder.isEncrypted;
        this.encryptionAlgorithm = builder.encryptionAlgorithm;
        this.decryptionKey = builder.decryptionKey;
        this.contentRef = builder.contentRef;
        this.type = builder.type;
        this.defanged = builder.defanged;
        this.customProperties = builder.customProperties.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        if (builder.extensionsIsSet()) {
            this.initShim.extensions((ImmutableSet<CyberObservableExtension>)builder.extensions.build());
        }
        if (builder.observableObjectKey != null) {
            this.initShim.observableObjectKey(builder.observableObjectKey);
        }
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private File(ImmutableMap<String, String> hashes, @Nullable Long size, @Nullable String name, @Nullable String nameEnc, @Nullable String magicNumberHex, @Nullable String mimeType, @Nullable StixInstant created, @Nullable StixInstant modified, @Nullable StixInstant accessed, @Nullable String parentDirectoryRef, @Nullable Boolean isEncrypted, @Nullable String encryptionAlgorithm, @Nullable String decryptionKey, @Nullable String contentRef, String type, ImmutableSet<CyberObservableExtension> extensions, String observableObjectKey, @Nullable Boolean defanged, ImmutableMap<String, Object> customProperties, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, boolean hydrated, String toJsonString) {
        this.hashes = hashes;
        this.size = size;
        this.name = name;
        this.nameEnc = nameEnc;
        this.magicNumberHex = magicNumberHex;
        this.mimeType = mimeType;
        this.created = created;
        this.modified = modified;
        this.accessed = accessed;
        this.parentDirectoryRef = parentDirectoryRef;
        this.isEncrypted = isEncrypted;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.decryptionKey = decryptionKey;
        this.contentRef = contentRef;
        this.type = type;
        this.initShim.extensions(extensions);
        this.initShim.observableObjectKey(observableObjectKey);
        this.defanged = defanged;
        this.customProperties = customProperties;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private String getIdInitialize() {
        return FileCoo.super.getId();
    }

    private Set<CyberObservableExtension> getExtensionsInitialize() {
        return FileCoo.super.getExtensions();
    }

    private String getObservableObjectKeyInitialize() {
        return FileCoo.super.getObservableObjectKey();
    }

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the contents of the file.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @Override
    @JsonProperty(value="size")
    @JsonPropertyDescription(value="Specifies the size of the file, in bytes, as a non-negative integer.")
    public Optional<Long> getSize() {
        return Optional.ofNullable(this.size);
    }

    @Override
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the file.")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="name_enc")
    @JsonPropertyDescription(value="Specifies the observed encoding for the name of the file.")
    public Optional<String> getNameEnc() {
        return Optional.ofNullable(this.nameEnc);
    }

    @Override
    @JsonProperty(value="magic_number_hex")
    @JsonPropertyDescription(value="Specifies the hexadecimal constant ('magic number') associated with a specific file format that corresponds to the file, if applicable.")
    public Optional<String> getMagicNumberHex() {
        return Optional.ofNullable(this.magicNumberHex);
    }

    @Override
    @JsonProperty(value="mime_type")
    @JsonPropertyDescription(value="Specifies the MIME type name specified for the file, e.g., 'application/msword'.")
    public Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    @Override
    @JsonProperty(value="created")
    @JsonPropertyDescription(value="Specifies the date/time the file was created.")
    public Optional<StixInstant> getCreated() {
        return Optional.ofNullable(this.created);
    }

    @Override
    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="Specifies the date/time the file was last written to/modified.")
    public Optional<StixInstant> getModified() {
        return Optional.ofNullable(this.modified);
    }

    @Override
    @JsonProperty(value="accessed")
    @JsonPropertyDescription(value="Specifies the date/time the file was last accessed.")
    public Optional<StixInstant> getAccessed() {
        return Optional.ofNullable(this.accessed);
    }

    @Override
    @JsonProperty(value="parent_directory_ref")
    @JsonPropertyDescription(value="Specifies the parent directory of the file, as a reference to a Directory Object.")
    public Optional<String> getParentDirectoryRef() {
        return Optional.ofNullable(this.parentDirectoryRef);
    }

    @Override
    @JsonProperty(value="is_encrypted")
    @JsonPropertyDescription(value="Specifies whether the file is encrypted.")
    public Optional<Boolean> isEncrypted() {
        return Optional.ofNullable(this.isEncrypted);
    }

    @Override
    @JsonProperty(value="encryption_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the encryption algorithm used to encrypt the file. Open Vocabulary - encryption-algorithm-ov")
    public Optional<String> getEncryptionAlgorithm() {
        return Optional.ofNullable(this.encryptionAlgorithm);
    }

    @Override
    @JsonProperty(value="decryption_key")
    @JsonPropertyDescription(value="Specifies the decryption key used to decrypt the archive file.")
    public Optional<String> getDecryptionKey() {
        return Optional.ofNullable(this.decryptionKey);
    }

    @Override
    @JsonProperty(value="content_ref")
    @JsonPropertyDescription(value="Specifies the content of the file, represented as an Artifact Object.")
    public Optional<String> getContentRef() {
        return Optional.ofNullable(this.contentRef);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    public ImmutableSet<CyberObservableExtension> getExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExtensions() : this.extensions;
    }

    @Override
    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    public String getObservableObjectKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObservableObjectKey() : this.observableObjectKey;
    }

    @Override
    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged() {
        return Optional.ofNullable(this.defanged);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="objectMarkingRefs")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granularMarkings")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="hydrated")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    public String toJsonString() {
        return this.toJsonString;
    }

    public final File withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return File.validate(new File((ImmutableMap<String, String>)newValue, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withSize(long value) {
        Long newValue = value;
        if (Objects.equals(this.size, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, newValue, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, value, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, newValue, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, value, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withNameEnc(String value) {
        String newValue = Objects.requireNonNull(value, "nameEnc");
        if (Objects.equals(this.nameEnc, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, newValue, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withNameEnc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nameEnc, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, value, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withMagicNumberHex(String value) {
        String newValue = Objects.requireNonNull(value, "magicNumberHex");
        if (Objects.equals(this.magicNumberHex, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, newValue, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withMagicNumberHex(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.magicNumberHex, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, value, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withMimeType(String value) {
        String newValue = Objects.requireNonNull(value, "mimeType");
        if (Objects.equals(this.mimeType, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, newValue, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withMimeType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mimeType, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, value, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withCreated(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "created");
        if (this.created == newValue) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, newValue, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withCreated(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.created == value) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, value, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withModified(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "modified");
        if (this.modified == newValue) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, newValue, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withModified(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.modified == value) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, value, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withAccessed(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "accessed");
        if (this.accessed == newValue) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, newValue, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withAccessed(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.accessed == value) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, value, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withParentDirectoryRef(String value) {
        String newValue = Objects.requireNonNull(value, "parentDirectoryRef");
        if (Objects.equals(this.parentDirectoryRef, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, newValue, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withParentDirectoryRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.parentDirectoryRef, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, value, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withIsEncrypted(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isEncrypted, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, newValue, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withIsEncrypted(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isEncrypted, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, value, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withEncryptionAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "encryptionAlgorithm");
        if (Objects.equals(this.encryptionAlgorithm, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, newValue, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withEncryptionAlgorithm(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.encryptionAlgorithm, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, value, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withDecryptionKey(String value) {
        String newValue = Objects.requireNonNull(value, "decryptionKey");
        if (Objects.equals(this.decryptionKey, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, newValue, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withDecryptionKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.decryptionKey, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, value, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withContentRef(String value) {
        String newValue = Objects.requireNonNull(value, "contentRef");
        if (Objects.equals(this.contentRef, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, newValue, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withContentRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contentRef, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, value, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, value, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withExtensions(CyberObservableExtension ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withExtensions(Iterable<? extends CyberObservableExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withObservableObjectKey(String value) {
        String newValue = Objects.requireNonNull(value, "observableObjectKey");
        if (this.observableObjectKey.equals(newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, newValue, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withDefanged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defanged, newValue)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, newValue, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withDefanged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defanged, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, value, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, (ImmutableMap<String, Object>)newValue, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final File withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final File withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final File withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, value, this.toJsonString));
    }

    public final File withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return File.validate(new File(this.hashes, this.size, this.name, this.nameEnc, this.magicNumberHex, this.mimeType, this.created, this.modified, this.accessed, this.parentDirectoryRef, this.isEncrypted, this.encryptionAlgorithm, this.decryptionKey, this.contentRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof File && this.equalTo((File)another);
    }

    private boolean equalTo(File another) {
        return this.hashes.equals(another.hashes) && Objects.equals(this.size, another.size) && Objects.equals(this.name, another.name) && Objects.equals(this.nameEnc, another.nameEnc) && Objects.equals(this.magicNumberHex, another.magicNumberHex) && Objects.equals(this.mimeType, another.mimeType) && Objects.equals(this.created, another.created) && Objects.equals(this.modified, another.modified) && Objects.equals(this.accessed, another.accessed) && Objects.equals(this.parentDirectoryRef, another.parentDirectoryRef) && Objects.equals(this.isEncrypted, another.isEncrypted) && Objects.equals(this.encryptionAlgorithm, another.encryptionAlgorithm) && Objects.equals(this.decryptionKey, another.decryptionKey) && Objects.equals(this.contentRef, another.contentRef) && this.id.equals(another.id) && Objects.equals(this.type, another.type) && this.extensions.equals(another.extensions) && this.observableObjectKey.equals(another.observableObjectKey) && Objects.equals(this.defanged, another.defanged) && this.customProperties.equals(another.customProperties) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + Objects.hashCode(this.size);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.nameEnc);
        h += (h << 5) + Objects.hashCode(this.magicNumberHex);
        h += (h << 5) + Objects.hashCode(this.mimeType);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.modified);
        h += (h << 5) + Objects.hashCode(this.accessed);
        h += (h << 5) + Objects.hashCode(this.parentDirectoryRef);
        h += (h << 5) + Objects.hashCode(this.isEncrypted);
        h += (h << 5) + Objects.hashCode(this.encryptionAlgorithm);
        h += (h << 5) + Objects.hashCode(this.decryptionKey);
        h += (h << 5) + Objects.hashCode(this.contentRef);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.observableObjectKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defanged);
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"File").omitNullValues().add("hashes", this.hashes).add("size", (Object)this.size).add("name", (Object)this.name).add("nameEnc", (Object)this.nameEnc).add("magicNumberHex", (Object)this.magicNumberHex).add("mimeType", (Object)this.mimeType).add("created", (Object)this.created).add("modified", (Object)this.modified).add("accessed", (Object)this.accessed).add("parentDirectoryRef", (Object)this.parentDirectoryRef).add("isEncrypted", (Object)this.isEncrypted).add("encryptionAlgorithm", (Object)this.encryptionAlgorithm).add("decryptionKey", (Object)this.decryptionKey).add("contentRef", (Object)this.contentRef).add("id", (Object)this.id).add("type", (Object)this.type).add("extensions", this.extensions).add("observableObjectKey", (Object)this.observableObjectKey).add("defanged", (Object)this.defanged).add("customProperties", this.customProperties).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).toString();
    }

    private static File validate(File instance) {
        instance.validateEntity();
        return instance;
    }

    public static File copyOf(FileCoo instance) {
        if (instance instanceof File) {
            return (File)instance;
        }
        return File.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return File.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="file")
    @JsonPropertyOrder(value={"type", "extensions", "hashes", "size", "name", "name_enc", "magic_number_hex", "mime_type", "created", "modified", "accessed", "parent_directory_ref", "is_encrypted", "encryption_algorithm", "decryption_key", "contains_refs", "content_ref"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @Generated(from="FileCoo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXTENSIONS = 1L;
        private long optBits;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        @Nullable
        private Long size;
        @Nullable
        private String name;
        @Nullable
        private String nameEnc;
        @Nullable
        private String magicNumberHex;
        @Nullable
        private String mimeType;
        @Nullable
        private StixInstant created;
        @Nullable
        private StixInstant modified;
        @Nullable
        private StixInstant accessed;
        @Nullable
        private String parentDirectoryRef;
        @Nullable
        private Boolean isEncrypted;
        @Nullable
        private String encryptionAlgorithm;
        @Nullable
        private String decryptionKey;
        @Nullable
        private String contentRef;
        @Nullable
        private String type;
        private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
        @Nullable
        private String observableObjectKey;
        @Nullable
        private Boolean defanged;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableObjectCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FileCoo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.hydrated(instance.getHydrated());
                this.addAllGranularMarkings(instance.getGranularMarkings());
                String toJsonStringValue = instance.toJsonString();
                if (toJsonStringValue != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableObjectCommonProperties) {
                instance = (CyberObservableObjectCommonProperties)object;
                this.addAllExtensions(instance.getExtensions());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.observableObjectKey(instance.getObservableObjectKey());
                Optional<Boolean> defangedOptional = instance.getDefanged();
                if (defangedOptional.isPresent()) {
                    this.defanged(defangedOptional);
                }
            }
            if (object instanceof FileCoo) {
                Optional<String> contentRefOptional;
                Optional<StixInstant> modifiedOptional;
                Optional<Boolean> isEncryptedOptional;
                Optional<Long> sizeOptional;
                Optional<String> parentDirectoryRefOptional;
                Optional<String> decryptionKeyOptional;
                Optional<String> magicNumberHexOptional;
                Optional<String> encryptionAlgorithmOptional;
                Optional<String> nameEncOptional;
                Optional<StixInstant> accessedOptional;
                Optional<String> mimeTypeOptional;
                instance = (FileCoo)object;
                Optional<StixInstant> createdOptional = instance.getCreated();
                if (createdOptional.isPresent()) {
                    this.created(createdOptional);
                }
                if ((mimeTypeOptional = instance.getMimeType()).isPresent()) {
                    this.mimeType(mimeTypeOptional);
                }
                if ((accessedOptional = instance.getAccessed()).isPresent()) {
                    this.accessed(accessedOptional);
                }
                if ((nameEncOptional = instance.getNameEnc()).isPresent()) {
                    this.nameEnc(nameEncOptional);
                }
                if ((encryptionAlgorithmOptional = instance.getEncryptionAlgorithm()).isPresent()) {
                    this.encryptionAlgorithm(encryptionAlgorithmOptional);
                }
                if ((magicNumberHexOptional = instance.getMagicNumberHex()).isPresent()) {
                    this.magicNumberHex(magicNumberHexOptional);
                }
                if ((decryptionKeyOptional = instance.getDecryptionKey()).isPresent()) {
                    this.decryptionKey(decryptionKeyOptional);
                }
                if ((parentDirectoryRefOptional = instance.getParentDirectoryRef()).isPresent()) {
                    this.parentDirectoryRef(parentDirectoryRefOptional);
                }
                if ((sizeOptional = instance.getSize()).isPresent()) {
                    this.size(sizeOptional);
                }
                if ((isEncryptedOptional = instance.isEncrypted()).isPresent()) {
                    this.isEncrypted(isEncryptedOptional);
                }
                this.putAllHashes(instance.getHashes());
                Optional<String> nameOptional = instance.getName();
                if (nameOptional.isPresent()) {
                    this.name(nameOptional);
                }
                if ((modifiedOptional = instance.getModified()).isPresent()) {
                    this.modified(modifiedOptional);
                }
                if ((contentRefOptional = instance.getContentRef()).isPresent()) {
                    this.contentRef(contentRefOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonPropertyDescription(value="Specifies a dictionary of hashes for the contents of the file.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder size(long size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="size")
        @JsonPropertyDescription(value="Specifies the size of the file, in bytes, as a non-negative integer.")
        @CanIgnoreReturnValue
        public final Builder size(Optional<Long> size) {
            this.size = size.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        @JsonPropertyDescription(value="Specifies the name of the file.")
        @CanIgnoreReturnValue
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nameEnc(String nameEnc) {
            this.nameEnc = Objects.requireNonNull(nameEnc, "nameEnc");
            return this;
        }

        @JsonProperty(value="name_enc")
        @JsonPropertyDescription(value="Specifies the observed encoding for the name of the file.")
        @CanIgnoreReturnValue
        public final Builder nameEnc(Optional<String> nameEnc) {
            this.nameEnc = nameEnc.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder magicNumberHex(String magicNumberHex) {
            this.magicNumberHex = Objects.requireNonNull(magicNumberHex, "magicNumberHex");
            return this;
        }

        @JsonProperty(value="magic_number_hex")
        @JsonPropertyDescription(value="Specifies the hexadecimal constant ('magic number') associated with a specific file format that corresponds to the file, if applicable.")
        @CanIgnoreReturnValue
        public final Builder magicNumberHex(Optional<String> magicNumberHex) {
            this.magicNumberHex = magicNumberHex.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mimeType(String mimeType) {
            this.mimeType = Objects.requireNonNull(mimeType, "mimeType");
            return this;
        }

        @JsonProperty(value="mime_type")
        @JsonPropertyDescription(value="Specifies the MIME type name specified for the file, e.g., 'application/msword'.")
        @CanIgnoreReturnValue
        public final Builder mimeType(Optional<String> mimeType) {
            this.mimeType = mimeType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder created(StixInstant created) {
            this.created = Objects.requireNonNull(created, "created");
            return this;
        }

        @JsonProperty(value="created")
        @JsonPropertyDescription(value="Specifies the date/time the file was created.")
        @CanIgnoreReturnValue
        public final Builder created(Optional<? extends StixInstant> created) {
            this.created = created.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder modified(StixInstant modified) {
            this.modified = Objects.requireNonNull(modified, "modified");
            return this;
        }

        @JsonProperty(value="modified")
        @JsonPropertyDescription(value="Specifies the date/time the file was last written to/modified.")
        @CanIgnoreReturnValue
        public final Builder modified(Optional<? extends StixInstant> modified) {
            this.modified = modified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessed(StixInstant accessed) {
            this.accessed = Objects.requireNonNull(accessed, "accessed");
            return this;
        }

        @JsonProperty(value="accessed")
        @JsonPropertyDescription(value="Specifies the date/time the file was last accessed.")
        @CanIgnoreReturnValue
        public final Builder accessed(Optional<? extends StixInstant> accessed) {
            this.accessed = accessed.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentDirectoryRef(String parentDirectoryRef) {
            this.parentDirectoryRef = Objects.requireNonNull(parentDirectoryRef, "parentDirectoryRef");
            return this;
        }

        @JsonProperty(value="parent_directory_ref")
        @JsonPropertyDescription(value="Specifies the parent directory of the file, as a reference to a Directory Object.")
        @CanIgnoreReturnValue
        public final Builder parentDirectoryRef(Optional<String> parentDirectoryRef) {
            this.parentDirectoryRef = parentDirectoryRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isEncrypted(boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        @JsonProperty(value="is_encrypted")
        @JsonPropertyDescription(value="Specifies whether the file is encrypted.")
        @CanIgnoreReturnValue
        public final Builder isEncrypted(Optional<Boolean> isEncrypted) {
            this.isEncrypted = isEncrypted.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm, "encryptionAlgorithm");
            return this;
        }

        @JsonProperty(value="encryption_algorithm")
        @JsonPropertyDescription(value="Specifies the name of the encryption algorithm used to encrypt the file. Open Vocabulary - encryption-algorithm-ov")
        @CanIgnoreReturnValue
        public final Builder encryptionAlgorithm(Optional<String> encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder decryptionKey(String decryptionKey) {
            this.decryptionKey = Objects.requireNonNull(decryptionKey, "decryptionKey");
            return this;
        }

        @JsonProperty(value="decryption_key")
        @JsonPropertyDescription(value="Specifies the decryption key used to decrypt the archive file.")
        @CanIgnoreReturnValue
        public final Builder decryptionKey(Optional<String> decryptionKey) {
            this.decryptionKey = decryptionKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentRef(String contentRef) {
            this.contentRef = Objects.requireNonNull(contentRef, "contentRef");
            return this;
        }

        @JsonProperty(value="content_ref")
        @JsonPropertyDescription(value="Specifies the content of the file, represented as an Artifact Object.")
        @CanIgnoreReturnValue
        public final Builder contentRef(Optional<String> contentRef) {
            this.contentRef = contentRef.orElse(null);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtension(@Nullable CyberObservableExtension element) {
            this.extensions.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(CyberObservableExtension ... elements) {
            this.extensions.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="extensions")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
        @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
        @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions = ImmutableSet.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defanged(boolean defanged) {
            this.defanged = defanged;
            return this;
        }

        @JsonProperty(value="defanged")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
        @CanIgnoreReturnValue
        public final Builder defanged(Optional<Boolean> defanged) {
            this.defanged = defanged.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objectMarkingRefs")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granularMarkings")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        public File build() {
            return File.validate(new File(this));
        }

        private boolean extensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="FileCoo", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte extensionsBuildStage = 0;
        private ImmutableSet<CyberObservableExtension> extensions;
        private byte observableObjectKeyBuildStage = 0;
        private String observableObjectKey;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(File.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableSet<CyberObservableExtension> getExtensions() {
            if (this.extensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extensionsBuildStage == 0) {
                this.extensionsBuildStage = (byte)-1;
                this.extensions = ImmutableSet.copyOf((Collection)File.this.getExtensionsInitialize());
                this.extensionsBuildStage = 1;
            }
            return this.extensions;
        }

        void extensions(ImmutableSet<CyberObservableExtension> extensions) {
            this.extensions = extensions;
            this.extensionsBuildStage = 1;
        }

        String getObservableObjectKey() {
            if (this.observableObjectKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.observableObjectKeyBuildStage == 0) {
                this.observableObjectKeyBuildStage = (byte)-1;
                this.observableObjectKey = Objects.requireNonNull(File.this.getObservableObjectKeyInitialize(), "observableObjectKey");
                this.observableObjectKeyBuildStage = 1;
            }
            return this.observableObjectKey;
        }

        void observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = observableObjectKey;
            this.observableObjectKeyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.extensionsBuildStage == -1) {
                attributes.add("extensions");
            }
            if (this.observableObjectKeyBuildStage == -1) {
                attributes.add("observableObjectKey");
            }
            return "Cannot build File, attribute initializers form cycle " + attributes;
        }
    }
}

