/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.File;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.EncryptionAlgorithms;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@DefaultTypeValue(value="file", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="file")
@JsonSerialize(as=File.class)
@JsonDeserialize(builder=File.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "hashes", "size", "name", "name_enc", "magic_number_hex", "mime_type", "created", "modified", "accessed", "parent_directory_ref", "is_encrypted", "encryption_algorithm", "decryption_key", "contains_refs", "content_ref"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@BusinessRule(ifExp="isEncrypted().orElse(false) == false", thenExp="getEncryptionAlgorithm().isPresent() == false && getDecryptionKey().isPresent() == false", errorMessage="Encryption Algorithm and Description Key cannot be used if Encrypted equals false.")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface FileCoo
extends CyberObservableObject {
    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies a dictionary of hashes for the contents of the file.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();

    @JsonProperty(value="size")
    @JsonPropertyDescription(value="Specifies the size of the file, in bytes, as a non-negative integer.")
    public Optional<@Positive Long> getSize();

    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the file.")
    public Optional<String> getName();

    @JsonProperty(value="name_enc")
    @JsonPropertyDescription(value="Specifies the observed encoding for the name of the file.")
    public Optional<@Pattern(regexp="^[a-zA-Z0-9/\\.+_:-]{2,250}$") String> getNameEnc();

    @JsonProperty(value="magic_number_hex")
    @JsonPropertyDescription(value="Specifies the hexadecimal constant ('magic number') associated with a specific file format that corresponds to the file, if applicable.")
    public Optional<@Pattern(regexp="^([a-fA-F0-9]{2})+$") String> getMagicNumberHex();

    @JsonProperty(value="mime_type")
    @JsonPropertyDescription(value="Specifies the MIME type name specified for the file, e.g., 'application/msword'.")
    public Optional<@Pattern(regexp="^(application|audio|font|image|message|model|multipart|text|video)/[a-zA-Z0-9.+_-]+") String> getMimeType();

    @JsonProperty(value="created")
    @JsonPropertyDescription(value="Specifies the date/time the file was created.")
    public Optional<StixInstant> getCreated();

    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="Specifies the date/time the file was last written to/modified.")
    public Optional<StixInstant> getModified();

    @JsonProperty(value="accessed")
    @JsonPropertyDescription(value="Specifies the date/time the file was last accessed.")
    public Optional<StixInstant> getAccessed();

    @JsonProperty(value="parent_directory_ref")
    @JsonPropertyDescription(value="Specifies the parent directory of the file, as a reference to a Directory Object.")
    public Optional<String> getParentDirectoryRef();

    @JsonProperty(value="is_encrypted")
    @JsonPropertyDescription(value="Specifies whether the file is encrypted.")
    @NotNull
    public Optional<Boolean> isEncrypted();

    @JsonProperty(value="encryption_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the encryption algorithm used to encrypt the file. Open Vocabulary - encryption-algorithm-ov")
    public Optional<@Vocab(value=EncryptionAlgorithms.class) String> getEncryptionAlgorithm();

    @JsonProperty(value="decryption_key")
    @JsonPropertyDescription(value="Specifies the decryption key used to decrypt the archive file.")
    public Optional<String> getDecryptionKey();

    @JsonProperty(value="contains_refs")
    @JsonPropertyDescription(value="Specifies a list of references to other Observable Objects contained within the file.")
    default public Set<String> getContainsRefs() {
        return null;
    }

    @JsonProperty(value="content_ref")
    @JsonPropertyDescription(value="Specifies the content of the file, represented as an Artifact Object.")
    public Optional<String> getContentRef();

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getHashes() != null && !this.getHashes().isEmpty()) {
            identifier.append(this.getHashes().entrySet().stream().sorted(Map.Entry.comparingByKey()).findFirst().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).orElse(""));
        }
        if (this.getName().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append(this.getName().get());
        }
        if (identifier.length() == 0) {
            if (this.getSize().isPresent()) {
                identifier.append("size:").append(this.getSize().get());
            } else {
                identifier.append("file:unknown");
            }
        }
        return "file--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

