/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Ipv6Address;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="ipv6-addr", groups={DefaultValuesProcessor.class})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="ipv6-addr")
@JsonSerialize(as=Ipv6Address.class)
@JsonDeserialize(builder=Ipv6Address.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "value", "resolves_to_refs", "belongs_to_refs"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface Ipv6AddressCoo
extends CyberObservableObject {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Specifies one or more IPv6 addresses expressed using CIDR notation.")
    @NotNull
    public String getValue();

    @JsonProperty(value="resolves_to_refs")
    @JsonPropertyDescription(value="Specifies a list of references to one or more Layer 2 Media Access Control (MAC) addresses that the IPv4 address resolves to.")
    default public Set<String> getResolvesToRefs() {
        return null;
    }

    @JsonProperty(value="belongs_to_refs")
    @JsonPropertyDescription(value="Specifies a reference to one or more autonomous systems (AS) that the IPv4 address belongs to.")
    default public Set<String> getBelongsToRefs() {
        return null;
    }

    @Override
    @Value.Derived
    default public String getId() {
        return "ipv6-addr--" + UUID.nameUUIDFromBytes(this.getValue().getBytes(StandardCharsets.UTF_8));
    }
}

