/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.MacAddress;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="mac-addr", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="mac-addr")
@JsonSerialize(as=MacAddress.class)
@JsonDeserialize(builder=MacAddress.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "value"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface MacAddressCoo
extends CyberObservableObject {
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Specifies one or more mac addresses expressed using CIDR notation.")
    @Pattern(regexp="^([0-9a-f]{2}[:]){5}([0-9a-f]{2})$")
    @NotNull
    public @Pattern(regexp="^([0-9a-f]{2}[:]){5}([0-9a-f]{2})$") @NotNull String getValue();

    @Override
    @Value.Derived
    default public String getId() {
        return "mac-addr--" + UUID.nameUUIDFromBytes(this.getValue().getBytes(StandardCharsets.UTF_8));
    }
}

