/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Mutex;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="mutex", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="mutex")
@JsonSerialize(as=Mutex.class)
@JsonDeserialize(builder=Mutex.Builder.class)
@JsonPropertyOrder(value={"type", "extensions", "name"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface MutexCoo
extends CyberObservableObject {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the mutex object.")
    @NotNull
    public String getName();

    @Override
    @Value.Derived
    default public String getId() {
        return "mutex--" + UUID.nameUUIDFromBytes(this.getName().getBytes(StandardCharsets.UTF_8));
    }
}

