/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.objects.NetworkTrafficCoo;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="network-traffic")
@Generated(from="NetworkTrafficCoo", generator="Immutables")
@Immutable
public final class NetworkTraffic
implements NetworkTrafficCoo {
    @Nullable
    private final StixInstant start;
    @Nullable
    private final StixInstant end;
    @Nullable
    private final Boolean isActive;
    @Nullable
    private final String srcRef;
    @Nullable
    private final String dstRef;
    @Nullable
    private final Integer srcPort;
    @Nullable
    private final Integer dstPort;
    @Nullable
    private final Long srcByteCount;
    @Nullable
    private final Long dstByteCount;
    @Nullable
    private final Long srcPackets;
    @Nullable
    private final Long dstPackets;
    private final ImmutableMap<String, Object> ipFix;
    @Nullable
    private final String srcPayloadRef;
    @Nullable
    private final String dstPayloadRef;
    @Nullable
    private final String encapsulatedByRef;
    private final String id;
    private final String type;
    private final ImmutableSet<CyberObservableExtension> extensions;
    private final String observableObjectKey;
    @Nullable
    private final Boolean defanged;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final boolean hydrated;
    private final String toJsonString;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 1L;

    private NetworkTraffic(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.isActive = builder.isActive;
        this.srcRef = builder.srcRef;
        this.dstRef = builder.dstRef;
        this.srcPort = builder.srcPort;
        this.dstPort = builder.dstPort;
        this.srcByteCount = builder.srcByteCount;
        this.dstByteCount = builder.dstByteCount;
        this.srcPackets = builder.srcPackets;
        this.dstPackets = builder.dstPackets;
        this.ipFix = builder.ipFix.build();
        this.srcPayloadRef = builder.srcPayloadRef;
        this.dstPayloadRef = builder.dstPayloadRef;
        this.encapsulatedByRef = builder.encapsulatedByRef;
        this.type = builder.type;
        this.defanged = builder.defanged;
        this.customProperties = builder.customProperties.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        if (builder.extensionsIsSet()) {
            this.initShim.extensions((ImmutableSet<CyberObservableExtension>)builder.extensions.build());
        }
        if (builder.observableObjectKey != null) {
            this.initShim.observableObjectKey(builder.observableObjectKey);
        }
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private NetworkTraffic(@Nullable StixInstant start, @Nullable StixInstant end, @Nullable Boolean isActive, @Nullable String srcRef, @Nullable String dstRef, @Nullable Integer srcPort, @Nullable Integer dstPort, @Nullable Long srcByteCount, @Nullable Long dstByteCount, @Nullable Long srcPackets, @Nullable Long dstPackets, ImmutableMap<String, Object> ipFix, @Nullable String srcPayloadRef, @Nullable String dstPayloadRef, @Nullable String encapsulatedByRef, String type, ImmutableSet<CyberObservableExtension> extensions, String observableObjectKey, @Nullable Boolean defanged, ImmutableMap<String, Object> customProperties, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, boolean hydrated, String toJsonString) {
        this.start = start;
        this.end = end;
        this.isActive = isActive;
        this.srcRef = srcRef;
        this.dstRef = dstRef;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.srcByteCount = srcByteCount;
        this.dstByteCount = dstByteCount;
        this.srcPackets = srcPackets;
        this.dstPackets = dstPackets;
        this.ipFix = ipFix;
        this.srcPayloadRef = srcPayloadRef;
        this.dstPayloadRef = dstPayloadRef;
        this.encapsulatedByRef = encapsulatedByRef;
        this.type = type;
        this.initShim.extensions(extensions);
        this.initShim.observableObjectKey(observableObjectKey);
        this.defanged = defanged;
        this.customProperties = customProperties;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private String getIdInitialize() {
        return NetworkTrafficCoo.super.getId();
    }

    private Set<CyberObservableExtension> getExtensionsInitialize() {
        return NetworkTrafficCoo.super.getExtensions();
    }

    private String getObservableObjectKeyInitialize() {
        return NetworkTrafficCoo.super.getObservableObjectKey();
    }

    @Override
    @JsonProperty(value="start")
    @JsonPropertyDescription(value="Specifies the date/time the network traffic was initiated, if known.")
    public Optional<StixInstant> getStart() {
        return Optional.ofNullable(this.start);
    }

    @Override
    @JsonProperty(value="end")
    @JsonPropertyDescription(value="Specifies the date/time the network traffic ended, if known.")
    public Optional<StixInstant> getEnd() {
        return Optional.ofNullable(this.end);
    }

    @Override
    @JsonProperty(value="is_active")
    @JsonPropertyDescription(value="Indicates whether the network traffic is still ongoing.")
    public Optional<Boolean> isActive() {
        return Optional.ofNullable(this.isActive);
    }

    @Override
    @JsonProperty(value="src_ref")
    @JsonPropertyDescription(value="Specifies the source of the network traffic, as a reference to one or more Observable Objects.")
    public Optional<String> getSrcRef() {
        return Optional.ofNullable(this.srcRef);
    }

    @Override
    @JsonProperty(value="dst_ref")
    @JsonPropertyDescription(value="Specifies the destination of the network traffic, as a reference to one or more Observable Objects.")
    public Optional<String> getDstRef() {
        return Optional.ofNullable(this.dstRef);
    }

    @Override
    @JsonProperty(value="src_port")
    @JsonPropertyDescription(value="Specifies the source port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public Optional<Integer> getSrcPort() {
        return Optional.ofNullable(this.srcPort);
    }

    @Override
    @JsonProperty(value="dst_port")
    @JsonPropertyDescription(value="Specifies the destination port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public Optional<Integer> getDstPort() {
        return Optional.ofNullable(this.dstPort);
    }

    @Override
    @JsonProperty(value="src_byte_count")
    @JsonPropertyDescription(value="Specifies the number of bytes sent from the source to the destination.")
    public Optional<Long> getSrcByteCount() {
        return Optional.ofNullable(this.srcByteCount);
    }

    @Override
    @JsonProperty(value="dst_byte_count")
    @JsonPropertyDescription(value="Specifies the number of bytes sent from the destination to the source.")
    public Optional<Long> getDstByteCount() {
        return Optional.ofNullable(this.dstByteCount);
    }

    @Override
    @JsonProperty(value="src_packets")
    @JsonPropertyDescription(value="Specifies the number of packets sent from the source to the destination.")
    public Optional<Long> getSrcPackets() {
        return Optional.ofNullable(this.srcPackets);
    }

    @Override
    @JsonProperty(value="dst_packets")
    @JsonPropertyDescription(value="Specifies the number of packets sent destination to the source.")
    public Optional<Long> getDstPackets() {
        return Optional.ofNullable(this.dstPackets);
    }

    @JsonProperty(value="ipfix")
    @JsonPropertyDescription(value="Specifies any IP Flow Information Export [IPFIX] data for the traffic, as a dictionary.")
    public ImmutableMap<String, Object> getIpFix() {
        return this.ipFix;
    }

    @Override
    @JsonProperty(value="src_payload_ref")
    @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
    public Optional<String> getSrcPayloadRef() {
        return Optional.ofNullable(this.srcPayloadRef);
    }

    @Override
    @JsonProperty(value="dst_payload_ref")
    @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
    public Optional<String> getDstPayloadRef() {
        return Optional.ofNullable(this.dstPayloadRef);
    }

    @Override
    @JsonProperty(value="encapsulated_by_ref")
    @JsonPropertyDescription(value="Links to another network-traffic object which encapsulates this object.")
    public Optional<String> getEncapsulatedByRef() {
        return Optional.ofNullable(this.encapsulatedByRef);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    public ImmutableSet<CyberObservableExtension> getExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExtensions() : this.extensions;
    }

    @Override
    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    public String getObservableObjectKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObservableObjectKey() : this.observableObjectKey;
    }

    @Override
    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged() {
        return Optional.ofNullable(this.defanged);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="objectMarkingRefs")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granularMarkings")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="hydrated")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    public String toJsonString() {
        return this.toJsonString;
    }

    public final NetworkTraffic withStart(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "start");
        if (this.start == newValue) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(newValue, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withStart(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.start == value) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(value, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withEnd(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "end");
        if (this.end == newValue) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, newValue, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withEnd(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.end == value) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, value, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withIsActive(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isActive, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, newValue, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withIsActive(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isActive, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, value, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcRef(String value) {
        String newValue = Objects.requireNonNull(value, "srcRef");
        if (Objects.equals(this.srcRef, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, newValue, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.srcRef, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, value, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstRef(String value) {
        String newValue = Objects.requireNonNull(value, "dstRef");
        if (Objects.equals(this.dstRef, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, newValue, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dstRef, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, value, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.srcPort, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, newValue, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPort(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.srcPort, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, value, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.dstPort, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, newValue, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPort(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.dstPort, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, value, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcByteCount(long value) {
        Long newValue = value;
        if (Objects.equals(this.srcByteCount, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, newValue, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcByteCount(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.srcByteCount, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, value, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstByteCount(long value) {
        Long newValue = value;
        if (Objects.equals(this.dstByteCount, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, newValue, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstByteCount(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.dstByteCount, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, value, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPackets(long value) {
        Long newValue = value;
        if (Objects.equals(this.srcPackets, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, newValue, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPackets(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.srcPackets, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, value, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPackets(long value) {
        Long newValue = value;
        if (Objects.equals(this.dstPackets, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, newValue, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPackets(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.dstPackets, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, value, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withIpFix(Map<String, ? extends Object> entries) {
        if (this.ipFix == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, (ImmutableMap<String, Object>)newValue, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPayloadRef(String value) {
        String newValue = Objects.requireNonNull(value, "srcPayloadRef");
        if (Objects.equals(this.srcPayloadRef, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, newValue, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withSrcPayloadRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.srcPayloadRef, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, value, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPayloadRef(String value) {
        String newValue = Objects.requireNonNull(value, "dstPayloadRef");
        if (Objects.equals(this.dstPayloadRef, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, newValue, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDstPayloadRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dstPayloadRef, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, value, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withEncapsulatedByRef(String value) {
        String newValue = Objects.requireNonNull(value, "encapsulatedByRef");
        if (Objects.equals(this.encapsulatedByRef, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, newValue, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withEncapsulatedByRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.encapsulatedByRef, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, value, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, value, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withExtensions(CyberObservableExtension ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withExtensions(Iterable<? extends CyberObservableExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withObservableObjectKey(String value) {
        String newValue = Objects.requireNonNull(value, "observableObjectKey");
        if (this.observableObjectKey.equals(newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, newValue, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDefanged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defanged, newValue)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, newValue, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withDefanged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defanged, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, value, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, (ImmutableMap<String, Object>)newValue, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final NetworkTraffic withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, value, this.toJsonString));
    }

    public final NetworkTraffic withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return NetworkTraffic.validate(new NetworkTraffic(this.start, this.end, this.isActive, this.srcRef, this.dstRef, this.srcPort, this.dstPort, this.srcByteCount, this.dstByteCount, this.srcPackets, this.dstPackets, this.ipFix, this.srcPayloadRef, this.dstPayloadRef, this.encapsulatedByRef, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NetworkTraffic && this.equalTo((NetworkTraffic)another);
    }

    private boolean equalTo(NetworkTraffic another) {
        return Objects.equals(this.start, another.start) && Objects.equals(this.end, another.end) && Objects.equals(this.isActive, another.isActive) && Objects.equals(this.srcRef, another.srcRef) && Objects.equals(this.dstRef, another.dstRef) && Objects.equals(this.srcPort, another.srcPort) && Objects.equals(this.dstPort, another.dstPort) && Objects.equals(this.srcByteCount, another.srcByteCount) && Objects.equals(this.dstByteCount, another.dstByteCount) && Objects.equals(this.srcPackets, another.srcPackets) && Objects.equals(this.dstPackets, another.dstPackets) && this.ipFix.equals(another.ipFix) && Objects.equals(this.srcPayloadRef, another.srcPayloadRef) && Objects.equals(this.dstPayloadRef, another.dstPayloadRef) && Objects.equals(this.encapsulatedByRef, another.encapsulatedByRef) && this.id.equals(another.id) && Objects.equals(this.type, another.type) && this.extensions.equals(another.extensions) && this.observableObjectKey.equals(another.observableObjectKey) && Objects.equals(this.defanged, another.defanged) && this.customProperties.equals(another.customProperties) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.start);
        h += (h << 5) + Objects.hashCode(this.end);
        h += (h << 5) + Objects.hashCode(this.isActive);
        h += (h << 5) + Objects.hashCode(this.srcRef);
        h += (h << 5) + Objects.hashCode(this.dstRef);
        h += (h << 5) + Objects.hashCode(this.srcPort);
        h += (h << 5) + Objects.hashCode(this.dstPort);
        h += (h << 5) + Objects.hashCode(this.srcByteCount);
        h += (h << 5) + Objects.hashCode(this.dstByteCount);
        h += (h << 5) + Objects.hashCode(this.srcPackets);
        h += (h << 5) + Objects.hashCode(this.dstPackets);
        h += (h << 5) + this.ipFix.hashCode();
        h += (h << 5) + Objects.hashCode(this.srcPayloadRef);
        h += (h << 5) + Objects.hashCode(this.dstPayloadRef);
        h += (h << 5) + Objects.hashCode(this.encapsulatedByRef);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.observableObjectKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defanged);
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NetworkTraffic").omitNullValues().add("start", (Object)this.start).add("end", (Object)this.end).add("isActive", (Object)this.isActive).add("srcRef", (Object)this.srcRef).add("dstRef", (Object)this.dstRef).add("srcPort", (Object)this.srcPort).add("dstPort", (Object)this.dstPort).add("srcByteCount", (Object)this.srcByteCount).add("dstByteCount", (Object)this.dstByteCount).add("srcPackets", (Object)this.srcPackets).add("dstPackets", (Object)this.dstPackets).add("ipFix", this.ipFix).add("srcPayloadRef", (Object)this.srcPayloadRef).add("dstPayloadRef", (Object)this.dstPayloadRef).add("encapsulatedByRef", (Object)this.encapsulatedByRef).add("id", (Object)this.id).add("type", (Object)this.type).add("extensions", this.extensions).add("observableObjectKey", (Object)this.observableObjectKey).add("defanged", (Object)this.defanged).add("customProperties", this.customProperties).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).toString();
    }

    private static NetworkTraffic validate(NetworkTraffic instance) {
        instance.validateEntity();
        return instance;
    }

    public static NetworkTraffic copyOf(NetworkTrafficCoo instance) {
        if (instance instanceof NetworkTraffic) {
            return (NetworkTraffic)instance;
        }
        return NetworkTraffic.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return NetworkTraffic.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonTypeName(value="network-traffic")
    @JsonPropertyOrder(value={"type", "extensions", "start", "end", "src_ref", "dst_ref", "src_port", "dst_port", "protocols", "src_byte_count", "dst_byte_count", "src_packets", "dst_packets", "ipfix", "src_payload_ref", "dst_payload_ref", "encapsulates_refs", "encapsulated_by_ref"})
    @Generated(from="NetworkTrafficCoo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXTENSIONS = 1L;
        private long optBits;
        @Nullable
        private StixInstant start;
        @Nullable
        private StixInstant end;
        @Nullable
        private Boolean isActive;
        @Nullable
        private String srcRef;
        @Nullable
        private String dstRef;
        @Nullable
        private Integer srcPort;
        @Nullable
        private Integer dstPort;
        @Nullable
        private Long srcByteCount;
        @Nullable
        private Long dstByteCount;
        @Nullable
        private Long srcPackets;
        @Nullable
        private Long dstPackets;
        private ImmutableMap.Builder<String, Object> ipFix = ImmutableMap.builder();
        @Nullable
        private String srcPayloadRef;
        @Nullable
        private String dstPayloadRef;
        @Nullable
        private String encapsulatedByRef;
        @Nullable
        private String type;
        private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
        @Nullable
        private String observableObjectKey;
        @Nullable
        private Boolean defanged;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NetworkTrafficCoo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableObjectCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof NetworkTrafficCoo) {
                Optional<String> srcRefOptional;
                Optional<StixInstant> endOptional;
                Optional<Integer> dstPortOptional;
                Optional<Long> dstPacketsOptional;
                Optional<Long> srcPacketsOptional;
                Optional<Long> srcByteCountOptional;
                Optional<Boolean> isActiveOptional;
                Optional<Integer> srcPortOptional;
                Optional<Long> dstByteCountOptional;
                Optional<String> encapsulatedByRefOptional;
                Optional<StixInstant> startOptional;
                Optional<String> srcPayloadRefOptional;
                instance = (NetworkTrafficCoo)object;
                Optional<String> dstRefOptional = instance.getDstRef();
                if (dstRefOptional.isPresent()) {
                    this.dstRef(dstRefOptional);
                }
                if ((srcPayloadRefOptional = instance.getSrcPayloadRef()).isPresent()) {
                    this.srcPayloadRef(srcPayloadRefOptional);
                }
                if ((startOptional = instance.getStart()).isPresent()) {
                    this.start(startOptional);
                }
                if ((encapsulatedByRefOptional = instance.getEncapsulatedByRef()).isPresent()) {
                    this.encapsulatedByRef(encapsulatedByRefOptional);
                }
                if ((dstByteCountOptional = instance.getDstByteCount()).isPresent()) {
                    this.dstByteCount(dstByteCountOptional);
                }
                if ((srcPortOptional = instance.getSrcPort()).isPresent()) {
                    this.srcPort(srcPortOptional);
                }
                if ((isActiveOptional = instance.isActive()).isPresent()) {
                    this.isActive(isActiveOptional);
                }
                if ((srcByteCountOptional = instance.getSrcByteCount()).isPresent()) {
                    this.srcByteCount(srcByteCountOptional);
                }
                if ((srcPacketsOptional = instance.getSrcPackets()).isPresent()) {
                    this.srcPackets(srcPacketsOptional);
                }
                if ((dstPacketsOptional = instance.getDstPackets()).isPresent()) {
                    this.dstPackets(dstPacketsOptional);
                }
                if ((dstPortOptional = instance.getDstPort()).isPresent()) {
                    this.dstPort(dstPortOptional);
                }
                this.putAllIpFix(instance.getIpFix());
                Optional<String> dstPayloadRefOptional = instance.getDstPayloadRef();
                if (dstPayloadRefOptional.isPresent()) {
                    this.dstPayloadRef(dstPayloadRefOptional);
                }
                if ((endOptional = instance.getEnd()).isPresent()) {
                    this.end(endOptional);
                }
                if ((srcRefOptional = instance.getSrcRef()).isPresent()) {
                    this.srcRef(srcRefOptional);
                }
            }
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.hydrated(instance.getHydrated());
                this.addAllGranularMarkings(instance.getGranularMarkings());
                String toJsonStringValue = instance.toJsonString();
                if (toJsonStringValue != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof CyberObservableObjectCommonProperties) {
                instance = (CyberObservableObjectCommonProperties)object;
                this.addAllExtensions(instance.getExtensions());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.observableObjectKey(instance.getObservableObjectKey());
                Optional<Boolean> defangedOptional = instance.getDefanged();
                if (defangedOptional.isPresent()) {
                    this.defanged(defangedOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder start(StixInstant start) {
            this.start = Objects.requireNonNull(start, "start");
            return this;
        }

        @JsonProperty(value="start")
        @JsonPropertyDescription(value="Specifies the date/time the network traffic was initiated, if known.")
        @CanIgnoreReturnValue
        public final Builder start(Optional<? extends StixInstant> start) {
            this.start = start.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder end(StixInstant end) {
            this.end = Objects.requireNonNull(end, "end");
            return this;
        }

        @JsonProperty(value="end")
        @JsonPropertyDescription(value="Specifies the date/time the network traffic ended, if known.")
        @CanIgnoreReturnValue
        public final Builder end(Optional<? extends StixInstant> end) {
            this.end = end.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @JsonProperty(value="is_active")
        @JsonPropertyDescription(value="Indicates whether the network traffic is still ongoing.")
        @CanIgnoreReturnValue
        public final Builder isActive(Optional<Boolean> isActive) {
            this.isActive = isActive.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcRef(String srcRef) {
            this.srcRef = Objects.requireNonNull(srcRef, "srcRef");
            return this;
        }

        @JsonProperty(value="src_ref")
        @JsonPropertyDescription(value="Specifies the source of the network traffic, as a reference to one or more Observable Objects.")
        @CanIgnoreReturnValue
        public final Builder srcRef(Optional<String> srcRef) {
            this.srcRef = srcRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstRef(String dstRef) {
            this.dstRef = Objects.requireNonNull(dstRef, "dstRef");
            return this;
        }

        @JsonProperty(value="dst_ref")
        @JsonPropertyDescription(value="Specifies the destination of the network traffic, as a reference to one or more Observable Objects.")
        @CanIgnoreReturnValue
        public final Builder dstRef(Optional<String> dstRef) {
            this.dstRef = dstRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcPort(int srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        @JsonProperty(value="src_port")
        @JsonPropertyDescription(value="Specifies the source port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
        @CanIgnoreReturnValue
        public final Builder srcPort(Optional<Integer> srcPort) {
            this.srcPort = srcPort.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstPort(int dstPort) {
            this.dstPort = dstPort;
            return this;
        }

        @JsonProperty(value="dst_port")
        @JsonPropertyDescription(value="Specifies the destination port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
        @CanIgnoreReturnValue
        public final Builder dstPort(Optional<Integer> dstPort) {
            this.dstPort = dstPort.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcByteCount(long srcByteCount) {
            this.srcByteCount = srcByteCount;
            return this;
        }

        @JsonProperty(value="src_byte_count")
        @JsonPropertyDescription(value="Specifies the number of bytes sent from the source to the destination.")
        @CanIgnoreReturnValue
        public final Builder srcByteCount(Optional<Long> srcByteCount) {
            this.srcByteCount = srcByteCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstByteCount(long dstByteCount) {
            this.dstByteCount = dstByteCount;
            return this;
        }

        @JsonProperty(value="dst_byte_count")
        @JsonPropertyDescription(value="Specifies the number of bytes sent from the destination to the source.")
        @CanIgnoreReturnValue
        public final Builder dstByteCount(Optional<Long> dstByteCount) {
            this.dstByteCount = dstByteCount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcPackets(long srcPackets) {
            this.srcPackets = srcPackets;
            return this;
        }

        @JsonProperty(value="src_packets")
        @JsonPropertyDescription(value="Specifies the number of packets sent from the source to the destination.")
        @CanIgnoreReturnValue
        public final Builder srcPackets(Optional<Long> srcPackets) {
            this.srcPackets = srcPackets.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstPackets(long dstPackets) {
            this.dstPackets = dstPackets;
            return this;
        }

        @JsonProperty(value="dst_packets")
        @JsonPropertyDescription(value="Specifies the number of packets sent destination to the source.")
        @CanIgnoreReturnValue
        public final Builder dstPackets(Optional<Long> dstPackets) {
            this.dstPackets = dstPackets.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIpFix(String key, Object value) {
            this.ipFix.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIpFix(Map.Entry<String, ? extends Object> entry) {
            this.ipFix.put(entry);
            return this;
        }

        @JsonProperty(value="ipfix")
        @JsonPropertyDescription(value="Specifies any IP Flow Information Export [IPFIX] data for the traffic, as a dictionary.")
        @CanIgnoreReturnValue
        public final Builder ipFix(Map<String, ? extends Object> entries) {
            this.ipFix = ImmutableMap.builder();
            return this.putAllIpFix(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIpFix(Map<String, ? extends Object> entries) {
            this.ipFix.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder srcPayloadRef(String srcPayloadRef) {
            this.srcPayloadRef = Objects.requireNonNull(srcPayloadRef, "srcPayloadRef");
            return this;
        }

        @JsonProperty(value="src_payload_ref")
        @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
        @CanIgnoreReturnValue
        public final Builder srcPayloadRef(Optional<String> srcPayloadRef) {
            this.srcPayloadRef = srcPayloadRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dstPayloadRef(String dstPayloadRef) {
            this.dstPayloadRef = Objects.requireNonNull(dstPayloadRef, "dstPayloadRef");
            return this;
        }

        @JsonProperty(value="dst_payload_ref")
        @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
        @CanIgnoreReturnValue
        public final Builder dstPayloadRef(Optional<String> dstPayloadRef) {
            this.dstPayloadRef = dstPayloadRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encapsulatedByRef(String encapsulatedByRef) {
            this.encapsulatedByRef = Objects.requireNonNull(encapsulatedByRef, "encapsulatedByRef");
            return this;
        }

        @JsonProperty(value="encapsulated_by_ref")
        @JsonPropertyDescription(value="Links to another network-traffic object which encapsulates this object.")
        @CanIgnoreReturnValue
        public final Builder encapsulatedByRef(Optional<String> encapsulatedByRef) {
            this.encapsulatedByRef = encapsulatedByRef.orElse(null);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtension(@Nullable CyberObservableExtension element) {
            this.extensions.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(CyberObservableExtension ... elements) {
            this.extensions.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="extensions")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
        @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
        @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions = ImmutableSet.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defanged(boolean defanged) {
            this.defanged = defanged;
            return this;
        }

        @JsonProperty(value="defanged")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
        @CanIgnoreReturnValue
        public final Builder defanged(Optional<Boolean> defanged) {
            this.defanged = defanged.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objectMarkingRefs")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granularMarkings")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        public NetworkTraffic build() {
            return NetworkTraffic.validate(new NetworkTraffic(this));
        }

        private boolean extensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="NetworkTrafficCoo", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte extensionsBuildStage = 0;
        private ImmutableSet<CyberObservableExtension> extensions;
        private byte observableObjectKeyBuildStage = 0;
        private String observableObjectKey;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(NetworkTraffic.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableSet<CyberObservableExtension> getExtensions() {
            if (this.extensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extensionsBuildStage == 0) {
                this.extensionsBuildStage = (byte)-1;
                this.extensions = ImmutableSet.copyOf((Collection)NetworkTraffic.this.getExtensionsInitialize());
                this.extensionsBuildStage = 1;
            }
            return this.extensions;
        }

        void extensions(ImmutableSet<CyberObservableExtension> extensions) {
            this.extensions = extensions;
            this.extensionsBuildStage = 1;
        }

        String getObservableObjectKey() {
            if (this.observableObjectKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.observableObjectKeyBuildStage == 0) {
                this.observableObjectKeyBuildStage = (byte)-1;
                this.observableObjectKey = Objects.requireNonNull(NetworkTraffic.this.getObservableObjectKeyInitialize(), "observableObjectKey");
                this.observableObjectKeyBuildStage = 1;
            }
            return this.observableObjectKey;
        }

        void observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = observableObjectKey;
            this.observableObjectKeyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.extensionsBuildStage == -1) {
                attributes.add("extensions");
            }
            if (this.observableObjectKeyBuildStage == -1) {
                attributes.add("observableObjectKey");
            }
            return "Cannot build NetworkTraffic, attribute initializers form cycle " + attributes;
        }
    }
}

