/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Range;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.NetworkTraffic;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="network-traffic", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=NetworkTraffic.class)
@JsonDeserialize(builder=NetworkTraffic.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="network-traffic")
@JsonPropertyOrder(value={"type", "extensions", "start", "end", "src_ref", "dst_ref", "src_port", "dst_port", "protocols", "src_byte_count", "dst_byte_count", "src_packets", "dst_packets", "ipfix", "src_payload_ref", "dst_payload_ref", "encapsulates_refs", "encapsulated_by_ref"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface NetworkTrafficCoo
extends CyberObservableObject {
    @JsonProperty(value="start")
    @JsonPropertyDescription(value="Specifies the date/time the network traffic was initiated, if known.")
    public Optional<StixInstant> getStart();

    @JsonProperty(value="end")
    @JsonPropertyDescription(value="Specifies the date/time the network traffic ended, if known.")
    public Optional<StixInstant> getEnd();

    @JsonProperty(value="is_active")
    @JsonPropertyDescription(value="Indicates whether the network traffic is still ongoing.")
    @NotNull
    public Optional<Boolean> isActive();

    @JsonProperty(value="src_ref")
    @JsonPropertyDescription(value="Specifies the source of the network traffic, as a reference to one or more Observable Objects.")
    public Optional<String> getSrcRef();

    @JsonProperty(value="dst_ref")
    @JsonPropertyDescription(value="Specifies the destination of the network traffic, as a reference to one or more Observable Objects.")
    public Optional<String> getDstRef();

    @JsonProperty(value="src_port")
    @JsonPropertyDescription(value="Specifies the source port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public Optional<@Range(min=0L, max=65535L) Integer> getSrcPort();

    @JsonProperty(value="dst_port")
    @JsonPropertyDescription(value="Specifies the destination port used in the network traffic, as an integer. The port value MUST be in the range of 0 - 65535.")
    public Optional<@Range(min=0L, max=65535L) Integer> getDstPort();

    @JsonProperty(value="protocols")
    @JsonPropertyDescription(value="Specifies the protocols observed in the network traffic, along with their corresponding state.")
    @NotNull
    default public Set<String> getProtocols() {
        return null;
    }

    @JsonProperty(value="src_byte_count")
    @JsonPropertyDescription(value="Specifies the number of bytes sent from the source to the destination.")
    public Optional<Long> getSrcByteCount();

    @JsonProperty(value="dst_byte_count")
    @JsonPropertyDescription(value="Specifies the number of bytes sent from the destination to the source.")
    public Optional<Long> getDstByteCount();

    @JsonProperty(value="src_packets")
    @JsonPropertyDescription(value="Specifies the number of packets sent from the source to the destination.")
    public Optional<Long> getSrcPackets();

    @JsonProperty(value="dst_packets")
    @JsonPropertyDescription(value="Specifies the number of packets sent destination to the source.")
    public Optional<Long> getDstPackets();

    @JsonProperty(value="ipfix")
    @JsonPropertyDescription(value="Specifies any IP Flow Information Export [IPFIX] data for the traffic, as a dictionary.")
    public Map<String, Object> getIpFix();

    @JsonProperty(value="src_payload_ref")
    @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
    public Optional<String> getSrcPayloadRef();

    @JsonProperty(value="dst_payload_ref")
    @JsonPropertyDescription(value="Specifies the bytes sent from the source to the destination.")
    public Optional<String> getDstPayloadRef();

    @JsonProperty(value="encapsulates_refs")
    @JsonPropertyDescription(value="Links to other network-traffic objects encapsulated by a network-traffic.")
    default public Set<String> getEncapsulatesRefs() {
        return null;
    }

    @JsonProperty(value="encapsulated_by_ref")
    @JsonPropertyDescription(value="Links to another network-traffic object which encapsulates this object.")
    public Optional<String> getEncapsulatedByRef();

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getSrcRef().isPresent()) {
            identifier.append("src:").append(this.getSrcRef().get());
        }
        if (this.getSrcPort().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append("sport:").append(this.getSrcPort().get());
        }
        if (this.getDstRef().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append("dst:").append(this.getDstRef().get());
        }
        if (this.getDstPort().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append("dport:").append(this.getDstPort().get());
        }
        if (this.getProtocols() != null && !this.getProtocols().isEmpty()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append("proto:").append(String.join((CharSequence)",", this.getProtocols()));
        }
        if (identifier.length() == 0) {
            identifier.append("network-traffic:unknown");
        }
        return "network-traffic--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

