/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Process;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="process", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Process.class)
@JsonDeserialize(builder=Process.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="process")
@JsonPropertyOrder(value={"type", "extensions", "is_hidden", "pid", "name", "created", "cwd", "arguments", "command_line", "environment_variables", "opened_connection_refs", "creator_user_ref", "binary_ref", "parent_ref", "child_refs"})
@BusinessRule(ifExp="true", thenExp="getExtensions().isEmpty() == false || isHidden().isPresent() == true || getPid().isPresent() == true || getName().isPresent() == true || getCreated().isPresent() == true || getCwd().isPresent() == true || getArguments().isEmpty() == false || getCommandLine().isPresent() == true || getEnvironmentVariables().isEmpty() == false || getOpenedConnectionRefs().isEmpty() == false || getCreatorUserRef().isPresent() == true || getBinaryRef().isPresent() == true || getParentRef().isPresent() == true || getChildRefs().isEmpty() == false", errorMessage="A Process Object MUST contain at least one property (other than type) from this object (or one of its extensions).")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface ProcessCoo
extends CyberObservableObject {
    @JsonProperty(value="is_hidden")
    @JsonPropertyDescription(value="Specifies whether the process is hidden.")
    @NotNull
    public Optional<Boolean> isHidden();

    @JsonProperty(value="pid")
    @JsonPropertyDescription(value="Specifies the Process ID, or PID, of the process.")
    public Optional<Long> getPid();

    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the process.")
    public Optional<String> getName();

    @JsonProperty(value="created")
    @JsonPropertyDescription(value="Specifies the date/time at which the process was created.")
    public Optional<StixInstant> getCreated();

    @JsonProperty(value="cwd")
    @JsonPropertyDescription(value="Specifies the current working directory of the process.")
    public Optional<String> getCwd();

    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="Specifies the list of arguments used in executing the process.")
    default public List<String> getArguments() {
        return null;
    }

    @JsonProperty(value="command_line")
    @JsonPropertyDescription(value="Specifies the full command line used in executing the process, including the process name (depending on the operating system).")
    default public Optional<String> getCommandLine() {
        return Optional.empty();
    }

    @JsonProperty(value="environment_variables")
    @JsonPropertyDescription(value="Specifies the list of environment variables associated with the process as a dictionary.")
    default public Map<String, String> getEnvironmentVariables() {
        return null;
    }

    @JsonProperty(value="opened_connection_refs")
    @JsonPropertyDescription(value="Specifies the list of network connections opened by the process, as a reference to one or more Network Traffic Objects.")
    default public Set<String> getOpenedConnectionRefs() {
        return null;
    }

    @JsonProperty(value="creator_user_ref")
    @JsonPropertyDescription(value="Specifies the user that created the process, as a reference to a User Account Object.")
    default public Optional<String> getCreatorUserRef() {
        return Optional.empty();
    }

    @JsonProperty(value="binary_ref")
    @JsonPropertyDescription(value="Specifies the executable binary that was executed as the process, as a reference to a File Object.")
    default public Optional<String> getBinaryRef() {
        return Optional.empty();
    }

    @JsonProperty(value="parent_ref")
    @JsonPropertyDescription(value="Specifies the other process that spawned (i.e. is the parent of) this one, as represented by a Process Object.")
    default public Optional<String> getParentRef() {
        return Optional.empty();
    }

    @JsonProperty(value="child_refs")
    @JsonPropertyDescription(value="Specifies the other processes that were spawned by (i.e. children of) this process, as a reference to one or more other Process Objects.")
    default public Set<String> getChildRefs() {
        return null;
    }

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getPid().isPresent()) {
            identifier.append("pid:").append(this.getPid().get());
        }
        if (this.getName().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append(this.getName().get());
        } else if (this.getCommandLine().isPresent()) {
            if (identifier.length() > 0) {
                identifier.append(":");
            }
            identifier.append(this.getCommandLine().get());
        }
        if (identifier.length() == 0) {
            identifier.append("process:unknown");
        }
        return "process--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

