/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.Software;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="software", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=Software.class)
@JsonDeserialize(builder=Software.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="software")
@JsonPropertyOrder(value={"type", "extensions", "cpe", "languages", "vendor", "version"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface SoftwareCoo
extends CyberObservableObject {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Specifies the name of the software.")
    @NotNull
    public String getName();

    @JsonProperty(value="cpe")
    @JsonPropertyDescription(value="Specifies the Common Platform Enumeration (CPE) entry for the software, if available.")
    public Optional<String> getCpe();

    @JsonProperty(value="languages")
    @JsonPropertyDescription(value="Specifies the languages supported by the software.")
    default public Set<@Pattern(regexp="^[a-z]{3}$") String> getLanguages() {
        return null;
    }

    @JsonProperty(value="vendor")
    @JsonPropertyDescription(value="Specifies the name of the vendor of the software.")
    public Optional<String> getVendor();

    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the version of the software.")
    public Optional<String> getVersion();

    @Override
    @Value.Derived
    default public String getId() {
        return "software--" + UUID.nameUUIDFromBytes(this.getName().getBytes(StandardCharsets.UTF_8));
    }
}

