/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.objects.UserAccountCoo;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="user-account")
@Generated(from="UserAccountCoo", generator="Immutables")
@Immutable
public final class UserAccount
implements UserAccountCoo {
    private final String userId;
    @Nullable
    private final String accountLogin;
    @Nullable
    private final String accountType;
    @Nullable
    private final String displayName;
    @Nullable
    private final Boolean isServiceAccount;
    @Nullable
    private final Boolean isPrivileged;
    @Nullable
    private final Boolean isCanEscalatePrivs;
    @Nullable
    private final Boolean isDisabled;
    @Nullable
    private final StixInstant accountCreated;
    @Nullable
    private final StixInstant accountExpires;
    @Nullable
    private final StixInstant passwordLastChanged;
    @Nullable
    private final StixInstant accountFirstLogin;
    @Nullable
    private final StixInstant accountLastLogin;
    private final String id;
    private final String type;
    private final ImmutableSet<CyberObservableExtension> extensions;
    private final String observableObjectKey;
    @Nullable
    private final Boolean defanged;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final boolean hydrated;
    private final String toJsonString;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 1L;

    private UserAccount(Builder builder) {
        this.userId = builder.userId;
        this.accountLogin = builder.accountLogin;
        this.accountType = builder.accountType;
        this.displayName = builder.displayName;
        this.isServiceAccount = builder.isServiceAccount;
        this.isPrivileged = builder.isPrivileged;
        this.isCanEscalatePrivs = builder.isCanEscalatePrivs;
        this.isDisabled = builder.isDisabled;
        this.accountCreated = builder.accountCreated;
        this.accountExpires = builder.accountExpires;
        this.passwordLastChanged = builder.passwordLastChanged;
        this.accountFirstLogin = builder.accountFirstLogin;
        this.accountLastLogin = builder.accountLastLogin;
        this.type = builder.type;
        this.defanged = builder.defanged;
        this.customProperties = builder.customProperties.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        if (builder.extensionsIsSet()) {
            this.initShim.extensions((ImmutableSet<CyberObservableExtension>)builder.extensions.build());
        }
        if (builder.observableObjectKey != null) {
            this.initShim.observableObjectKey(builder.observableObjectKey);
        }
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private UserAccount(String userId, @Nullable String accountLogin, @Nullable String accountType, @Nullable String displayName, @Nullable Boolean isServiceAccount, @Nullable Boolean isPrivileged, @Nullable Boolean isCanEscalatePrivs, @Nullable Boolean isDisabled, @Nullable StixInstant accountCreated, @Nullable StixInstant accountExpires, @Nullable StixInstant passwordLastChanged, @Nullable StixInstant accountFirstLogin, @Nullable StixInstant accountLastLogin, String type, ImmutableSet<CyberObservableExtension> extensions, String observableObjectKey, @Nullable Boolean defanged, ImmutableMap<String, Object> customProperties, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, boolean hydrated, String toJsonString) {
        this.userId = userId;
        this.accountLogin = accountLogin;
        this.accountType = accountType;
        this.displayName = displayName;
        this.isServiceAccount = isServiceAccount;
        this.isPrivileged = isPrivileged;
        this.isCanEscalatePrivs = isCanEscalatePrivs;
        this.isDisabled = isDisabled;
        this.accountCreated = accountCreated;
        this.accountExpires = accountExpires;
        this.passwordLastChanged = passwordLastChanged;
        this.accountFirstLogin = accountFirstLogin;
        this.accountLastLogin = accountLastLogin;
        this.type = type;
        this.initShim.extensions(extensions);
        this.initShim.observableObjectKey(observableObjectKey);
        this.defanged = defanged;
        this.customProperties = customProperties;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private String getIdInitialize() {
        return UserAccountCoo.super.getId();
    }

    private Set<CyberObservableExtension> getExtensionsInitialize() {
        return UserAccountCoo.super.getExtensions();
    }

    private String getObservableObjectKeyInitialize() {
        return UserAccountCoo.super.getObservableObjectKey();
    }

    @Override
    @JsonProperty(value="user_id")
    @JsonPropertyDescription(value="Specifies the identifier of the account.")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="account_login")
    @JsonPropertyDescription(value="Specifies the account login string, used in cases where the user_id property specifies something other than what a user would type when they login.")
    public Optional<String> getAccountLogin() {
        return Optional.ofNullable(this.accountLogin);
    }

    @Override
    @JsonProperty(value="account_type")
    @JsonPropertyDescription(value="Specifies the type of the account. This is an open vocabulary and values SHOULD come from the account-type-ov vocabulary.")
    public Optional<String> getAccountType() {
        return Optional.ofNullable(this.accountType);
    }

    @Override
    @JsonProperty(value="display_name")
    @JsonPropertyDescription(value="Specifies the display name of the account, to be shown in user interfaces, if applicable.")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    @Override
    @JsonProperty(value="is_service_account")
    @JsonPropertyDescription(value="Indicates that the account is associated with a network service or system process (daemon), not a specific individual.")
    public Optional<Boolean> isServiceAccount() {
        return Optional.ofNullable(this.isServiceAccount);
    }

    @Override
    @JsonProperty(value="is_privileged")
    @JsonPropertyDescription(value="Specifies that the account has elevated privileges (i.e., in the case of root on Unix or the Windows Administrator account).")
    public Optional<Boolean> isPrivileged() {
        return Optional.ofNullable(this.isPrivileged);
    }

    @Override
    @JsonProperty(value="can_escalate_privs")
    @JsonPropertyDescription(value="Specifies that the account has the ability to escalate privileges (i.e., in the case of sudo on Unix or a Windows Domain Admin account).")
    public Optional<Boolean> isCanEscalatePrivs() {
        return Optional.ofNullable(this.isCanEscalatePrivs);
    }

    @Override
    @JsonProperty(value="is_disabled")
    @JsonPropertyDescription(value="Specifies if the account is disabled.")
    public Optional<Boolean> isDisabled() {
        return Optional.ofNullable(this.isDisabled);
    }

    @Override
    @JsonProperty(value="account_created")
    @JsonPropertyDescription(value="Specifies when the account was created.")
    public Optional<StixInstant> getAccountCreated() {
        return Optional.ofNullable(this.accountCreated);
    }

    @Override
    @JsonProperty(value="account_expires")
    @JsonPropertyDescription(value="Specifies the expiration date of the account.")
    public Optional<StixInstant> getAccountExpires() {
        return Optional.ofNullable(this.accountExpires);
    }

    @Override
    @JsonProperty(value="password_last_changed")
    @JsonPropertyDescription(value="Specifies when the account password was last changed.")
    public Optional<StixInstant> getPasswordLastChanged() {
        return Optional.ofNullable(this.passwordLastChanged);
    }

    @Override
    @JsonProperty(value="account_first_login")
    @JsonPropertyDescription(value="Specifies when the account was first accessed.")
    public Optional<StixInstant> getAccountFirstLogin() {
        return Optional.ofNullable(this.accountFirstLogin);
    }

    @Override
    @JsonProperty(value="account_last_login")
    @JsonPropertyDescription(value="Specifies when the account was last accessed.")
    public Optional<StixInstant> getAccountLastLogin() {
        return Optional.ofNullable(this.accountLastLogin);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    public ImmutableSet<CyberObservableExtension> getExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExtensions() : this.extensions;
    }

    @Override
    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    public String getObservableObjectKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObservableObjectKey() : this.observableObjectKey;
    }

    @Override
    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged() {
        return Optional.ofNullable(this.defanged);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="objectMarkingRefs")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granularMarkings")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="hydrated")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    public String toJsonString() {
        return this.toJsonString;
    }

    public final UserAccount withUserId(String value) {
        if (Objects.equals(this.userId, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(value, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountLogin(String value) {
        String newValue = Objects.requireNonNull(value, "accountLogin");
        if (Objects.equals(this.accountLogin, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, newValue, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountLogin(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accountLogin, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, value, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountType(String value) {
        String newValue = Objects.requireNonNull(value, "accountType");
        if (Objects.equals(this.accountType, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, newValue, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accountType, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, value, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (Objects.equals(this.displayName, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, newValue, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withDisplayName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.displayName, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, value, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsServiceAccount(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isServiceAccount, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, newValue, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsServiceAccount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isServiceAccount, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, value, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsPrivileged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isPrivileged, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, newValue, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsPrivileged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isPrivileged, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, value, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsCanEscalatePrivs(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isCanEscalatePrivs, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, newValue, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsCanEscalatePrivs(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isCanEscalatePrivs, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, value, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsDisabled(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isDisabled, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, newValue, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withIsDisabled(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isDisabled, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, value, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountCreated(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "accountCreated");
        if (this.accountCreated == newValue) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, newValue, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountCreated(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.accountCreated == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, value, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountExpires(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "accountExpires");
        if (this.accountExpires == newValue) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, newValue, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountExpires(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.accountExpires == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, value, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withPasswordLastChanged(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "passwordLastChanged");
        if (this.passwordLastChanged == newValue) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, newValue, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withPasswordLastChanged(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.passwordLastChanged == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, value, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountFirstLogin(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "accountFirstLogin");
        if (this.accountFirstLogin == newValue) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, newValue, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountFirstLogin(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.accountFirstLogin == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, value, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountLastLogin(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "accountLastLogin");
        if (this.accountLastLogin == newValue) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, newValue, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withAccountLastLogin(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.accountLastLogin == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, value, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, value, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withExtensions(CyberObservableExtension ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withExtensions(Iterable<? extends CyberObservableExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withObservableObjectKey(String value) {
        String newValue = Objects.requireNonNull(value, "observableObjectKey");
        if (this.observableObjectKey.equals(newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, newValue, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withDefanged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defanged, newValue)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, newValue, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withDefanged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defanged, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, value, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, (ImmutableMap<String, Object>)newValue, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final UserAccount withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final UserAccount withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final UserAccount withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, value, this.toJsonString));
    }

    public final UserAccount withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return UserAccount.validate(new UserAccount(this.userId, this.accountLogin, this.accountType, this.displayName, this.isServiceAccount, this.isPrivileged, this.isCanEscalatePrivs, this.isDisabled, this.accountCreated, this.accountExpires, this.passwordLastChanged, this.accountFirstLogin, this.accountLastLogin, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UserAccount && this.equalTo((UserAccount)another);
    }

    private boolean equalTo(UserAccount another) {
        return Objects.equals(this.userId, another.userId) && Objects.equals(this.accountLogin, another.accountLogin) && Objects.equals(this.accountType, another.accountType) && Objects.equals(this.displayName, another.displayName) && Objects.equals(this.isServiceAccount, another.isServiceAccount) && Objects.equals(this.isPrivileged, another.isPrivileged) && Objects.equals(this.isCanEscalatePrivs, another.isCanEscalatePrivs) && Objects.equals(this.isDisabled, another.isDisabled) && Objects.equals(this.accountCreated, another.accountCreated) && Objects.equals(this.accountExpires, another.accountExpires) && Objects.equals(this.passwordLastChanged, another.passwordLastChanged) && Objects.equals(this.accountFirstLogin, another.accountFirstLogin) && Objects.equals(this.accountLastLogin, another.accountLastLogin) && this.id.equals(another.id) && Objects.equals(this.type, another.type) && this.extensions.equals(another.extensions) && this.observableObjectKey.equals(another.observableObjectKey) && Objects.equals(this.defanged, another.defanged) && this.customProperties.equals(another.customProperties) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.accountLogin);
        h += (h << 5) + Objects.hashCode(this.accountType);
        h += (h << 5) + Objects.hashCode(this.displayName);
        h += (h << 5) + Objects.hashCode(this.isServiceAccount);
        h += (h << 5) + Objects.hashCode(this.isPrivileged);
        h += (h << 5) + Objects.hashCode(this.isCanEscalatePrivs);
        h += (h << 5) + Objects.hashCode(this.isDisabled);
        h += (h << 5) + Objects.hashCode(this.accountCreated);
        h += (h << 5) + Objects.hashCode(this.accountExpires);
        h += (h << 5) + Objects.hashCode(this.passwordLastChanged);
        h += (h << 5) + Objects.hashCode(this.accountFirstLogin);
        h += (h << 5) + Objects.hashCode(this.accountLastLogin);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.observableObjectKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defanged);
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UserAccount").omitNullValues().add("userId", (Object)this.userId).add("accountLogin", (Object)this.accountLogin).add("accountType", (Object)this.accountType).add("displayName", (Object)this.displayName).add("isServiceAccount", (Object)this.isServiceAccount).add("isPrivileged", (Object)this.isPrivileged).add("isCanEscalatePrivs", (Object)this.isCanEscalatePrivs).add("isDisabled", (Object)this.isDisabled).add("accountCreated", (Object)this.accountCreated).add("accountExpires", (Object)this.accountExpires).add("passwordLastChanged", (Object)this.passwordLastChanged).add("accountFirstLogin", (Object)this.accountFirstLogin).add("accountLastLogin", (Object)this.accountLastLogin).add("id", (Object)this.id).add("type", (Object)this.type).add("extensions", this.extensions).add("observableObjectKey", (Object)this.observableObjectKey).add("defanged", (Object)this.defanged).add("customProperties", this.customProperties).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).toString();
    }

    private static UserAccount validate(UserAccount instance) {
        instance.validateEntity();
        return instance;
    }

    public static UserAccount copyOf(UserAccountCoo instance) {
        if (instance instanceof UserAccount) {
            return (UserAccount)instance;
        }
        return UserAccount.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return UserAccount.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonTypeName(value="user-account")
    @JsonPropertyOrder(value={"type", "extensions", "user_id", "account_login", "account_type", "display_name", "is_service_account", "is_privileged", "can_escalate_privs", "is_disabled", "account_created", "account_expires", "password_last_changed", "account_first_login", "account_last_login"})
    @Generated(from="UserAccountCoo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXTENSIONS = 1L;
        private long optBits;
        @Nullable
        private String userId;
        @Nullable
        private String accountLogin;
        @Nullable
        private String accountType;
        @Nullable
        private String displayName;
        @Nullable
        private Boolean isServiceAccount;
        @Nullable
        private Boolean isPrivileged;
        @Nullable
        private Boolean isCanEscalatePrivs;
        @Nullable
        private Boolean isDisabled;
        @Nullable
        private StixInstant accountCreated;
        @Nullable
        private StixInstant accountExpires;
        @Nullable
        private StixInstant passwordLastChanged;
        @Nullable
        private StixInstant accountFirstLogin;
        @Nullable
        private StixInstant accountLastLogin;
        @Nullable
        private String type;
        private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
        @Nullable
        private String observableObjectKey;
        @Nullable
        private Boolean defanged;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UserAccountCoo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableObjectCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.hydrated(instance.getHydrated());
                this.addAllGranularMarkings(instance.getGranularMarkings());
                String toJsonStringValue = instance.toJsonString();
                if (toJsonStringValue != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof UserAccountCoo) {
                Optional<Boolean> isServiceAccountOptional;
                Optional<Boolean> isDisabledOptional;
                Optional<StixInstant> accountFirstLoginOptional;
                Optional<StixInstant> accountLastLoginOptional;
                Optional<StixInstant> passwordLastChangedOptional;
                Optional<Boolean> isPrivilegedOptional;
                Optional<Boolean> isCanEscalatePrivsOptional;
                String userIdValue;
                Optional<String> accountTypeOptional;
                Optional<StixInstant> accountExpiresOptional;
                Optional<String> displayNameOptional;
                Optional<String> accountLoginOptional;
                instance = (UserAccountCoo)object;
                Optional<StixInstant> accountCreatedOptional = instance.getAccountCreated();
                if (accountCreatedOptional.isPresent()) {
                    this.accountCreated(accountCreatedOptional);
                }
                if ((accountLoginOptional = instance.getAccountLogin()).isPresent()) {
                    this.accountLogin(accountLoginOptional);
                }
                if ((displayNameOptional = instance.getDisplayName()).isPresent()) {
                    this.displayName(displayNameOptional);
                }
                if ((accountExpiresOptional = instance.getAccountExpires()).isPresent()) {
                    this.accountExpires(accountExpiresOptional);
                }
                if ((accountTypeOptional = instance.getAccountType()).isPresent()) {
                    this.accountType(accountTypeOptional);
                }
                if ((userIdValue = instance.getUserId()) != null) {
                    this.userId(userIdValue);
                }
                if ((isCanEscalatePrivsOptional = instance.isCanEscalatePrivs()).isPresent()) {
                    this.isCanEscalatePrivs(isCanEscalatePrivsOptional);
                }
                if ((isPrivilegedOptional = instance.isPrivileged()).isPresent()) {
                    this.isPrivileged(isPrivilegedOptional);
                }
                if ((passwordLastChangedOptional = instance.getPasswordLastChanged()).isPresent()) {
                    this.passwordLastChanged(passwordLastChangedOptional);
                }
                if ((accountLastLoginOptional = instance.getAccountLastLogin()).isPresent()) {
                    this.accountLastLogin(accountLastLoginOptional);
                }
                if ((accountFirstLoginOptional = instance.getAccountFirstLogin()).isPresent()) {
                    this.accountFirstLogin(accountFirstLoginOptional);
                }
                if ((isDisabledOptional = instance.isDisabled()).isPresent()) {
                    this.isDisabled(isDisabledOptional);
                }
                if ((isServiceAccountOptional = instance.isServiceAccount()).isPresent()) {
                    this.isServiceAccount(isServiceAccountOptional);
                }
            }
            if (object instanceof CyberObservableObjectCommonProperties) {
                instance = (CyberObservableObjectCommonProperties)object;
                this.addAllExtensions(instance.getExtensions());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.observableObjectKey(instance.getObservableObjectKey());
                Optional<Boolean> defangedOptional = instance.getDefanged();
                if (defangedOptional.isPresent()) {
                    this.defanged(defangedOptional);
                }
            }
        }

        @JsonProperty(value="user_id")
        @JsonPropertyDescription(value="Specifies the identifier of the account.")
        @CanIgnoreReturnValue
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountLogin(String accountLogin) {
            this.accountLogin = Objects.requireNonNull(accountLogin, "accountLogin");
            return this;
        }

        @JsonProperty(value="account_login")
        @JsonPropertyDescription(value="Specifies the account login string, used in cases where the user_id property specifies something other than what a user would type when they login.")
        @CanIgnoreReturnValue
        public final Builder accountLogin(Optional<String> accountLogin) {
            this.accountLogin = accountLogin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountType(String accountType) {
            this.accountType = Objects.requireNonNull(accountType, "accountType");
            return this;
        }

        @JsonProperty(value="account_type")
        @JsonPropertyDescription(value="Specifies the type of the account. This is an open vocabulary and values SHOULD come from the account-type-ov vocabulary.")
        @CanIgnoreReturnValue
        public final Builder accountType(Optional<String> accountType) {
            this.accountType = accountType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            return this;
        }

        @JsonProperty(value="display_name")
        @JsonPropertyDescription(value="Specifies the display name of the account, to be shown in user interfaces, if applicable.")
        @CanIgnoreReturnValue
        public final Builder displayName(Optional<String> displayName) {
            this.displayName = displayName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isServiceAccount(boolean isServiceAccount) {
            this.isServiceAccount = isServiceAccount;
            return this;
        }

        @JsonProperty(value="is_service_account")
        @JsonPropertyDescription(value="Indicates that the account is associated with a network service or system process (daemon), not a specific individual.")
        @CanIgnoreReturnValue
        public final Builder isServiceAccount(Optional<Boolean> isServiceAccount) {
            this.isServiceAccount = isServiceAccount.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isPrivileged(boolean isPrivileged) {
            this.isPrivileged = isPrivileged;
            return this;
        }

        @JsonProperty(value="is_privileged")
        @JsonPropertyDescription(value="Specifies that the account has elevated privileges (i.e., in the case of root on Unix or the Windows Administrator account).")
        @CanIgnoreReturnValue
        public final Builder isPrivileged(Optional<Boolean> isPrivileged) {
            this.isPrivileged = isPrivileged.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isCanEscalatePrivs(boolean isCanEscalatePrivs) {
            this.isCanEscalatePrivs = isCanEscalatePrivs;
            return this;
        }

        @JsonProperty(value="can_escalate_privs")
        @JsonPropertyDescription(value="Specifies that the account has the ability to escalate privileges (i.e., in the case of sudo on Unix or a Windows Domain Admin account).")
        @CanIgnoreReturnValue
        public final Builder isCanEscalatePrivs(Optional<Boolean> isCanEscalatePrivs) {
            this.isCanEscalatePrivs = isCanEscalatePrivs.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDisabled(boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        @JsonProperty(value="is_disabled")
        @JsonPropertyDescription(value="Specifies if the account is disabled.")
        @CanIgnoreReturnValue
        public final Builder isDisabled(Optional<Boolean> isDisabled) {
            this.isDisabled = isDisabled.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountCreated(StixInstant accountCreated) {
            this.accountCreated = Objects.requireNonNull(accountCreated, "accountCreated");
            return this;
        }

        @JsonProperty(value="account_created")
        @JsonPropertyDescription(value="Specifies when the account was created.")
        @CanIgnoreReturnValue
        public final Builder accountCreated(Optional<? extends StixInstant> accountCreated) {
            this.accountCreated = accountCreated.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountExpires(StixInstant accountExpires) {
            this.accountExpires = Objects.requireNonNull(accountExpires, "accountExpires");
            return this;
        }

        @JsonProperty(value="account_expires")
        @JsonPropertyDescription(value="Specifies the expiration date of the account.")
        @CanIgnoreReturnValue
        public final Builder accountExpires(Optional<? extends StixInstant> accountExpires) {
            this.accountExpires = accountExpires.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordLastChanged(StixInstant passwordLastChanged) {
            this.passwordLastChanged = Objects.requireNonNull(passwordLastChanged, "passwordLastChanged");
            return this;
        }

        @JsonProperty(value="password_last_changed")
        @JsonPropertyDescription(value="Specifies when the account password was last changed.")
        @CanIgnoreReturnValue
        public final Builder passwordLastChanged(Optional<? extends StixInstant> passwordLastChanged) {
            this.passwordLastChanged = passwordLastChanged.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountFirstLogin(StixInstant accountFirstLogin) {
            this.accountFirstLogin = Objects.requireNonNull(accountFirstLogin, "accountFirstLogin");
            return this;
        }

        @JsonProperty(value="account_first_login")
        @JsonPropertyDescription(value="Specifies when the account was first accessed.")
        @CanIgnoreReturnValue
        public final Builder accountFirstLogin(Optional<? extends StixInstant> accountFirstLogin) {
            this.accountFirstLogin = accountFirstLogin.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accountLastLogin(StixInstant accountLastLogin) {
            this.accountLastLogin = Objects.requireNonNull(accountLastLogin, "accountLastLogin");
            return this;
        }

        @JsonProperty(value="account_last_login")
        @JsonPropertyDescription(value="Specifies when the account was last accessed.")
        @CanIgnoreReturnValue
        public final Builder accountLastLogin(Optional<? extends StixInstant> accountLastLogin) {
            this.accountLastLogin = accountLastLogin.orElse(null);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtension(@Nullable CyberObservableExtension element) {
            this.extensions.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(CyberObservableExtension ... elements) {
            this.extensions.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="extensions")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
        @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
        @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions = ImmutableSet.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defanged(boolean defanged) {
            this.defanged = defanged;
            return this;
        }

        @JsonProperty(value="defanged")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
        @CanIgnoreReturnValue
        public final Builder defanged(Optional<Boolean> defanged) {
            this.defanged = defanged.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objectMarkingRefs")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granularMarkings")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        public UserAccount build() {
            return UserAccount.validate(new UserAccount(this));
        }

        private boolean extensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="UserAccountCoo", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte extensionsBuildStage = 0;
        private ImmutableSet<CyberObservableExtension> extensions;
        private byte observableObjectKeyBuildStage = 0;
        private String observableObjectKey;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(UserAccount.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableSet<CyberObservableExtension> getExtensions() {
            if (this.extensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extensionsBuildStage == 0) {
                this.extensionsBuildStage = (byte)-1;
                this.extensions = ImmutableSet.copyOf((Collection)UserAccount.this.getExtensionsInitialize());
                this.extensionsBuildStage = 1;
            }
            return this.extensions;
        }

        void extensions(ImmutableSet<CyberObservableExtension> extensions) {
            this.extensions = extensions;
            this.extensionsBuildStage = 1;
        }

        String getObservableObjectKey() {
            if (this.observableObjectKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.observableObjectKeyBuildStage == 0) {
                this.observableObjectKeyBuildStage = (byte)-1;
                this.observableObjectKey = Objects.requireNonNull(UserAccount.this.getObservableObjectKeyInitialize(), "observableObjectKey");
                this.observableObjectKeyBuildStage = 1;
            }
            return this.observableObjectKey;
        }

        void observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = observableObjectKey;
            this.observableObjectKeyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.extensionsBuildStage == -1) {
                attributes.add("extensions");
            }
            if (this.observableObjectKeyBuildStage == -1) {
                attributes.add("observableObjectKey");
            }
            return "Cannot build UserAccount, attribute initializers form cycle " + attributes;
        }
    }
}

