/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.UserAccount;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.vocab.Vocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.AccountTypes;

@DefaultTypeValue(value="user-account", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=UserAccount.class)
@JsonDeserialize(builder=UserAccount.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonTypeName(value="user-account")
@JsonPropertyOrder(value={"type", "extensions", "user_id", "account_login", "account_type", "display_name", "is_service_account", "is_privileged", "can_escalate_privs", "is_disabled", "account_created", "account_expires", "password_last_changed", "account_first_login", "account_last_login"})
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface UserAccountCoo
extends CyberObservableObject {
    @JsonProperty(value="user_id")
    @JsonPropertyDescription(value="Specifies the identifier of the account.")
    @NotNull
    public String getUserId();

    @JsonProperty(value="account_login")
    @JsonPropertyDescription(value="Specifies the account login string, used in cases where the user_id property specifies something other than what a user would type when they login.")
    public Optional<String> getAccountLogin();

    @JsonProperty(value="account_type")
    @JsonPropertyDescription(value="Specifies the type of the account. This is an open vocabulary and values SHOULD come from the account-type-ov vocabulary.")
    public Optional<@Vocab(value=AccountTypes.class) String> getAccountType();

    @JsonProperty(value="display_name")
    @JsonPropertyDescription(value="Specifies the display name of the account, to be shown in user interfaces, if applicable.")
    public Optional<String> getDisplayName();

    @JsonProperty(value="is_service_account")
    @JsonPropertyDescription(value="Indicates that the account is associated with a network service or system process (daemon), not a specific individual.")
    @NotNull
    public Optional<Boolean> isServiceAccount();

    @JsonProperty(value="is_privileged")
    @JsonPropertyDescription(value="Specifies that the account has elevated privileges (i.e., in the case of root on Unix or the Windows Administrator account).")
    @NotNull
    public Optional<Boolean> isPrivileged();

    @JsonProperty(value="can_escalate_privs")
    @JsonPropertyDescription(value="Specifies that the account has the ability to escalate privileges (i.e., in the case of sudo on Unix or a Windows Domain Admin account).")
    @NotNull
    public Optional<Boolean> isCanEscalatePrivs();

    @JsonProperty(value="is_disabled")
    @JsonPropertyDescription(value="Specifies if the account is disabled.")
    @NotNull
    public Optional<Boolean> isDisabled();

    @JsonProperty(value="account_created")
    @JsonPropertyDescription(value="Specifies when the account was created.")
    public Optional<StixInstant> getAccountCreated();

    @JsonProperty(value="account_expires")
    @JsonPropertyDescription(value="Specifies the expiration date of the account.")
    public Optional<StixInstant> getAccountExpires();

    @JsonProperty(value="password_last_changed")
    @JsonPropertyDescription(value="Specifies when the account password was last changed.")
    public Optional<StixInstant> getPasswordLastChanged();

    @JsonProperty(value="account_first_login")
    @JsonPropertyDescription(value="Specifies when the account was first accessed.")
    public Optional<StixInstant> getAccountFirstLogin();

    @JsonProperty(value="account_last_login")
    @JsonPropertyDescription(value="Specifies when the account was last accessed.")
    public Optional<StixInstant> getAccountLastLogin();

    @Override
    @Value.Derived
    default public String getId() {
        return "user-account--" + UUID.nameUUIDFromBytes(this.getUserId().getBytes(StandardCharsets.UTF_8));
    }
}

