/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.WindowsRegistryKey;
import security.whisper.javastix.coo.types.WindowsRegistryValueObj;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;

@DefaultTypeValue(value="windows-registry-key", groups={DefaultValuesProcessor.class})
@JsonSerialize(as=WindowsRegistryKey.class)
@JsonDeserialize(builder=WindowsRegistryKey.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"type", "key", "values", "modified", "creator_user_ref", "number_of_subkeys", "extensions"})
@JsonTypeName(value="windows-registry-key")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface WindowsRegistryKeyCoo
extends CyberObservableObject {
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Specifies the full registry key including the hive.")
    @Pattern(regexp="^HKEY_LOCAL_MACHINE|hkey_local_machine|HKEY_CURRENT_USER|hkey_current_user|HKEY_CLASSES_ROOT|hkey_classes_root|HKEY_CURRENT_CONFIG|hkey_current_config|HKEY_PERFORMANCE_DATA|hkey_performance_data|HKEY_USERS|hkey_users|HKEY_DYN_DATA")
    @NotNull
    public @Pattern(regexp="^HKEY_LOCAL_MACHINE|hkey_local_machine|HKEY_CURRENT_USER|hkey_current_user|HKEY_CLASSES_ROOT|hkey_classes_root|HKEY_CURRENT_CONFIG|hkey_current_config|HKEY_PERFORMANCE_DATA|hkey_performance_data|HKEY_USERS|hkey_users|HKEY_DYN_DATA") @NotNull String getKey();

    @JsonProperty(value="values")
    @JsonPropertyDescription(value="Specifies the values found under the registry key.")
    default public Set<WindowsRegistryValueObj> getValues() {
        return null;
    }

    @JsonProperty(value="modified")
    @JsonPropertyDescription(value="Specifies the last date/time that the registry key was modified.")
    default public Optional<StixInstant> getModified() {
        return Optional.empty();
    }

    @JsonProperty(value="creator_user_ref")
    @JsonPropertyDescription(value="Specifies a reference to a user account, represented as a User Account Object, that created the registry key.")
    default public Optional<String> getCreatorUserRef() {
        return Optional.empty();
    }

    @JsonProperty(value="number_of_subkeys")
    @JsonPropertyDescription(value="Specifies the number of subkeys contained under the registry key.")
    default public Optional<Long> getNumberOfSubkeys() {
        return Optional.empty();
    }

    @Override
    @Value.Derived
    default public String getId() {
        return "windows-registry-key--" + UUID.nameUUIDFromBytes(this.getKey().getBytes(StandardCharsets.UTF_8));
    }
}

