/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.bundle.BundleableObject;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObjectCommonProperties;
import security.whisper.javastix.coo.extension.CyberObservableExtension;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldDeserializer;
import security.whisper.javastix.coo.json.extension.CyberObservableExtensionsFieldSerializer;
import security.whisper.javastix.coo.objects.X509CertificateCoo;
import security.whisper.javastix.coo.types.X509v3ExtensionsObj;
import security.whisper.javastix.datamarkings.GranularMarkingDm;
import security.whisper.javastix.datamarkings.MarkingDefinitionDm;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonTypeName(value="x509-certificate")
@Generated(from="X509CertificateCoo", generator="Immutables")
@Immutable
public final class X509Certificate
implements X509CertificateCoo {
    @Nullable
    private final Boolean isSelfSigned;
    private final ImmutableMap<String, String> hashes;
    @Nullable
    private final String version;
    @Nullable
    private final String serialNumber;
    @Nullable
    private final String signatureAlgorithm;
    @Nullable
    private final String issuer;
    @Nullable
    private final StixInstant validityNotBefore;
    @Nullable
    private final StixInstant validityNotAfter;
    @Nullable
    private final String subject;
    @Nullable
    private final String subjectPublicKeyAlgorithm;
    @Nullable
    private final String subjectPublicKeyModulus;
    @Nullable
    private final Long subjectPublicKeyExponent;
    @Nullable
    private final X509v3ExtensionsObj x509V3Extensions;
    private final String id;
    private final String type;
    private final ImmutableSet<CyberObservableExtension> extensions;
    private final String observableObjectKey;
    @Nullable
    private final Boolean defanged;
    private final ImmutableMap<String, Object> customProperties;
    private final ImmutableSet<MarkingDefinitionDm> objectMarkingRefs;
    private final ImmutableSet<GranularMarkingDm> granularMarkings;
    private final boolean hydrated;
    private final String toJsonString;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 1L;

    private X509Certificate(Builder builder) {
        this.isSelfSigned = builder.isSelfSigned;
        this.hashes = builder.hashes.build();
        this.version = builder.version;
        this.serialNumber = builder.serialNumber;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.issuer = builder.issuer;
        this.validityNotBefore = builder.validityNotBefore;
        this.validityNotAfter = builder.validityNotAfter;
        this.subject = builder.subject;
        this.subjectPublicKeyAlgorithm = builder.subjectPublicKeyAlgorithm;
        this.subjectPublicKeyModulus = builder.subjectPublicKeyModulus;
        this.subjectPublicKeyExponent = builder.subjectPublicKeyExponent;
        this.x509V3Extensions = builder.x509V3Extensions;
        this.type = builder.type;
        this.defanged = builder.defanged;
        this.customProperties = builder.customProperties.build();
        this.objectMarkingRefs = builder.objectMarkingRefs.build();
        this.granularMarkings = builder.granularMarkings.build();
        this.hydrated = builder.hydrated;
        this.toJsonString = builder.toJsonString;
        if (builder.extensionsIsSet()) {
            this.initShim.extensions((ImmutableSet<CyberObservableExtension>)builder.extensions.build());
        }
        if (builder.observableObjectKey != null) {
            this.initShim.observableObjectKey(builder.observableObjectKey);
        }
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private X509Certificate(@Nullable Boolean isSelfSigned, ImmutableMap<String, String> hashes, @Nullable String version, @Nullable String serialNumber, @Nullable String signatureAlgorithm, @Nullable String issuer, @Nullable StixInstant validityNotBefore, @Nullable StixInstant validityNotAfter, @Nullable String subject, @Nullable String subjectPublicKeyAlgorithm, @Nullable String subjectPublicKeyModulus, @Nullable Long subjectPublicKeyExponent, @Nullable X509v3ExtensionsObj x509V3Extensions, String type, ImmutableSet<CyberObservableExtension> extensions, String observableObjectKey, @Nullable Boolean defanged, ImmutableMap<String, Object> customProperties, ImmutableSet<MarkingDefinitionDm> objectMarkingRefs, ImmutableSet<GranularMarkingDm> granularMarkings, boolean hydrated, String toJsonString) {
        this.isSelfSigned = isSelfSigned;
        this.hashes = hashes;
        this.version = version;
        this.serialNumber = serialNumber;
        this.signatureAlgorithm = signatureAlgorithm;
        this.issuer = issuer;
        this.validityNotBefore = validityNotBefore;
        this.validityNotAfter = validityNotAfter;
        this.subject = subject;
        this.subjectPublicKeyAlgorithm = subjectPublicKeyAlgorithm;
        this.subjectPublicKeyModulus = subjectPublicKeyModulus;
        this.subjectPublicKeyExponent = subjectPublicKeyExponent;
        this.x509V3Extensions = x509V3Extensions;
        this.type = type;
        this.initShim.extensions(extensions);
        this.initShim.observableObjectKey(observableObjectKey);
        this.defanged = defanged;
        this.customProperties = customProperties;
        this.objectMarkingRefs = objectMarkingRefs;
        this.granularMarkings = granularMarkings;
        this.hydrated = hydrated;
        this.toJsonString = toJsonString;
        this.id = this.initShim.getId();
        this.extensions = this.initShim.getExtensions();
        this.observableObjectKey = this.initShim.getObservableObjectKey();
        this.initShim = null;
    }

    private String getIdInitialize() {
        return X509CertificateCoo.super.getId();
    }

    private Set<CyberObservableExtension> getExtensionsInitialize() {
        return X509CertificateCoo.super.getExtensions();
    }

    private String getObservableObjectKeyInitialize() {
        return X509CertificateCoo.super.getObservableObjectKey();
    }

    @Override
    @JsonProperty(value="is_self_signed")
    @JsonPropertyDescription(value="Specifies whether the certificate is self-signed, i.e., whether it is signed by the same entity whose identity it certifies.")
    public Optional<Boolean> isSelfSigned() {
        return Optional.ofNullable(this.isSelfSigned);
    }

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were calculated for the entire contents of the certificate.")
    public ImmutableMap<String, String> getHashes() {
        return this.hashes;
    }

    @Override
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the version of the encoded certificate.")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="serial_number")
    @JsonPropertyDescription(value="Specifies the unique identifier for the certificate, as issued by a specific Certificate Authority.")
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(this.serialNumber);
    }

    @Override
    @JsonProperty(value="signature_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the algorithm used to sign the certificate.")
    public Optional<String> getSignatureAlgorithm() {
        return Optional.ofNullable(this.signatureAlgorithm);
    }

    @Override
    @JsonProperty(value="issuer")
    @JsonPropertyDescription(value="Specifies the name of the Certificate Authority that issued the certificate.")
    public Optional<String> getIssuer() {
        return Optional.ofNullable(this.issuer);
    }

    @Override
    @JsonProperty(value="validity_not_before")
    @JsonPropertyDescription(value="Specifies the date on which the certificate validity period begins.")
    public Optional<StixInstant> getValidityNotBefore() {
        return Optional.ofNullable(this.validityNotBefore);
    }

    @Override
    @JsonProperty(value="validity_not_after")
    @JsonPropertyDescription(value="Specifies the date on which the certificate validity period ends.")
    public Optional<StixInstant> getValidityNotAfter() {
        return Optional.ofNullable(this.validityNotAfter);
    }

    @Override
    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="Specifies the name of the entity associated with the public key stored in the subject public key field of the certificate.")
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    @Override
    @JsonProperty(value="subject_public_key_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the algorithm with which to encrypt data being sent to the subject.")
    public Optional<String> getSubjectPublicKeyAlgorithm() {
        return Optional.ofNullable(this.subjectPublicKeyAlgorithm);
    }

    @Override
    @JsonProperty(value="subject_public_key_modulus")
    @JsonPropertyDescription(value="Specifies the modulus portion of the subject\u2019s public RSA key.")
    public Optional<String> getSubjectPublicKeyModulus() {
        return Optional.ofNullable(this.subjectPublicKeyModulus);
    }

    @Override
    @JsonProperty(value="subject_public_key_exponent")
    @JsonPropertyDescription(value="Specifies the exponent portion of the subject\u2019s public RSA key, as an integer.")
    public Optional<Long> getSubjectPublicKeyExponent() {
        return Optional.ofNullable(this.subjectPublicKeyExponent);
    }

    @Override
    @JsonProperty(value="x509_v3_extensions")
    @JsonPropertyDescription(value="Specifies any standard X.509 v3 extensions that may be used in the certificate.")
    public Optional<X509v3ExtensionsObj> getX509V3Extensions() {
        return Optional.ofNullable(this.x509V3Extensions);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="extensions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
    @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
    @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
    public ImmutableSet<CyberObservableExtension> getExtensions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExtensions() : this.extensions;
    }

    @Override
    @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
    public String getObservableObjectKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObservableObjectKey() : this.observableObjectKey;
    }

    @Override
    @JsonProperty(value="defanged")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
    public Optional<Boolean> getDefanged() {
        return Optional.ofNullable(this.defanged);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    @JsonProperty(value="objectMarkingRefs")
    public ImmutableSet<MarkingDefinitionDm> getObjectMarkingRefs() {
        return this.objectMarkingRefs;
    }

    @JsonProperty(value="granularMarkings")
    public ImmutableSet<GranularMarkingDm> getGranularMarkings() {
        return this.granularMarkings;
    }

    @Override
    @JsonProperty(value="hydrated")
    public boolean getHydrated() {
        return this.hydrated;
    }

    @Override
    @JsonProperty(value="toJsonString")
    public String toJsonString() {
        return this.toJsonString;
    }

    public final X509Certificate withIsSelfSigned(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isSelfSigned, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(newValue, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withIsSelfSigned(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isSelfSigned, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(value, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withHashes(Map<String, ? extends String> entries) {
        if (this.hashes == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, (ImmutableMap<String, String>)newValue, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, newValue, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, value, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSerialNumber(String value) {
        String newValue = Objects.requireNonNull(value, "serialNumber");
        if (Objects.equals(this.serialNumber, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, newValue, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSerialNumber(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serialNumber, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, value, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSignatureAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "signatureAlgorithm");
        if (Objects.equals(this.signatureAlgorithm, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, newValue, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSignatureAlgorithm(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.signatureAlgorithm, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, value, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withIssuer(String value) {
        String newValue = Objects.requireNonNull(value, "issuer");
        if (Objects.equals(this.issuer, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, newValue, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withIssuer(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.issuer, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, value, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withValidityNotBefore(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "validityNotBefore");
        if (this.validityNotBefore == newValue) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, newValue, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withValidityNotBefore(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.validityNotBefore == value) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, value, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withValidityNotAfter(StixInstant value) {
        StixInstant newValue = Objects.requireNonNull(value, "validityNotAfter");
        if (this.validityNotAfter == newValue) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, newValue, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withValidityNotAfter(Optional<? extends StixInstant> optional) {
        StixInstant value = optional.orElse(null);
        if (this.validityNotAfter == value) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, value, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubject(String value) {
        String newValue = Objects.requireNonNull(value, "subject");
        if (Objects.equals(this.subject, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, newValue, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubject(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subject, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, value, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyAlgorithm(String value) {
        String newValue = Objects.requireNonNull(value, "subjectPublicKeyAlgorithm");
        if (Objects.equals(this.subjectPublicKeyAlgorithm, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, newValue, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyAlgorithm(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subjectPublicKeyAlgorithm, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, value, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyModulus(String value) {
        String newValue = Objects.requireNonNull(value, "subjectPublicKeyModulus");
        if (Objects.equals(this.subjectPublicKeyModulus, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, newValue, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyModulus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subjectPublicKeyModulus, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, value, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyExponent(long value) {
        Long newValue = value;
        if (Objects.equals(this.subjectPublicKeyExponent, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, newValue, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withSubjectPublicKeyExponent(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.subjectPublicKeyExponent, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, value, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withX509V3Extensions(X509v3ExtensionsObj value) {
        X509v3ExtensionsObj newValue = Objects.requireNonNull(value, "x509V3Extensions");
        if (this.x509V3Extensions == newValue) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, newValue, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withX509V3Extensions(Optional<? extends X509v3ExtensionsObj> optional) {
        X509v3ExtensionsObj value = optional.orElse(null);
        if (this.x509V3Extensions == value) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, value, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, value, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withExtensions(CyberObservableExtension ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withExtensions(Iterable<? extends CyberObservableExtension> elements) {
        if (this.extensions == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, (ImmutableSet<CyberObservableExtension>)newValue, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withObservableObjectKey(String value) {
        String newValue = Objects.requireNonNull(value, "observableObjectKey");
        if (this.observableObjectKey.equals(newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, newValue, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withDefanged(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defanged, newValue)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, newValue, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withDefanged(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defanged, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, value, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, (ImmutableMap<String, Object>)newValue, this.objectMarkingRefs, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withObjectMarkingRefs(MarkingDefinitionDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
        if (this.objectMarkingRefs == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, (ImmutableSet<MarkingDefinitionDm>)newValue, this.granularMarkings, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withGranularMarkings(GranularMarkingDm ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
        if (this.granularMarkings == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, (ImmutableSet<GranularMarkingDm>)newValue, this.hydrated, this.toJsonString));
    }

    public final X509Certificate withHydrated(boolean value) {
        if (this.hydrated == value) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, value, this.toJsonString));
    }

    public final X509Certificate withToJsonString(String value) {
        if (Objects.equals(this.toJsonString, value)) {
            return this;
        }
        return X509Certificate.validate(new X509Certificate(this.isSelfSigned, this.hashes, this.version, this.serialNumber, this.signatureAlgorithm, this.issuer, this.validityNotBefore, this.validityNotAfter, this.subject, this.subjectPublicKeyAlgorithm, this.subjectPublicKeyModulus, this.subjectPublicKeyExponent, this.x509V3Extensions, this.type, this.extensions, this.observableObjectKey, this.defanged, this.customProperties, this.objectMarkingRefs, this.granularMarkings, this.hydrated, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof X509Certificate && this.equalTo((X509Certificate)another);
    }

    private boolean equalTo(X509Certificate another) {
        return Objects.equals(this.isSelfSigned, another.isSelfSigned) && this.hashes.equals(another.hashes) && Objects.equals(this.version, another.version) && Objects.equals(this.serialNumber, another.serialNumber) && Objects.equals(this.signatureAlgorithm, another.signatureAlgorithm) && Objects.equals(this.issuer, another.issuer) && Objects.equals(this.validityNotBefore, another.validityNotBefore) && Objects.equals(this.validityNotAfter, another.validityNotAfter) && Objects.equals(this.subject, another.subject) && Objects.equals(this.subjectPublicKeyAlgorithm, another.subjectPublicKeyAlgorithm) && Objects.equals(this.subjectPublicKeyModulus, another.subjectPublicKeyModulus) && Objects.equals(this.subjectPublicKeyExponent, another.subjectPublicKeyExponent) && Objects.equals(this.x509V3Extensions, another.x509V3Extensions) && this.id.equals(another.id) && Objects.equals(this.type, another.type) && this.extensions.equals(another.extensions) && this.observableObjectKey.equals(another.observableObjectKey) && Objects.equals(this.defanged, another.defanged) && this.customProperties.equals(another.customProperties) && this.objectMarkingRefs.equals(another.objectMarkingRefs) && this.granularMarkings.equals(another.granularMarkings) && this.hydrated == another.hydrated && Objects.equals(this.toJsonString, another.toJsonString);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.isSelfSigned);
        h += (h << 5) + this.hashes.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.serialNumber);
        h += (h << 5) + Objects.hashCode(this.signatureAlgorithm);
        h += (h << 5) + Objects.hashCode(this.issuer);
        h += (h << 5) + Objects.hashCode(this.validityNotBefore);
        h += (h << 5) + Objects.hashCode(this.validityNotAfter);
        h += (h << 5) + Objects.hashCode(this.subject);
        h += (h << 5) + Objects.hashCode(this.subjectPublicKeyAlgorithm);
        h += (h << 5) + Objects.hashCode(this.subjectPublicKeyModulus);
        h += (h << 5) + Objects.hashCode(this.subjectPublicKeyExponent);
        h += (h << 5) + Objects.hashCode(this.x509V3Extensions);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.extensions.hashCode();
        h += (h << 5) + this.observableObjectKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defanged);
        h += (h << 5) + this.customProperties.hashCode();
        h += (h << 5) + this.objectMarkingRefs.hashCode();
        h += (h << 5) + this.granularMarkings.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hydrated);
        h += (h << 5) + Objects.hashCode(this.toJsonString);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"X509Certificate").omitNullValues().add("isSelfSigned", (Object)this.isSelfSigned).add("hashes", this.hashes).add("version", (Object)this.version).add("serialNumber", (Object)this.serialNumber).add("signatureAlgorithm", (Object)this.signatureAlgorithm).add("issuer", (Object)this.issuer).add("validityNotBefore", (Object)this.validityNotBefore).add("validityNotAfter", (Object)this.validityNotAfter).add("subject", (Object)this.subject).add("subjectPublicKeyAlgorithm", (Object)this.subjectPublicKeyAlgorithm).add("subjectPublicKeyModulus", (Object)this.subjectPublicKeyModulus).add("subjectPublicKeyExponent", (Object)this.subjectPublicKeyExponent).add("x509V3Extensions", (Object)this.x509V3Extensions).add("id", (Object)this.id).add("type", (Object)this.type).add("extensions", this.extensions).add("observableObjectKey", (Object)this.observableObjectKey).add("defanged", (Object)this.defanged).add("customProperties", this.customProperties).add("objectMarkingRefs", this.objectMarkingRefs).add("granularMarkings", this.granularMarkings).add("hydrated", this.hydrated).add("toJsonString", (Object)this.toJsonString).toString();
    }

    private static X509Certificate validate(X509Certificate instance) {
        instance.validateEntity();
        return instance;
    }

    public static X509Certificate copyOf(X509CertificateCoo instance) {
        if (instance instanceof X509Certificate) {
            return (X509Certificate)instance;
        }
        return X509Certificate.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return X509Certificate.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonTypeName(value="x509-certificate")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @JsonPropertyOrder(value={"type", "extensions", "is_self_signed", "hashes", "version", "serial_number", "signature_algorithm", "issuer", "validity_not_before", "validity_not_after", "subject", "subject_public_key_algorithm", "subject_public_key_modulus", "subject_public_key_exponent", "x509_v3_extensions"})
    @Generated(from="X509CertificateCoo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXTENSIONS = 1L;
        private long optBits;
        @Nullable
        private Boolean isSelfSigned;
        private ImmutableMap.Builder<String, String> hashes = ImmutableMap.builder();
        @Nullable
        private String version;
        @Nullable
        private String serialNumber;
        @Nullable
        private String signatureAlgorithm;
        @Nullable
        private String issuer;
        @Nullable
        private StixInstant validityNotBefore;
        @Nullable
        private StixInstant validityNotAfter;
        @Nullable
        private String subject;
        @Nullable
        private String subjectPublicKeyAlgorithm;
        @Nullable
        private String subjectPublicKeyModulus;
        @Nullable
        private Long subjectPublicKeyExponent;
        @Nullable
        private X509v3ExtensionsObj x509V3Extensions;
        @Nullable
        private String type;
        private ImmutableSet.Builder<CyberObservableExtension> extensions = ImmutableSet.builder();
        @Nullable
        private String observableObjectKey;
        @Nullable
        private Boolean defanged;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();
        private ImmutableSet.Builder<MarkingDefinitionDm> objectMarkingRefs = ImmutableSet.builder();
        private ImmutableSet.Builder<GranularMarkingDm> granularMarkings = ImmutableSet.builder();
        private boolean hydrated;
        @Nullable
        private String toJsonString;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BundleableObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(X509CertificateCoo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CyberObservableObjectCommonProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String typeValue;
            Object instance;
            long bits = 0L;
            if (object instanceof BundleableObject) {
                instance = (BundleableObject)object;
                this.addAllObjectMarkingRefs(instance.getObjectMarkingRefs());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.hydrated(instance.getHydrated());
                this.addAllGranularMarkings(instance.getGranularMarkings());
                String toJsonStringValue = instance.toJsonString();
                if (toJsonStringValue != null) {
                    this.toJsonString(toJsonStringValue);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
            if (object instanceof X509CertificateCoo) {
                Optional<X509v3ExtensionsObj> x509V3ExtensionsOptional;
                Optional<String> subjectPublicKeyModulusOptional;
                Optional<Boolean> isSelfSignedOptional;
                Optional<String> subjectPublicKeyAlgorithmOptional;
                Optional<String> issuerOptional;
                Optional<String> signatureAlgorithmOptional;
                Optional<String> versionOptional;
                Optional<StixInstant> validityNotBeforeOptional;
                Optional<String> subjectOptional;
                Optional<String> serialNumberOptional;
                instance = (X509CertificateCoo)object;
                Optional<Long> subjectPublicKeyExponentOptional = instance.getSubjectPublicKeyExponent();
                if (subjectPublicKeyExponentOptional.isPresent()) {
                    this.subjectPublicKeyExponent(subjectPublicKeyExponentOptional);
                }
                if ((serialNumberOptional = instance.getSerialNumber()).isPresent()) {
                    this.serialNumber(serialNumberOptional);
                }
                if ((subjectOptional = instance.getSubject()).isPresent()) {
                    this.subject(subjectOptional);
                }
                if ((validityNotBeforeOptional = instance.getValidityNotBefore()).isPresent()) {
                    this.validityNotBefore(validityNotBeforeOptional);
                }
                if ((versionOptional = instance.getVersion()).isPresent()) {
                    this.version(versionOptional);
                }
                if ((signatureAlgorithmOptional = instance.getSignatureAlgorithm()).isPresent()) {
                    this.signatureAlgorithm(signatureAlgorithmOptional);
                }
                if ((issuerOptional = instance.getIssuer()).isPresent()) {
                    this.issuer(issuerOptional);
                }
                if ((subjectPublicKeyAlgorithmOptional = instance.getSubjectPublicKeyAlgorithm()).isPresent()) {
                    this.subjectPublicKeyAlgorithm(subjectPublicKeyAlgorithmOptional);
                }
                if ((isSelfSignedOptional = instance.isSelfSigned()).isPresent()) {
                    this.isSelfSigned(isSelfSignedOptional);
                }
                if ((subjectPublicKeyModulusOptional = instance.getSubjectPublicKeyModulus()).isPresent()) {
                    this.subjectPublicKeyModulus(subjectPublicKeyModulusOptional);
                }
                if ((x509V3ExtensionsOptional = instance.getX509V3Extensions()).isPresent()) {
                    this.x509V3Extensions(x509V3ExtensionsOptional);
                }
                this.putAllHashes(instance.getHashes());
                Optional<StixInstant> validityNotAfterOptional = instance.getValidityNotAfter();
                if (validityNotAfterOptional.isPresent()) {
                    this.validityNotAfter(validityNotAfterOptional);
                }
            }
            if (object instanceof CyberObservableObjectCommonProperties) {
                instance = (CyberObservableObjectCommonProperties)object;
                this.addAllExtensions(instance.getExtensions());
                if ((bits & 1L) == 0L) {
                    typeValue = instance.getType();
                    if (typeValue != null) {
                        this.type(typeValue);
                    }
                    bits |= 1L;
                }
                this.observableObjectKey(instance.getObservableObjectKey());
                Optional<Boolean> defangedOptional = instance.getDefanged();
                if (defangedOptional.isPresent()) {
                    this.defanged(defangedOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder isSelfSigned(boolean isSelfSigned) {
            this.isSelfSigned = isSelfSigned;
            return this;
        }

        @JsonProperty(value="is_self_signed")
        @JsonPropertyDescription(value="Specifies whether the certificate is self-signed, i.e., whether it is signed by the same entity whose identity it certifies.")
        @CanIgnoreReturnValue
        public final Builder isSelfSigned(Optional<Boolean> isSelfSigned) {
            this.isSelfSigned = isSelfSigned.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(String key, String value) {
            this.hashes.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHash(Map.Entry<String, ? extends String> entry) {
            this.hashes.put(entry);
            return this;
        }

        @JsonProperty(value="hashes")
        @JsonPropertyDescription(value="Specifies any hashes that were calculated for the entire contents of the certificate.")
        @CanIgnoreReturnValue
        public final Builder hashes(Map<String, ? extends String> entries) {
            this.hashes = ImmutableMap.builder();
            return this.putAllHashes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHashes(Map<String, ? extends String> entries) {
            this.hashes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @JsonPropertyDescription(value="Specifies the version of the encoded certificate.")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = Objects.requireNonNull(serialNumber, "serialNumber");
            return this;
        }

        @JsonProperty(value="serial_number")
        @JsonPropertyDescription(value="Specifies the unique identifier for the certificate, as issued by a specific Certificate Authority.")
        @CanIgnoreReturnValue
        public final Builder serialNumber(Optional<String> serialNumber) {
            this.serialNumber = serialNumber.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
            return this;
        }

        @JsonProperty(value="signature_algorithm")
        @JsonPropertyDescription(value="Specifies the name of the algorithm used to sign the certificate.")
        @CanIgnoreReturnValue
        public final Builder signatureAlgorithm(Optional<String> signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(String issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            return this;
        }

        @JsonProperty(value="issuer")
        @JsonPropertyDescription(value="Specifies the name of the Certificate Authority that issued the certificate.")
        @CanIgnoreReturnValue
        public final Builder issuer(Optional<String> issuer) {
            this.issuer = issuer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validityNotBefore(StixInstant validityNotBefore) {
            this.validityNotBefore = Objects.requireNonNull(validityNotBefore, "validityNotBefore");
            return this;
        }

        @JsonProperty(value="validity_not_before")
        @JsonPropertyDescription(value="Specifies the date on which the certificate validity period begins.")
        @CanIgnoreReturnValue
        public final Builder validityNotBefore(Optional<? extends StixInstant> validityNotBefore) {
            this.validityNotBefore = validityNotBefore.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validityNotAfter(StixInstant validityNotAfter) {
            this.validityNotAfter = Objects.requireNonNull(validityNotAfter, "validityNotAfter");
            return this;
        }

        @JsonProperty(value="validity_not_after")
        @JsonPropertyDescription(value="Specifies the date on which the certificate validity period ends.")
        @CanIgnoreReturnValue
        public final Builder validityNotAfter(Optional<? extends StixInstant> validityNotAfter) {
            this.validityNotAfter = validityNotAfter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subject(String subject) {
            this.subject = Objects.requireNonNull(subject, "subject");
            return this;
        }

        @JsonProperty(value="subject")
        @JsonPropertyDescription(value="Specifies the name of the entity associated with the public key stored in the subject public key field of the certificate.")
        @CanIgnoreReturnValue
        public final Builder subject(Optional<String> subject) {
            this.subject = subject.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyAlgorithm(String subjectPublicKeyAlgorithm) {
            this.subjectPublicKeyAlgorithm = Objects.requireNonNull(subjectPublicKeyAlgorithm, "subjectPublicKeyAlgorithm");
            return this;
        }

        @JsonProperty(value="subject_public_key_algorithm")
        @JsonPropertyDescription(value="Specifies the name of the algorithm with which to encrypt data being sent to the subject.")
        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyAlgorithm(Optional<String> subjectPublicKeyAlgorithm) {
            this.subjectPublicKeyAlgorithm = subjectPublicKeyAlgorithm.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyModulus(String subjectPublicKeyModulus) {
            this.subjectPublicKeyModulus = Objects.requireNonNull(subjectPublicKeyModulus, "subjectPublicKeyModulus");
            return this;
        }

        @JsonProperty(value="subject_public_key_modulus")
        @JsonPropertyDescription(value="Specifies the modulus portion of the subject\u2019s public RSA key.")
        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyModulus(Optional<String> subjectPublicKeyModulus) {
            this.subjectPublicKeyModulus = subjectPublicKeyModulus.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyExponent(long subjectPublicKeyExponent) {
            this.subjectPublicKeyExponent = subjectPublicKeyExponent;
            return this;
        }

        @JsonProperty(value="subject_public_key_exponent")
        @JsonPropertyDescription(value="Specifies the exponent portion of the subject\u2019s public RSA key, as an integer.")
        @CanIgnoreReturnValue
        public final Builder subjectPublicKeyExponent(Optional<Long> subjectPublicKeyExponent) {
            this.subjectPublicKeyExponent = subjectPublicKeyExponent.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder x509V3Extensions(X509v3ExtensionsObj x509V3Extensions) {
            this.x509V3Extensions = Objects.requireNonNull(x509V3Extensions, "x509V3Extensions");
            return this;
        }

        @JsonProperty(value="x509_v3_extensions")
        @JsonPropertyDescription(value="Specifies any standard X.509 v3 extensions that may be used in the certificate.")
        @CanIgnoreReturnValue
        public final Builder x509V3Extensions(Optional<? extends X509v3ExtensionsObj> x509V3Extensions) {
            this.x509V3Extensions = x509V3Extensions.orElse(null);
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtension(@Nullable CyberObservableExtension element) {
            this.extensions.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExtensions(CyberObservableExtension ... elements) {
            this.extensions.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="extensions")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Specifies any extensions of the object, as a dictionary.")
        @JsonSerialize(using=CyberObservableExtensionsFieldSerializer.class)
        @JsonDeserialize(using=CyberObservableExtensionsFieldDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder extensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions = ImmutableSet.builder();
            return this.addAllExtensions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExtensions(Iterable<? extends CyberObservableExtension> elements) {
            this.extensions.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="observable_object_key", access=JsonProperty.Access.WRITE_ONLY)
        @CanIgnoreReturnValue
        public final Builder observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = Objects.requireNonNull(observableObjectKey, "observableObjectKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defanged(boolean defanged) {
            this.defanged = defanged;
            return this;
        }

        @JsonProperty(value="defanged")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonPropertyDescription(value="Indicates whether the data contained in the SCO has been defanged.")
        @CanIgnoreReturnValue
        public final Builder defanged(Optional<Boolean> defanged) {
            this.defanged = defanged.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRef(@Nullable MarkingDefinitionDm element) {
            this.objectMarkingRefs.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addObjectMarkingRefs(MarkingDefinitionDm ... elements) {
            this.objectMarkingRefs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="objectMarkingRefs")
        @CanIgnoreReturnValue
        public final Builder objectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs = ImmutableSet.builder();
            return this.addAllObjectMarkingRefs(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllObjectMarkingRefs(Iterable<? extends MarkingDefinitionDm> elements) {
            this.objectMarkingRefs.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarking(@Nullable GranularMarkingDm element) {
            this.granularMarkings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGranularMarkings(GranularMarkingDm ... elements) {
            this.granularMarkings.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="granularMarkings")
        @CanIgnoreReturnValue
        public final Builder granularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings = ImmutableSet.builder();
            return this.addAllGranularMarkings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGranularMarkings(Iterable<? extends GranularMarkingDm> elements) {
            this.granularMarkings.addAll(elements);
            return this;
        }

        @JsonProperty(value="hydrated")
        @CanIgnoreReturnValue
        public final Builder hydrated(boolean hydrated) {
            this.hydrated = hydrated;
            return this;
        }

        @JsonProperty(value="toJsonString")
        @CanIgnoreReturnValue
        public final Builder toJsonString(String toJsonString) {
            this.toJsonString = toJsonString;
            return this;
        }

        public X509Certificate build() {
            return X509Certificate.validate(new X509Certificate(this));
        }

        private boolean extensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="X509CertificateCoo", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte extensionsBuildStage = 0;
        private ImmutableSet<CyberObservableExtension> extensions;
        private byte observableObjectKeyBuildStage = 0;
        private String observableObjectKey;

        private InitShim() {
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(X509Certificate.this.getIdInitialize(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableSet<CyberObservableExtension> getExtensions() {
            if (this.extensionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.extensionsBuildStage == 0) {
                this.extensionsBuildStage = (byte)-1;
                this.extensions = ImmutableSet.copyOf((Collection)X509Certificate.this.getExtensionsInitialize());
                this.extensionsBuildStage = 1;
            }
            return this.extensions;
        }

        void extensions(ImmutableSet<CyberObservableExtension> extensions) {
            this.extensions = extensions;
            this.extensionsBuildStage = 1;
        }

        String getObservableObjectKey() {
            if (this.observableObjectKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.observableObjectKeyBuildStage == 0) {
                this.observableObjectKeyBuildStage = (byte)-1;
                this.observableObjectKey = Objects.requireNonNull(X509Certificate.this.getObservableObjectKeyInitialize(), "observableObjectKey");
                this.observableObjectKeyBuildStage = 1;
            }
            return this.observableObjectKey;
        }

        void observableObjectKey(String observableObjectKey) {
            this.observableObjectKey = observableObjectKey;
            this.observableObjectKeyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.extensionsBuildStage == -1) {
                attributes.add("extensions");
            }
            if (this.observableObjectKeyBuildStage == -1) {
                attributes.add("observableObjectKey");
            }
            return "Cannot build X509Certificate, attribute initializers form cycle " + attributes;
        }
    }
}

