/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.hibernate.validator.constraints.Length;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixInstant;
import security.whisper.javastix.coo.CyberObservableObject;
import security.whisper.javastix.coo.objects.X509Certificate;
import security.whisper.javastix.coo.types.X509v3ExtensionsObj;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;
import security.whisper.javastix.validation.constraints.defaulttypevalue.DefaultTypeValue;
import security.whisper.javastix.validation.constraints.hashingvocab.HashingVocab;
import security.whisper.javastix.validation.groups.DefaultValuesProcessor;
import security.whisper.javastix.vocabulary.vocabularies.HashingAlgorithms;

@DefaultTypeValue(value="x509-certificate", groups={DefaultValuesProcessor.class})
@JsonTypeName(value="x509-certificate")
@JsonSerialize(as=X509Certificate.class)
@JsonDeserialize(builder=X509Certificate.Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"type", "extensions", "is_self_signed", "hashes", "version", "serial_number", "signature_algorithm", "issuer", "validity_not_before", "validity_not_after", "subject", "subject_public_key_algorithm", "subject_public_key_modulus", "subject_public_key_exponent", "x509_v3_extensions"})
@BusinessRule(ifExp="true", thenExp="isSelfSigned().isPresent() == true || getHashes().isEmpty() == false || getVersion().isPresent() == true || getSerialNumber().isPresent() == true || getSignatureAlgorithm().isPresent() == true || getIssuer().isPresent() == true || getValidityNotBefore().isPresent() == true || getValidityNotAfter().isPresent() == true || getSubject().isPresent() == true || getSubjectPublicKeyAlgorithm().isPresent() == true || getSubjectPublicKeyModulus().isPresent() == true || getSubjectPublicKeyExponent().isPresent() == true || getX509V3Extensions().isPresent() == true", errorMessage="At least 1 property must be provided")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Coo"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true, depluralizeDictionary={"hash:hashes"})
public interface X509CertificateCoo
extends CyberObservableObject {
    @JsonProperty(value="is_self_signed")
    @JsonPropertyDescription(value="Specifies whether the certificate is self-signed, i.e., whether it is signed by the same entity whose identity it certifies.")
    public Optional<Boolean> isSelfSigned();

    @JsonProperty(value="hashes")
    @JsonPropertyDescription(value="Specifies any hashes that were calculated for the entire contents of the certificate.")
    public Map<@Length(min=3, max=256) @HashingVocab(value=HashingAlgorithms.class) String, String> getHashes();

    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Specifies the version of the encoded certificate.")
    public Optional<String> getVersion();

    @JsonProperty(value="serial_number")
    @JsonPropertyDescription(value="Specifies the unique identifier for the certificate, as issued by a specific Certificate Authority.")
    public Optional<String> getSerialNumber();

    @JsonProperty(value="signature_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the algorithm used to sign the certificate.")
    public Optional<String> getSignatureAlgorithm();

    @JsonProperty(value="issuer")
    @JsonPropertyDescription(value="Specifies the name of the Certificate Authority that issued the certificate.")
    public Optional<String> getIssuer();

    @JsonProperty(value="validity_not_before")
    @JsonPropertyDescription(value="Specifies the date on which the certificate validity period begins.")
    public Optional<StixInstant> getValidityNotBefore();

    @JsonProperty(value="validity_not_after")
    @JsonPropertyDescription(value="Specifies the date on which the certificate validity period ends.")
    public Optional<StixInstant> getValidityNotAfter();

    @JsonProperty(value="subject")
    @JsonPropertyDescription(value="Specifies the name of the entity associated with the public key stored in the subject public key field of the certificate.")
    public Optional<String> getSubject();

    @JsonProperty(value="subject_public_key_algorithm")
    @JsonPropertyDescription(value="Specifies the name of the algorithm with which to encrypt data being sent to the subject.")
    public Optional<String> getSubjectPublicKeyAlgorithm();

    @JsonProperty(value="subject_public_key_modulus")
    @JsonPropertyDescription(value="Specifies the modulus portion of the subject\u2019s public RSA key.")
    public Optional<String> getSubjectPublicKeyModulus();

    @JsonProperty(value="subject_public_key_exponent")
    @JsonPropertyDescription(value="Specifies the exponent portion of the subject\u2019s public RSA key, as an integer.")
    public Optional<Long> getSubjectPublicKeyExponent();

    @JsonProperty(value="x509_v3_extensions")
    @JsonPropertyDescription(value="Specifies any standard X.509 v3 extensions that may be used in the certificate.")
    public Optional<X509v3ExtensionsObj> getX509V3Extensions();

    @Override
    @Value.Derived
    default public String getId() {
        StringBuilder identifier = new StringBuilder();
        if (this.getSerialNumber().isPresent()) {
            identifier.append(this.getSerialNumber().get());
        } else if (this.getHashes() != null && !this.getHashes().isEmpty()) {
            identifier.append(this.getHashes().entrySet().stream().sorted(Map.Entry.comparingByKey()).findFirst().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).orElse(""));
        } else if (this.getSubject().isPresent()) {
            identifier.append(this.getSubject().get());
        }
        if (identifier.length() == 0) {
            identifier.append("x509:unknown");
        }
        return "x509-certificate--" + UUID.nameUUIDFromBytes(identifier.toString().getBytes(StandardCharsets.UTF_8));
    }
}

