/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.MimePartTypeObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MimePartTypeObj", generator="Immutables")
@Immutable
public final class MimePartType
implements MimePartTypeObj {
    @Nullable
    private final String body;
    @Nullable
    private final String bodyRawRef;
    @Nullable
    private final String contentType;
    @Nullable
    private final String contentDisposition;
    private final ImmutableMap<String, Object> customProperties;
    private static final long serialVersionUID = 1L;

    private MimePartType(@Nullable String body, @Nullable String bodyRawRef, @Nullable String contentType, @Nullable String contentDisposition, ImmutableMap<String, Object> customProperties) {
        this.body = body;
        this.bodyRawRef = bodyRawRef;
        this.contentType = contentType;
        this.contentDisposition = contentDisposition;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="body")
    @JsonPropertyDescription(value="Specifies the contents of the MIME part if the content_type is not provided OR starts with text/")
    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    @Override
    @JsonProperty(value="body_raw_ref")
    @JsonPropertyDescription(value="Specifies the contents of non-textual MIME parts, that is those whose content_type does not start with text/")
    public Optional<String> getBodyRawRef() {
        return Optional.ofNullable(this.bodyRawRef);
    }

    @Override
    @JsonProperty(value="content_type")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header field of the MIME part.")
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @Override
    @JsonProperty(value="content_disposition")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Disposition' header field of the MIME part.")
    public Optional<String> getContentDisposition() {
        return Optional.ofNullable(this.contentDisposition);
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @JsonUnwrapped
    @JsonAnyGetter
    public ImmutableMap<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public final MimePartType withBody(String value) {
        String newValue = Objects.requireNonNull(value, "body");
        if (Objects.equals(this.body, newValue)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(newValue, this.bodyRawRef, this.contentType, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withBody(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.body, value)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(value, this.bodyRawRef, this.contentType, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withBodyRawRef(String value) {
        String newValue = Objects.requireNonNull(value, "bodyRawRef");
        if (Objects.equals(this.bodyRawRef, newValue)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, newValue, this.contentType, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withBodyRawRef(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.bodyRawRef, value)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, value, this.contentType, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (Objects.equals(this.contentType, newValue)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, newValue, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withContentType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contentType, value)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, value, this.contentDisposition, this.customProperties));
    }

    public final MimePartType withContentDisposition(String value) {
        String newValue = Objects.requireNonNull(value, "contentDisposition");
        if (Objects.equals(this.contentDisposition, newValue)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, newValue, this.customProperties));
    }

    public final MimePartType withContentDisposition(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.contentDisposition, value)) {
            return this;
        }
        return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, value, this.customProperties));
    }

    public final MimePartType withCustomProperties(Map<String, ? extends Object> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, this.contentDisposition, (ImmutableMap<String, Object>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MimePartType && this.equalTo((MimePartType)another);
    }

    private boolean equalTo(MimePartType another) {
        return Objects.equals(this.body, another.body) && Objects.equals(this.bodyRawRef, another.bodyRawRef) && Objects.equals(this.contentType, another.contentType) && Objects.equals(this.contentDisposition, another.contentDisposition) && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.body);
        h += (h << 5) + Objects.hashCode(this.bodyRawRef);
        h += (h << 5) + Objects.hashCode(this.contentType);
        h += (h << 5) + Objects.hashCode(this.contentDisposition);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MimePartType").omitNullValues().add("body", (Object)this.body).add("bodyRawRef", (Object)this.bodyRawRef).add("contentType", (Object)this.contentType).add("contentDisposition", (Object)this.contentDisposition).add("customProperties", this.customProperties).toString();
    }

    private static MimePartType validate(MimePartType instance) {
        instance.validateEntity();
        return instance;
    }

    public static MimePartType copyOf(MimePartTypeObj instance) {
        if (instance instanceof MimePartType) {
            return (MimePartType)instance;
        }
        return MimePartType.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return MimePartType.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPropertyOrder(value={"body", "body_raw_ref", "content_type", "content_disposition"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    @Generated(from="MimePartTypeObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String body;
        @Nullable
        private String bodyRawRef;
        @Nullable
        private String contentType;
        @Nullable
        private String contentDisposition;
        private ImmutableMap.Builder<String, Object> customProperties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MimePartTypeObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StixCustomProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StixCustomProperties instance;
            if (object instanceof MimePartTypeObj) {
                Optional<String> contentTypeOptional;
                Optional<String> bodyOptional;
                Optional<String> bodyRawRefOptional;
                instance = (MimePartTypeObj)object;
                Optional<String> contentDispositionOptional = instance.getContentDisposition();
                if (contentDispositionOptional.isPresent()) {
                    this.contentDisposition(contentDispositionOptional);
                }
                if ((bodyRawRefOptional = instance.getBodyRawRef()).isPresent()) {
                    this.bodyRawRef(bodyRawRefOptional);
                }
                if ((bodyOptional = instance.getBody()).isPresent()) {
                    this.body(bodyOptional);
                }
                if ((contentTypeOptional = instance.getContentType()).isPresent()) {
                    this.contentType(contentTypeOptional);
                }
            }
            if (object instanceof StixCustomProperties) {
                instance = (StixCustomProperties)object;
                this.putAllCustomProperties(instance.getCustomProperties());
            }
        }

        @CanIgnoreReturnValue
        public final Builder body(String body) {
            this.body = Objects.requireNonNull(body, "body");
            return this;
        }

        @JsonProperty(value="body")
        @JsonPropertyDescription(value="Specifies the contents of the MIME part if the content_type is not provided OR starts with text/")
        @CanIgnoreReturnValue
        public final Builder body(Optional<String> body) {
            this.body = body.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bodyRawRef(String bodyRawRef) {
            this.bodyRawRef = Objects.requireNonNull(bodyRawRef, "bodyRawRef");
            return this;
        }

        @JsonProperty(value="body_raw_ref")
        @JsonPropertyDescription(value="Specifies the contents of non-textual MIME parts, that is those whose content_type does not start with text/")
        @CanIgnoreReturnValue
        public final Builder bodyRawRef(Optional<String> bodyRawRef) {
            this.bodyRawRef = bodyRawRef.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            return this;
        }

        @JsonProperty(value="content_type")
        @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header field of the MIME part.")
        @CanIgnoreReturnValue
        public final Builder contentType(Optional<String> contentType) {
            this.contentType = contentType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = Objects.requireNonNull(contentDisposition, "contentDisposition");
            return this;
        }

        @JsonProperty(value="content_disposition")
        @JsonPropertyDescription(value="Specifies the value of the 'Content-Disposition' header field of the MIME part.")
        @CanIgnoreReturnValue
        public final Builder contentDisposition(Optional<String> contentDisposition) {
            this.contentDisposition = contentDisposition.orElse(null);
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putCustomProperty(String key, Object value) {
            this.customProperties.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putCustomProperty(Map.Entry<String, ? extends Object> entry) {
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(access=JsonProperty.Access.READ_ONLY)
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder customProperties(Map<String, ? extends Object> entries) {
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllCustomProperties(Map<String, ? extends Object> entries) {
            this.customProperties.putAll(entries);
            return this;
        }

        public MimePartType build() {
            return MimePartType.validate(new MimePartType(this.body, this.bodyRawRef, this.contentType, this.contentDisposition, this.customProperties.build()));
        }
    }
}

