/*
 * Decompiled with CFR 0.152.
 */
package security.whisper.javastix.coo.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Optional;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import security.whisper.javastix.common.StixCustomProperties;
import security.whisper.javastix.coo.types.MimePartType;
import security.whisper.javastix.validation.GenericValidation;
import security.whisper.javastix.validation.constraints.businessrule.BusinessRule;

@JsonSerialize(as=MimePartType.class)
@JsonDeserialize(builder=MimePartType.Builder.class)
@JsonPropertyOrder(value={"body", "body_raw_ref", "content_type", "content_disposition"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
@BusinessRule(ifExp="true", thenExp="getBody().isPresent() == true || getBodyRawRef().isPresent() == true", errorMessage="One of body OR body_raw_ref MUST be included.")
@Value.Immutable
@Serial.Version(value=1L)
@Value.Style(typeAbstract={"*Obj"}, typeImmutable="*", validationMethod=Value.Style.ValidationMethod.NONE, additionalJsonAnnotations={JsonTypeName.class}, depluralize=true)
public interface MimePartTypeObj
extends GenericValidation,
StixCustomProperties,
Serializable {
    @JsonProperty(value="body")
    @JsonPropertyDescription(value="Specifies the contents of the MIME part if the content_type is not provided OR starts with text/")
    public Optional<String> getBody();

    @JsonProperty(value="body_raw_ref")
    @JsonPropertyDescription(value="Specifies the contents of non-textual MIME parts, that is those whose content_type does not start with text/")
    public Optional<String> getBodyRawRef();

    @JsonProperty(value="content_type")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Type' header field of the MIME part.")
    public Optional<String> getContentType();

    @JsonProperty(value="content_disposition")
    @JsonPropertyDescription(value="Specifies the value of the 'Content-Disposition' header field of the MIME part.")
    public Optional<String> getContentDisposition();
}

